/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.PluginWrapper;
import hudson.model.Item;
import hudson.model.Project;
import hudson.util.VersionNumber;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class GitRefSubmoduleChecker
extends AbstractCheck {
    public GitRefSubmoduleChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.GitRefSubmoduleCheckerDesc());
        this.setSeverity(Messages.GitRefSubmoduleCheckerSeverity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean executeCheck(Item item) {
        if (!(item instanceof Project)) return false;
        PluginWrapper plugin = Jenkins.getInstance().pluginManager.getPlugin("git");
        if (plugin != null && plugin.getVersionNumber().isNewerThan(new VersionNumber("2.4.0"))) {
            if (Jenkins.getInstance().pluginManager.getPlugin("git") != null) {
                if (!((Project)item).getScm().getClass().getName().endsWith("GitSCM")) return false;
                boolean status = true;
                try {
                    Method method = ((Project)item).getScm().getClass().getMethod("getExtensions", null);
                    Object extensionsList = method.invoke((Object)((Project)item).getScm(), new Object[0]);
                    if (extensionsList instanceof AbstractList) {
                        for (Object extension : (AbstractList)extensionsList) {
                            Object reference;
                            if (!extension.getClass().getName().endsWith("SubmoduleOption") || !((reference = extension.getClass().getMethod("getReference", null).invoke(extension, new Object[0])) instanceof String)) continue;
                            LOG.log(Level.FINEST, "Reference has been found: " + reference);
                            status = ((String)reference).isEmpty();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                    status = false;
                    return status;
                }
                finally {
                    return status;
                }
            }
            LOG.log(Level.FINE, "Plugin GIT hasn't been configured in this project");
            return false;
        }
        LOG.log(Level.FINE, "Plugin GIT doesn't exist");
        return false;
    }
}

