/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.AbstractProject;
import hudson.model.Item;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class GitShallowChecker
extends AbstractCheck {
    public GitShallowChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.GitShallowCheckerDesc());
        this.setSeverity(Messages.GitShallowCheckerSeverity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCheck(Item item) {
        if (item instanceof AbstractProject) {
            if (Jenkins.getInstance().pluginManager.getPlugin("git") != null) {
                if (((AbstractProject)item).getScm().getClass().getName().endsWith("GitSCM")) {
                    boolean status = true;
                    try {
                        Method method = ((AbstractProject)item).getScm().getClass().getMethod("getExtensions", null);
                        Object extensionsList = method.invoke((Object)((AbstractProject)item).getScm(), new Object[0]);
                        if (extensionsList instanceof AbstractList) {
                            for (Object extension : (AbstractList)extensionsList) {
                                Object isShallow;
                                if (!extension.getClass().getName().endsWith("CloneOption") || !((isShallow = extension.getClass().getMethod("isShallow", null).invoke(extension, new Object[0])) instanceof Boolean)) continue;
                                status = (Boolean)isShallow == false;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                        status = false;
                        return status;
                    }
                    finally {
                        return status;
                    }
                }
            } else {
                LOG.log(Level.FINE, "Plugin GIT doesn't exist");
                return false;
            }
        }
        return false;
    }
}

