/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.PluginWrapper;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Project;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.VersionNumber;
import java.util.List;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class GroovySandboxChecker
extends AbstractCheck {
    public GroovySandboxChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.GroovySandboxCheckerDesc());
        this.setSeverity(Messages.GroovySandboxCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        PluginWrapper plugin;
        LOG.log(Level.FINE, "executeCheck " + item);
        boolean found = false;
        if (item instanceof Job && item.getClass().getSimpleName().equals("WorkflowJob")) {
            try {
                Object getDefinition = item.getClass().getMethod("getDefinition", null).invoke((Object)item, new Object[0]);
                if (getDefinition.getClass().getSimpleName().equals("CpsFlowDefinition")) {
                    found = !this.isPipelineSandbox(getDefinition);
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        if ((plugin = Jenkins.getInstance().pluginManager.getPlugin("groovy")) != null && plugin.getVersionNumber().isNewerThan(new VersionNumber("1.30"))) {
            if (item.getClass().getSimpleName().equals("MavenModuleSet")) {
                try {
                    Object getPrebuilders = item.getClass().getMethod("getPrebuilders", null).invoke((Object)item, new Object[0]);
                    if (!this.isSystemSandbox((List)getPrebuilders)) {
                        found = true;
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
            if (item instanceof Project && !this.isSystemSandbox(((Project)item).getBuilders())) {
                found = true;
            }
            if (item.getClass().getSimpleName().equals("MatrixProject")) {
                try {
                    Object getBuilders = item.getClass().getMethod("getBuilders", null).invoke((Object)item, new Object[0]);
                    if (!this.isSystemSandbox((List)getBuilders)) {
                        found = true;
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        if (item instanceof AbstractProject) {
            if (!this.isSandboxInPublisher((DescribableList<Publisher, Descriptor<Publisher>>)((AbstractProject)item).getPublishersList())) {
                found = true;
            }
            if (((AbstractProject)item).getProperty(ParametersDefinitionProperty.class) != null && !this.isSandboxParameters(((ParametersDefinitionProperty)((AbstractProject)item).getProperty(ParametersDefinitionProperty.class)).getParameterDefinitions())) {
                found = true;
            }
        }
        return found;
    }

    private boolean isPipelineSandbox(Object object) {
        boolean status = true;
        if (object != null) {
            try {
                return this.isSandbox(object.getClass().getMethod("isSandbox", null).invoke(object, new Object[0]));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return status;
    }

    private boolean isSystemSandbox(List<Builder> builders) {
        boolean status = true;
        if (builders != null && builders.size() > 0) {
            for (Builder builder : builders) {
                if (!builder.getClass().getName().endsWith("SystemGroovy")) continue;
                try {
                    Object scriptSource;
                    Object source = builder.getClass().getMethod("getSource", null).invoke((Object)builder, new Object[0]);
                    if (!source.getClass().getName().endsWith("StringSystemScriptSource") || !(scriptSource = source.getClass().getMethod("getScript", null).invoke(source, new Object[0])).getClass().getName().endsWith("SecureGroovyScript") || this.isSandbox(scriptSource.getClass().getMethod("isSandbox", null).invoke(scriptSource, new Object[0]))) continue;
                    status = false;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return status;
    }

    private boolean isSandboxInPublisher(DescribableList<Publisher, Descriptor<Publisher>> publishersList) {
        boolean status = true;
        if (publishersList != null) {
            for (Publisher publisher : publishersList) {
                if (!publisher.getClass().getName().endsWith("GroovyPostbuildRecorder")) continue;
                LOG.log(Level.FINEST, "GroovyPostbuildRecorder " + publisher);
                try {
                    Object scriptSource = publisher.getClass().getMethod("getScript", null).invoke((Object)publisher, new Object[0]);
                    if (!scriptSource.getClass().getName().endsWith("SecureGroovyScript") || this.isSandbox(scriptSource.getClass().getMethod("isSandbox", null).invoke(scriptSource, new Object[0]))) continue;
                    status = false;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return status;
    }

    private boolean isSandboxParameters(List<ParameterDefinition> properties) {
        boolean status = true;
        if (properties != null) {
            for (ParameterDefinition property : properties) {
                if (!property.getClass().getName().endsWith("ChoiceParameter") && !property.getClass().getName().endsWith("CascadeChoiceParameter") && !property.getClass().getName().endsWith("DynamicReferenceParameter")) continue;
                LOG.log(Level.FINEST, "unochoice " + property);
                try {
                    Object script;
                    Object scriptSource = property.getClass().getMethod("getScript", null).invoke((Object)property, new Object[0]);
                    if (!scriptSource.getClass().getName().endsWith("GroovyScript") || (script = scriptSource.getClass().getMethod("getScript", null).invoke(scriptSource, new Object[0])) == null || !script.getClass().getName().endsWith("SecureGroovyScript") || this.isSandbox(script.getClass().getMethod("isSandbox", null).invoke(script, new Object[0]))) continue;
                    status = false;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return status;
    }

    private boolean isSandbox(Object command) {
        boolean status = false;
        if (command != null && command instanceof Boolean) {
            status = (Boolean)command;
        }
        return status;
    }
}

