/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.PluginWrapper;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Project;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.VersionNumber;
import java.util.List;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class GroovySystemExitChecker
extends AbstractCheck {
    public GroovySystemExitChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.GroovySystemExitCheckerDesc());
        this.setSeverity(Messages.GroovySystemExitCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        boolean found = false;
        if (item.getClass().getSimpleName().equals("MavenModuleSet")) {
            try {
                Object getPrebuilders = item.getClass().getMethod("getPrebuilders", null).invoke((Object)item, new Object[0]);
                if (getPrebuilders instanceof List && this.isSystemExit((List)getPrebuilders)) {
                    found = true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
            }
        }
        if (item instanceof Project) {
            found = this.isSystemExit(((Project)item).getBuilders());
        }
        if (item.getClass().getSimpleName().equals("MatrixProject")) {
            try {
                Object getBuilders = item.getClass().getMethod("getBuilders", null).invoke((Object)item, new Object[0]);
                if (getBuilders instanceof List && this.isSystemExit((List)getBuilders)) {
                    found = true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
            }
        }
        if (item instanceof AbstractProject) {
            if (this.isSystemExitInPublisher((DescribableList<Publisher, Descriptor<Publisher>>)((AbstractProject)item).getPublishersList())) {
                found = true;
            }
            if (((AbstractProject)item).getProperty(ParametersDefinitionProperty.class) != null && this.isSystemExitInParameters(((ParametersDefinitionProperty)((AbstractProject)item).getProperty(ParametersDefinitionProperty.class)).getParameterDefinitions())) {
                found = true;
            }
        }
        if (item instanceof Job && item.getClass().getSimpleName().equals("WorkflowJob")) {
            try {
                Object getDefinition = item.getClass().getMethod("getDefinition", null).invoke((Object)item, new Object[0]);
                if (getDefinition.getClass().getSimpleName().equals("CpsFlowDefinition") && this.containsSystemExit(getDefinition.getClass().getMethod("getScript", null).invoke(getDefinition, new Object[0]))) {
                    found = true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return found;
    }

    private boolean isSystemExit(List<Builder> builders) {
        boolean status = false;
        if (builders != null && builders.size() > 0) {
            for (Builder builder : builders) {
                if (!builder.getClass().getName().endsWith("SystemGroovy")) continue;
                try {
                    Object script;
                    Object scriptSource;
                    PluginWrapper plugin = Jenkins.getInstance().pluginManager.getPlugin("groovy");
                    if (plugin != null && plugin.getVersionNumber().isOlderThan(new VersionNumber("2.0.0"))) {
                        scriptSource = builder.getClass().getMethod("getScriptSource", null).invoke((Object)builder, new Object[0]);
                        if (!scriptSource.getClass().getName().endsWith("StringScriptSource") || !this.containsSystemExit(scriptSource.getClass().getMethod("getCommand", null).invoke(scriptSource, new Object[0]))) continue;
                        status = true;
                        continue;
                    }
                    scriptSource = builder.getClass().getMethod("getSource", null).invoke((Object)builder, new Object[0]);
                    if (!scriptSource.getClass().getName().endsWith("StringSystemScriptSource") || (script = scriptSource.getClass().getMethod("getScript", null).invoke(scriptSource, new Object[0])) == null || !script.getClass().getName().endsWith("SecureGroovyScript") || !this.containsSystemExit(script.getClass().getMethod("getScript", null).invoke(script, new Object[0]))) continue;
                    status = true;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return status;
    }

    private boolean isSystemExitInPublisher(DescribableList<Publisher, Descriptor<Publisher>> publishersList) {
        boolean status = false;
        if (publishersList != null) {
            for (Publisher publisher : publishersList) {
                if (!publisher.getClass().getName().endsWith("GroovyPostbuildRecorder")) continue;
                LOG.log(Level.FINEST, "GroovyPostbuildRecorder " + publisher);
                try {
                    Object scriptSource = publisher.getClass().getMethod("getScript", null).invoke((Object)publisher, new Object[0]);
                    if (!scriptSource.getClass().getName().endsWith("SecureGroovyScript") || !this.containsSystemExit(scriptSource.getClass().getMethod("getScript", null).invoke(scriptSource, new Object[0]))) continue;
                    status = true;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return status;
    }

    private boolean isSystemExitInParameters(List<ParameterDefinition> properties) {
        boolean status = false;
        if (properties != null) {
            for (ParameterDefinition property : properties) {
                if (!property.getClass().getName().endsWith("ChoiceParameter") && !property.getClass().getName().endsWith("CascadeChoiceParameter") && !property.getClass().getName().endsWith("DynamicReferenceParameter")) continue;
                LOG.log(Level.FINEST, "unochoice " + property);
                try {
                    Object script;
                    Object scriptSource = property.getClass().getMethod("getScript", null).invoke((Object)property, new Object[0]);
                    if (!scriptSource.getClass().getName().endsWith("GroovyScript") || (script = scriptSource.getClass().getMethod("getScript", null).invoke(scriptSource, new Object[0])) == null || !script.getClass().getName().endsWith("SecureGroovyScript") || !this.containsSystemExit(script.getClass().getMethod("getScript", null).invoke(script, new Object[0]))) continue;
                    status = true;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return status;
    }

    private boolean containsSystemExit(Object command) {
        boolean status = false;
        if (command != null && command instanceof String) {
            status = command != null && ((String)command).toLowerCase().contains("system.exit");
            LOG.log(Level.FINE, "isSystemExit " + status);
        }
        return status;
    }
}

