/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.Item;
import hudson.model.Project;
import hudson.tasks.BatchFile;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Shell;
import java.util.List;
import java.util.logging.Level;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;
import org.jenkins.ci.plugins.jenkinslint.utils.StringUtils;

public class HardcodedScriptChecker
extends AbstractCheck {
    public static final int THRESHOLD = 2;
    private int threshold;
    private boolean ignoreComment = false;

    public HardcodedScriptChecker(boolean enabled, int threshold, boolean ignoreComment) {
        super(enabled);
        this.setDescription(Messages.HardcodedScriptCheckerDesc());
        this.setSeverity(Messages.HardcodedScriptCheckerSeverity());
        this.setThreshold(threshold);
        this.setIgnoreComment(ignoreComment);
    }

    @Override
    public boolean executeCheck(Item item) {
        LOG.log(Level.FINE, "executeCheck " + item);
        boolean found = false;
        if (item.getClass().getSimpleName().equals("MavenModuleSet")) {
            try {
                Object getPrebuilders = item.getClass().getMethod("getPrebuilders", null).invoke((Object)item, new Object[0]);
                if (getPrebuilders instanceof List) {
                    found = this.isBuilderHarcoded((List)getPrebuilders);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
            }
        }
        if (item instanceof Project) {
            found = this.isBuilderHarcoded(((Project)item).getBuilders());
        }
        if (item.getClass().getSimpleName().equals("MatrixProject")) {
            try {
                Object getBuilders = item.getClass().getMethod("getBuilders", null).invoke((Object)item, new Object[0]);
                if (getBuilders instanceof List) {
                    found = this.isBuilderHarcoded((List)getBuilders);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return found;
    }

    private boolean isBuilderHarcoded(List<Builder> builders) {
        boolean found = false;
        if (builders != null && builders.size() > 0) {
            for (Builder builder : builders) {
                if (!(builder instanceof Shell) && !(builder instanceof BatchFile) || !this.isHarcoded(((CommandInterpreter)builder).getCommand(), this.getThreshold(), this.isIgnoreComment(), builder instanceof Shell)) continue;
                found = true;
            }
        } else {
            found = false;
        }
        return found;
    }

    private boolean isHarcoded(String content, int threshold, boolean ignoreComment, boolean isUnix) {
        if (content != null) {
            int length = 0;
            for (String line : content.split("\r\n|\r|\n")) {
                if (StringUtils.isEmptyOrBlank(line)) continue;
                if (ignoreComment && !this.isACommentLine(line, isUnix)) {
                    ++length;
                    continue;
                }
                if (ignoreComment) continue;
                ++length;
            }
            return length > threshold;
        }
        return false;
    }

    private boolean isACommentLine(String line, boolean isUnix) {
        if (isUnix) {
            return StringUtils.isShellComment(line);
        }
        return StringUtils.isBatchComment(line);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isIgnoreComment() {
        return this.ignoreComment;
    }

    public void setIgnoreComment(boolean ignoreComment) {
        this.ignoreComment = ignoreComment;
    }
}

