/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.util.logging.Level;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class JavadocChecker
extends AbstractCheck {
    public JavadocChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.JavadocCheckerDesc());
        this.setSeverity(Messages.JavadocCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        boolean found = false;
        if (item instanceof AbstractProject) {
            DescribableList publishersList = ((AbstractProject)item).getPublishersList();
            for (Publisher publisher : publishersList) {
                if (!publisher.getClass().getSimpleName().equals("JavadocArchiver")) continue;
                try {
                    Object getJavadocDir = publisher.getClass().getMethod("getJavadocDir", null).invoke((Object)publisher, new Object[0]);
                    if (!(getJavadocDir instanceof String)) continue;
                    if (getJavadocDir == null) {
                        found = true;
                        continue;
                    }
                    found = ((String)getJavadocDir).isEmpty();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                }
            }
        }
        return found;
    }
}

