/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.AbstractItem;
import hudson.model.Item;
import java.util.logging.Level;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class JobDescriptionChecker
extends AbstractCheck {
    public JobDescriptionChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.JobDescriptionCheckerDesc());
        this.setSeverity(Messages.JobDescriptionCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        if (item instanceof AbstractItem) {
            return this.isDescription(((AbstractItem)item).getDescription());
        }
        if (item.getClass().getSimpleName().equals("WorkflowJob")) {
            try {
                Object getDescription = item.getClass().getMethod("getDescription", null).invoke((Object)item, new Object[0]);
                if (getDescription instanceof String) {
                    return this.isDescription((String)getDescription);
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return false;
    }

    private boolean isDescription(String description) {
        return description == null || description.length() == 0;
    }
}

