/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.Item;
import hudson.model.Job;
import hudson.tasks.LogRotator;
import jenkins.model.BuildDiscarder;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class JobLogRotatorChecker
extends AbstractCheck {
    private final int EMPTY = -1;

    public JobLogRotatorChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.JobLogRotatorCheckerDesc());
        this.setSeverity(Messages.JobLogRotatorCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        if (item instanceof Job) {
            Job project = (Job)item;
            return project.getBuildDiscarder() == null || !this.isLogRotatorOkConfigured(project.getBuildDiscarder());
        }
        return false;
    }

    private boolean isLogRotatorOkConfigured(BuildDiscarder buildDiscarder) {
        if (buildDiscarder instanceof LogRotator) {
            LogRotator rotator = (LogRotator)buildDiscarder;
            return rotator.getArtifactDaysToKeep() > -1 || rotator.getArtifactNumToKeep() > -1 || rotator.getDaysToKeep() > -1 || rotator.getNumToKeep() > -1;
        }
        return false;
    }
}

