/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.triggers.SCMTrigger;
import java.util.Map;
import java.util.logging.Level;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class PollingSCMTriggerChecker
extends AbstractCheck {
    public PollingSCMTriggerChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.PollingSCMTriggerCheckerDesc());
        this.setSeverity(Messages.PollingSCMTriggerCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        boolean found = false;
        if (item instanceof AbstractProject) {
            boolean bl = found = ((AbstractProject)item).getTrigger(SCMTrigger.class) != null;
        }
        if (item.getClass().getSimpleName().equals("WorkflowJob")) {
            try {
                Object getTriggers = item.getClass().getMethod("getTriggers", null).invoke((Object)item, new Object[0]);
                if (getTriggers instanceof Map) {
                    for (Object value : ((Map)getTriggers).values()) {
                        if (!(value instanceof SCMTrigger)) continue;
                        found = true;
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return found;
    }
}

