/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.Launcher;
import java.io.IOException;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractSlaveCheck;
import org.jenkinsci.remoting.RoleChecker;

public class SlaveVersionChecker
extends AbstractSlaveCheck {
    private static final String masterVersion = Launcher.VERSION;

    public SlaveVersionChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.SlaveVersionCheckerDesc());
        this.setSeverity(Messages.SlaveVersionCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Node item) {
        try {
            String version = (String)item.getChannel().call((Callable)new SlaveVersion());
            return version == null || !version.equals(masterVersion);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final class SlaveVersion
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private SlaveVersion() {
        }

        public String call() throws IOException {
            try {
                return Launcher.VERSION;
            }
            catch (Throwable ex) {
                return "< 1.335";
            }
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

