/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.Item;
import hudson.model.Project;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class TimeoutChecker
extends AbstractCheck {
    public TimeoutChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.TimeoutCheckerDesc());
        this.setSeverity(Messages.TimeoutCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        boolean notfound = true;
        if (Jenkins.getInstance().pluginManager.getPlugin("build-timeout") != null) {
            boolean isBuildTimeout;
            if (item.getClass().getName().endsWith("hudson.maven.MavenModuleSet")) {
                try {
                    Method method = item.getClass().getMethod("getBuildWrappersList", new Class[0]);
                    DescribableList buildWrapperList = (DescribableList)method.invoke((Object)item, new Object[0]);
                    boolean isWrapperTimeout = this.isTimeout((List<BuildWrapper>)buildWrapperList);
                    isBuildTimeout = false;
                    Object getPrebuilders = item.getClass().getMethod("getPrebuilders", null).invoke((Object)item, new Object[0]);
                    if (getPrebuilders instanceof List) {
                        isBuildTimeout = this.isBuildStepTimeout((List)getPrebuilders);
                    }
                    notfound = !isBuildTimeout && !isWrapperTimeout;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                    notfound = false;
                }
            }
            if (item instanceof Project) {
                boolean bl = notfound = !this.isTimeout((List<BuildWrapper>)((Project)item).getBuildWrappersList()) && !this.isBuildStepTimeout(((Project)item).getBuilders());
            }
            if (item.getClass().getSimpleName().equals("MatrixProject")) {
                try {
                    Object getBuildWrappersList = item.getClass().getMethod("getBuildWrappersList", null).invoke((Object)item, new Object[0]);
                    boolean isWrapperTimeout = false;
                    if (getBuildWrappersList instanceof List) {
                        isWrapperTimeout = this.isTimeout((List)getBuildWrappersList);
                    }
                    Object getBuilders = item.getClass().getMethod("getBuilders", null).invoke((Object)item, new Object[0]);
                    isBuildTimeout = false;
                    if (getBuilders instanceof List) {
                        isBuildTimeout = this.isBuildStepTimeout((List)getBuilders);
                    }
                    notfound = !isBuildTimeout && !isWrapperTimeout;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                    notfound = false;
                }
            }
            if (item.getClass().getSimpleName().equals("WorkflowJob")) {
                notfound = false;
            }
        } else if (item.getClass().getSimpleName().equals("WorkflowJob")) {
            notfound = false;
        } else {
            LOG.log(Level.FINE, "It's highly recommended to use  the plugin build-timeout");
        }
        return notfound;
    }

    private boolean isTimeout(List<BuildWrapper> builders) {
        boolean status = false;
        if (builders != null && builders.size() > 0) {
            for (BuildWrapper builder : builders) {
                if (!builder.getClass().getName().endsWith("BuildTimeoutWrapper")) continue;
                status = true;
            }
        }
        return status;
    }

    private boolean isBuildStepTimeout(List<Builder> builders) {
        boolean found = false;
        if (builders != null && builders.size() > 0) {
            for (Builder builder : builders) {
                if (!builder.getClass().getName().endsWith("BuildStepWithTimeout")) continue;
                found = true;
            }
        } else {
            found = false;
        }
        return found;
    }
}

