/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.triggers.TimerTrigger;
import java.util.Map;
import java.util.logging.Level;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;
import org.jenkins.ci.plugins.jenkinslint.utils.StringUtils;

public class TimerTriggerChecker
extends AbstractCheck {
    public TimerTriggerChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.TimerTriggerCheckerDesc());
        this.setSeverity(Messages.TimerTriggerCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        boolean found = false;
        if (item instanceof AbstractProject && ((AbstractProject)item).getTrigger(TimerTrigger.class) != null) {
            found = this.isNotHash(((AbstractProject)item).getTrigger(TimerTrigger.class).getSpec().toLowerCase());
        }
        if (item.getClass().getSimpleName().equals("WorkflowJob")) {
            try {
                Object getTriggers = item.getClass().getMethod("getTriggers", null).invoke((Object)item, new Object[0]);
                if (getTriggers instanceof Map) {
                    for (Object value : ((Map)getTriggers).values()) {
                        if (!(value instanceof TimerTrigger) || !this.isNotHash(((TimerTrigger)value).getSpec())) continue;
                        found = true;
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return found;
    }

    private boolean isNotHash(String spec) {
        String[] myData;
        boolean found = false;
        for (String line : myData = spec.split("\n")) {
            if (StringUtils.isH(line) || StringUtils.isShellComment(line) || StringUtils.isAt(line) || StringUtils.isEmptyOrBlank(line)) continue;
            found = true;
        }
        return found;
    }
}

