/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.graph;

import hudson.util.ChartUtil;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceCheck;
import org.jenkins.ci.plugins.jenkinslint.model.Job;
import org.jenkins.ci.plugins.jenkinslint.model.Lint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public class JenkinsLintGraph {
    public static JFreeChart createChart(Enumeration<Job> jobSet) {
        return JenkinsLintGraph.createChart(JenkinsLintGraph.createDataset(jobSet));
    }

    public static JFreeChart createPieChart(Enumeration<Job> jobSet) {
        return JenkinsLintGraph.createPieChart(JenkinsLintGraph.createPieDataset(jobSet));
    }

    public static JFreeChart createSeverityPieChart(Enumeration<Job> jobSet, Hashtable<String, InterfaceCheck> checkSet) {
        return JenkinsLintGraph.createSeverityPieChart(JenkinsLintGraph.createSeverityPieDataset(jobSet, checkSet));
    }

    private static CategoryDataset createDataset(Enumeration<Job> jobSet) {
        TreeMap<String, LintGraphData> graphData = new TreeMap<String, LintGraphData>();
        for (Job key : Collections.list(jobSet)) {
            for (Lint lint : key.getLintList()) {
                LintGraphData temp = graphData.containsKey(lint.getName()) ? (LintGraphData)graphData.get(lint.getName()) : new LintGraphData(lint.getName());
                if (lint.isEnabled()) {
                    if (lint.isIgnored()) {
                        temp.incTotalIgnored();
                    } else if (lint.isFound()) {
                        temp.incTotalFound();
                    } else {
                        temp.incTotalNotFound();
                    }
                } else {
                    temp.incTotalDisabled();
                }
                graphData.put(lint.getName(), temp);
            }
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (LintGraphData data : graphData.values()) {
            dataset.setValue((double)data.getTotalNotFound(), (Comparable)((Object)"Passed"), (Comparable)((Object)data.getName()));
            dataset.setValue((double)data.getTotalFound(), (Comparable)((Object)"Defect"), (Comparable)((Object)data.getName()));
            dataset.setValue((double)data.getTotalIgnored(), (Comparable)((Object)"Ignored"), (Comparable)((Object)data.getName()));
            dataset.setValue((double)data.getTotalDisabled(), (Comparable)((Object)"Disabled"), (Comparable)((Object)data.getName()));
        }
        return dataset;
    }

    private static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"", (String)"", (String)"Number of Defects", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setCategoryMargin(0.05);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        ChartUtil.adjustChebyshev((CategoryDataset)dataset, (NumberAxis)rangeAxis);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        plot.getRenderer().setSeriesPaint(0, JenkinsLintGraph.passed());
        plot.getRenderer().setSeriesPaint(1, JenkinsLintGraph.defect());
        plot.getRenderer().setSeriesPaint(2, JenkinsLintGraph.ignored());
        plot.getRenderer().setSeriesPaint(3, JenkinsLintGraph.disabled());
        plot.getRenderer().setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        plot.getRenderer().setBaseItemLabelsVisible(true);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private static PieDataset createPieDataset(Enumeration<Job> jobSet) {
        int totalFound = 0;
        int totalNotFound = 0;
        int totalIgnored = 0;
        int totalDisabled = 0;
        for (Job key : Collections.list(jobSet)) {
            for (Lint lint : key.getLintList()) {
                if (lint.isEnabled()) {
                    if (lint.isIgnored()) {
                        ++totalIgnored;
                        continue;
                    }
                    if (lint.isFound()) {
                        ++totalFound;
                        continue;
                    }
                    ++totalNotFound;
                    continue;
                }
                ++totalDisabled;
            }
        }
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"Passed"), (Number)new Integer(totalNotFound));
        dataset.setValue((Comparable)((Object)"Defect"), (Number)new Integer(totalFound));
        dataset.setValue((Comparable)((Object)"Ignored"), (Number)new Double(totalIgnored));
        dataset.setValue((Comparable)((Object)"Disabled"), (Number)new Double(totalDisabled));
        return dataset;
    }

    private static JFreeChart createPieChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart((String)"Lint Pie Chart", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setOutlinePaint(null);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} - {1} ({2})"));
        plot.setSectionPaint(0, JenkinsLintGraph.passed());
        plot.setSectionPaint(1, JenkinsLintGraph.defect());
        plot.setSectionPaint(2, JenkinsLintGraph.ignored());
        plot.setSectionPaint(3, JenkinsLintGraph.disabled());
        return chart;
    }

    private static PieDataset createSeverityPieDataset(Enumeration<Job> jobSet, Hashtable<String, InterfaceCheck> checkSet) {
        int totalHigh = 0;
        int totalMedium = 0;
        int totalLow = 0;
        for (Job key : Collections.list(jobSet)) {
            for (Lint lint : key.getLintList()) {
                if (!lint.isEnabled() || lint.isIgnored() || !lint.isFound()) continue;
                switch (checkSet.get(lint.getName()).getSeverity()) {
                    case "High": {
                        ++totalHigh;
                        break;
                    }
                    case "Medium": {
                        ++totalMedium;
                        break;
                    }
                    case "Low": {
                        ++totalLow;
                    }
                }
            }
        }
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"High"), (Number)new Integer(totalHigh));
        dataset.setValue((Comparable)((Object)"Medium"), (Number)new Integer(totalMedium));
        dataset.setValue((Comparable)((Object)"Low"), (Number)new Double(totalLow));
        return dataset;
    }

    private static JFreeChart createSeverityPieChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart((String)"Severity Pie Chart", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setOutlinePaint(null);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} - {1} ({2})"));
        plot.setSectionPaint(0, JenkinsLintGraph.high());
        plot.setSectionPaint(1, JenkinsLintGraph.medium());
        plot.setSectionPaint(2, JenkinsLintGraph.low());
        return chart;
    }

    private static Paint disabled() {
        Color color = new Color(240, 240, 240);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static Paint ignored() {
        Color color = new Color(249, 239, 158);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static Paint defect() {
        Color color = new Color(255, 133, 102);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static Paint passed() {
        Color color = new Color(184, 238, 184);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static Paint high() {
        Color color = new Color(255, 133, 102);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static Paint medium() {
        Color color = new Color(249, 239, 158);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static Paint low() {
        Color color = new Color(184, 238, 184);
        return new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color);
    }

    private static class LintGraphData {
        private String name;
        private int totalFound = 0;
        private int totalNotFound = 0;
        private int totalIgnored = 0;
        private int totalDisabled = 0;

        public LintGraphData(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getTotalFound() {
            return this.totalFound;
        }

        public void incTotalFound() {
            ++this.totalFound;
        }

        public int getTotalNotFound() {
            return this.totalNotFound;
        }

        public void incTotalNotFound() {
            ++this.totalNotFound;
        }

        public int getTotalIgnored() {
            return this.totalIgnored;
        }

        public void incTotalIgnored() {
            ++this.totalIgnored;
        }

        public int getTotalDisabled() {
            return this.totalDisabled;
        }

        public void incTotalDisabled() {
            ++this.totalDisabled;
        }
    }
}

