/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.model;

import hudson.model.Actionable;
import hudson.model.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.ci.plugins.jenkinslint.JenkinsLintGlobalConfiguration;
import org.jenkins.ci.plugins.jenkinslint.Messages;
import org.jenkins.ci.plugins.jenkinslint.check.ArtifactChecker;
import org.jenkins.ci.plugins.jenkinslint.check.BFAChecker;
import org.jenkins.ci.plugins.jenkinslint.check.CleanupWorkspaceChecker;
import org.jenkins.ci.plugins.jenkinslint.check.GitRefChecker;
import org.jenkins.ci.plugins.jenkinslint.check.GitRefSubmoduleChecker;
import org.jenkins.ci.plugins.jenkinslint.check.GitShallowChecker;
import org.jenkins.ci.plugins.jenkinslint.check.GradleWrapperChecker;
import org.jenkins.ci.plugins.jenkinslint.check.GroovySandboxChecker;
import org.jenkins.ci.plugins.jenkinslint.check.GroovySystemExitChecker;
import org.jenkins.ci.plugins.jenkinslint.check.HardcodedScriptChecker;
import org.jenkins.ci.plugins.jenkinslint.check.JavadocChecker;
import org.jenkins.ci.plugins.jenkinslint.check.JobAssignedLabelChecker;
import org.jenkins.ci.plugins.jenkinslint.check.JobDescriptionChecker;
import org.jenkins.ci.plugins.jenkinslint.check.JobLogRotatorChecker;
import org.jenkins.ci.plugins.jenkinslint.check.JobNameChecker;
import org.jenkins.ci.plugins.jenkinslint.check.MasterLabelChecker;
import org.jenkins.ci.plugins.jenkinslint.check.MavenJobTypeChecker;
import org.jenkins.ci.plugins.jenkinslint.check.MultibranchJobTypeChecker;
import org.jenkins.ci.plugins.jenkinslint.check.NullSCMChecker;
import org.jenkins.ci.plugins.jenkinslint.check.PollingSCMTriggerChecker;
import org.jenkins.ci.plugins.jenkinslint.check.SlaveDescriptionChecker;
import org.jenkins.ci.plugins.jenkinslint.check.SlaveLabelChecker;
import org.jenkins.ci.plugins.jenkinslint.check.SlaveVersionChecker;
import org.jenkins.ci.plugins.jenkinslint.check.TimeoutChecker;
import org.jenkins.ci.plugins.jenkinslint.check.TimerTriggerChecker;
import org.jenkins.ci.plugins.jenkinslint.check.WindowsSlaveLaunchChecker;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceCheck;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceSlaveCheck;

public abstract class AbstractAction
extends Actionable {
    protected static final Logger LOG = Logger.getLogger(AbstractAction.class.getName());
    private ArrayList<InterfaceCheck> checkList = new ArrayList();
    private ArrayList<InterfaceSlaveCheck> slaveCheckList = new ArrayList();

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getIconFileName() {
        return Messages.IconFileName();
    }

    public String getUrlName() {
        return Messages.UrlName();
    }

    public String getSearchUrl() {
        return Messages.UrlName();
    }

    public Api getApi() {
        try {
            this.getData();
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Failing when getting the JenkinsLint data through the API");
        }
        return new Api((Object)this);
    }

    public abstract void getData() throws IOException;

    public synchronized ArrayList<InterfaceCheck> getCheckList() {
        return this.checkList;
    }

    public synchronized ArrayList<InterfaceSlaveCheck> getSlaveCheckList() {
        return this.slaveCheckList;
    }

    protected synchronized void reloadCheckList() {
        this.getCheckList().clear();
        JenkinsLintGlobalConfiguration config = JenkinsLintGlobalConfiguration.get();
        this.checkList.add(new JobNameChecker(config.isJobNameCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new JobDescriptionChecker(config.isJobDescriptionCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new JobAssignedLabelChecker(config.isJobAssignedLabelCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new MasterLabelChecker(config.isMasterLabelCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new JobLogRotatorChecker(config.isJobLogRotatorCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new MavenJobTypeChecker(config.isMavenJobTypeCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new CleanupWorkspaceChecker(config.isCleanupWorkspaceCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new JavadocChecker(config.isJavadocCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new ArtifactChecker(config.isArtifactCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new NullSCMChecker(config.isNullSCMCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new PollingSCMTriggerChecker(config.isPollingSCMTriggerCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new GitShallowChecker(config.isGitShallowCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new MultibranchJobTypeChecker(config.isMultibranchJobTypeCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new HardcodedScriptChecker(config.isHardcodedScriptCheckerEnabled() && config.isGlobalEnabled(), config.getHardcodedScriptThreshold(), config.isHardcodedScriptIgnoredComment()));
        this.checkList.add(new GradleWrapperChecker(config.isGradleWrapperCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new TimeoutChecker(config.isTimeoutCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new GroovySystemExitChecker(config.isGroovySystemExitCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new GitRefChecker(config.isGitRefCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new TimerTriggerChecker(config.isTimerTriggerCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new GitRefSubmoduleChecker(config.isGitRefSubmoduleCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new BFAChecker(config.isBfaCheckerEnabled() && config.isGlobalEnabled()));
        this.checkList.add(new GroovySandboxChecker(config.isGroovySandboxCheckerEnabled() && config.isGlobalEnabled()));
    }

    protected synchronized void reloadSlaveCheckList() {
        this.getSlaveCheckList().clear();
        JenkinsLintGlobalConfiguration config = JenkinsLintGlobalConfiguration.get();
        this.slaveCheckList.add(new SlaveDescriptionChecker(config.isSlaveDescriptionCheckerEnabled() && config.isGlobalEnabled()));
        this.slaveCheckList.add(new SlaveVersionChecker(config.isSlaveVersionCheckerEnabled() && config.isGlobalEnabled()));
        this.slaveCheckList.add(new SlaveLabelChecker(config.isSlaveLabelCheckerEnabled() && config.isGlobalEnabled()));
        this.slaveCheckList.add(new WindowsSlaveLaunchChecker(config.isWindowsSlaveLaunchCheckerEnabled() && config.isGlobalEnabled()));
    }
}

