/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.model;

import java.util.logging.Logger;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceCheck;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractCheck
implements Comparable<AbstractCheck>,
InterfaceCheck {
    private String name;
    private String description;
    private String id = "JL-";
    private String severity;
    private boolean enabled = true;
    protected static final Logger LOG = Logger.getLogger(AbstractCheck.class.getName());

    public AbstractCheck(boolean enabled) {
        this.setName(this.getClass().getSimpleName());
        this.setEnabled(enabled);
    }

    public AbstractCheck() {
        this.setName(this.getClass().getSimpleName());
    }

    @Override
    @Exported
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Exported
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Override
    public int compareTo(AbstractCheck other) {
        if (this == other) {
            return 0;
        }
        return this.getName().compareTo(other.getName());
    }

    @Override
    public boolean isIgnored(String jobDescription) {
        return jobDescription != null && jobDescription.contains("lint:ignore:" + this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractCheck)) {
            return false;
        }
        return this.getName().equals(((AbstractCheck)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Check: " + this.getName() + ", " + this.getDescription();
    }
}

