/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.model;

import java.util.logging.Logger;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceSlaveCheck;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractSlaveCheck
implements Comparable<AbstractSlaveCheck>,
InterfaceSlaveCheck {
    private String name;
    private String description;
    private String id = "JL-";
    private String severity;
    private boolean enabled = true;
    protected static final Logger LOG = Logger.getLogger(AbstractSlaveCheck.class.getName());

    public AbstractSlaveCheck(boolean enabled) {
        this.setName(this.getClass().getSimpleName());
        this.setEnabled(enabled);
    }

    public AbstractSlaveCheck() {
        this.setName(this.getClass().getSimpleName());
    }

    @Override
    @Exported
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Exported
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Override
    public int compareTo(AbstractSlaveCheck other) {
        if (this == other) {
            return 0;
        }
        return this.getName().compareTo(other.getName());
    }

    @Override
    public boolean isIgnored(String description) {
        return description != null && description.contains("lint:ignore:" + this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractSlaveCheck)) {
            return false;
        }
        return this.getName().equals(((AbstractSlaveCheck)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Check: " + this.getName() + ", " + this.getDescription();
    }
}

