/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.model;

import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class Lint
implements Comparable<Lint> {
    private String name;
    private boolean found = false;
    private boolean ignored = false;
    private boolean enabled = false;

    public Lint(String name, boolean found, boolean ignored, boolean enabled) {
        this.setName(name);
        this.setFound(found);
        this.setIgnored(ignored);
        this.setEnabled(enabled);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(Lint other) {
        if (this == other) {
            return 0;
        }
        return this.getName().compareTo(other.getName());
    }

    @Exported
    public boolean isFound() {
        return this.found;
    }

    public void setFound(boolean found) {
        this.found = found;
    }

    @Exported
    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    @Exported
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isActive() {
        return this.isEnabled() && !this.isIgnored();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Lint)) {
            return false;
        }
        return this.getName().equals(((Lint)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Lint: " + this.getName() + ", " + this.isFound() + ", " + this.isIgnored() + ", " + this.isEnabled();
    }
}

