/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.model;

import hudson.model.HealthReport;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jenkins.ci.plugins.jenkinslint.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.Lint;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class Slave
implements Comparable<Slave> {
    private String name;
    private String url;
    private final ArrayList<Lint> lintList = new ArrayList();

    public Slave(String name, String url) {
        this.name = name;
        this.url = url;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ArrayList<Lint> getLintList() {
        return this.lintList;
    }

    @Exported
    public Hashtable<String, Lint> getLintSet() {
        Hashtable<String, Lint> temp = new Hashtable<String, Lint>();
        for (Lint lint : this.lintList) {
            temp.put(lint.getName(), lint);
        }
        return temp;
    }

    public void addLint(Lint lint) {
        this.lintList.add(lint);
    }

    @Override
    public int compareTo(Slave other) {
        if (this == other) {
            return 0;
        }
        return this.name.compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Slave)) {
            return false;
        }
        return this.name.equals(((Slave)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Slave: " + this.name + ", " + this.url + ", " + this.lintList;
    }

    @Exported
    public HealthReport getLintHealthReport() {
        if (this.lintList != null && this.lintList.size() > 0) {
            int ok = 0;
            for (Lint lint : this.lintList) {
                if (!lint.isIgnored() && lint.isEnabled()) {
                    if (lint.isFound()) continue;
                    ++ok;
                    continue;
                }
                ++ok;
            }
            int score = (int)(100.0 * (double)ok / (double)this.lintList.size());
            return new HealthReport(score, Messages._Job_LintStability(score + "%"));
        }
        return null;
    }
}

