/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.GitObject;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.InitCommand;
import org.jenkinsci.plugins.gitclient.LegacyCompatibleGitAPIImpl;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.jenkinsci.plugins.gitclient.RebaseCommand;
import org.jenkinsci.plugins.gitclient.RevListCommand;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;
import org.jenkinsci.plugins.gitclient.cgit.GitCommandsExecutor;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class CliGitAPIImpl
extends LegacyCompatibleGitAPIImpl {
    public static final boolean USE_SETSID = Boolean.parseBoolean(System.getProperty(CliGitAPIImpl.class.getName() + ".useSETSID", "false"));
    private static final boolean PROMPT_FOR_AUTHENTICATION = Boolean.parseBoolean(System.getProperty(CliGitAPIImpl.class.getName() + ".promptForAuthentication", "false"));
    static boolean CALL_SETSID;
    static final EnumSet<AclEntryPermission> ACL_ENTRY_PERMISSIONS;
    private static final boolean USE_FORCE_FETCH;
    private static final long serialVersionUID = 1L;
    static final String SPARSE_CHECKOUT_FILE_DIR = ".git/info";
    static final String SPARSE_CHECKOUT_FILE_PATH = ".git/info/sparse-checkout";
    static final String TIMEOUT_LOG_PREFIX = " # timeout=";
    private static final String INDEX_LOCK_FILE_PATH;
    transient Launcher launcher;
    TaskListener listener;
    String gitExe;
    EnvVars environment;
    private Map<String, StandardCredentials> credentials = new HashMap<String, StandardCredentials>();
    private StandardCredentials defaultCredentials;
    private StandardCredentials lfsCredentials;
    private final String encoding;
    private Map<Instant, String> failureClues = new TreeMap<Instant, String>();
    private static final String SUBMODULE_REMOTE_PATTERN_CONFIG_KEY = "^submodule\\.(.+)\\.url";
    static final String SUBMODULE_REMOTE_PATTERN_STRING = "^submodule\\.(.+)\\.url\\s+[^\\s]+$";
    private long gitVersion = 0L;
    static boolean CHECK_REMOTE_URL;
    private boolean interruptNextCheckout = false;
    private String interruptMessage = "";
    @Whitelisted
    public static final int TIMEOUT;

    private void warnIfWindowsTemporaryDirNameHasSpaces() {
        String[] varsToCheck;
        if (!this.isWindows()) {
            return;
        }
        for (String envVar : varsToCheck = new String[]{"TEMP", "TMP"}) {
            String value = this.environment.get(envVar, "C:\\Temp");
            if (!value.contains(" ")) continue;
            this.listener.getLogger().println("env " + envVar + "='" + value + "' contains an embedded space. Some msysgit versions may fail credential related operations.");
        }
    }

    private long computeVersionFromBits(int major, int minor, int rev, int bugfix) {
        return (long)major * 1000000L + (long)minor * 10000L + (long)rev * 100L + (long)bugfix;
    }

    private void getGitVersion() {
        if (this.gitVersion != 0L) {
            return;
        }
        String version = "";
        try {
            version = this.launchCommand("--version").trim();
            this.listener.getLogger().println(" > git --version # '" + version + "'");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.computeGitVersion(version);
    }

    void computeGitVersion(String version) {
        int gitMajorVersion = 0;
        int gitMinorVersion = 0;
        int gitRevVersion = 0;
        int gitBugfixVersion = 0;
        try {
            String[] fields = version.split(" ")[2].replace("msysgit.", "").replace("windows.", "").split("\\.");
            gitMajorVersion = Integer.parseInt(fields[0]);
            gitMinorVersion = fields.length > 1 ? Integer.parseInt(fields[1]) : 0;
            gitRevVersion = fields.length > 2 ? Integer.parseInt(fields[2]) : 0;
            gitBugfixVersion = fields.length > 3 ? Integer.parseInt(fields[3]) : 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.gitVersion = this.computeVersionFromBits(gitMajorVersion, gitMinorVersion, gitRevVersion, gitBugfixVersion);
    }

    boolean isAtLeastVersion(int major, int minor, int rev, int bugfix) {
        this.getGitVersion();
        long requestedVersion = this.computeVersionFromBits(major, minor, rev, bugfix);
        return this.gitVersion >= requestedVersion;
    }

    public boolean isCliGitVerAtLeast(int major, int minor, int rev, int bugfix) {
        return this.isAtLeastVersion(major, minor, rev, bugfix);
    }

    protected CliGitAPIImpl(String gitExe, File workspace, TaskListener listener, EnvVars environment) {
        super(workspace);
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        this.encoding = this.isZos() && System.getProperty("ibm.system.encoding") != null ? Charset.forName(System.getProperty("ibm.system.encoding")).toString() : Charset.defaultCharset().toString();
        this.launcher = new Launcher.LocalLauncher(IGitAPI.verbose ? listener : TaskListener.NULL);
    }

    @Override
    public GitClient subGit(String subdir) {
        return new CliGitAPIImpl(this.gitExe, new File(this.workspace, subdir), this.listener, this.environment);
    }

    @Override
    public void init() throws GitException, InterruptedException {
        this.init_().workspace(this.workspace.getAbsolutePath()).execute();
    }

    @Override
    public boolean hasGitRepo() throws GitException, InterruptedException {
        if (this.hasGitRepo(".git")) {
            try {
                this.launchCommand("rev-parse", "--is-inside-work-tree");
            }
            catch (Exception ex) {
                ex.printStackTrace(this.listener.error("Workspace has a .git repository, but it appears to be corrupt."));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGitRepo(boolean checkParentDirectories) throws GitException, InterruptedException {
        if (checkParentDirectories) {
            return this.hasGitRepo();
        }
        if (this.hasGitRepo(".git")) {
            try {
                this.launchCommand("rev-parse", "--resolve-git-dir", this.workspace.getAbsolutePath() + File.separator + ".git");
            }
            catch (Exception ex) {
                ex.printStackTrace(this.listener.error("Workspace has a .git repository, but it appears to be corrupt."));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasGitRepo(String GIT_DIR) throws GitException {
        try {
            File dotGit = new File(this.workspace, GIT_DIR);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException, InterruptedException {
        List<IndexEntry> submodules = this.lsTree(treeIsh, true);
        submodules.removeIf(indexEntry -> !indexEntry.getMode().equals("160000"));
        return submodules;
    }

    private void addCheckedRemoteUrl(@NonNull ArgumentListBuilder args, @NonNull String url) {
        String trimmedUrl = url.trim();
        if (!(!CHECK_REMOTE_URL || trimmedUrl.startsWith("/") || trimmedUrl.startsWith("\\\\") || trimmedUrl.startsWith("file:") || trimmedUrl.startsWith("git:") || trimmedUrl.startsWith("git@") || trimmedUrl.startsWith("http:") || trimmedUrl.startsWith("https:") || trimmedUrl.startsWith("ssh:") || trimmedUrl.matches("^[A-Za-z]:.+") || !trimmedUrl.startsWith("-") && !trimmedUrl.contains("`") && !trimmedUrl.contains("--upload-pack=") && !trimmedUrl.matches(".*\\s+.*"))) {
            throw new GitException("Invalid remote URL: " + url);
        }
        if (this.isAtLeastVersion(2, 8, 0, 0)) {
            args.add("--");
        }
        args.add(trimmedUrl);
    }

    @Override
    public FetchCommand fetch_() {
        return new FetchCommand(){
            private URIish url;
            private List<RefSpec> refspecs;
            private boolean prune;
            private boolean shallow;
            private Integer timeout;
            private boolean tags = true;
            private Integer depth = 1;

            @Override
            public FetchCommand from(URIish remote, List<RefSpec> refspecs) {
                this.url = remote;
                this.refspecs = refspecs;
                return this;
            }

            @Override
            public FetchCommand tags(boolean tags) {
                this.tags = tags;
                return this;
            }

            @Override
            public FetchCommand prune() {
                return this.prune(true);
            }

            @Override
            public FetchCommand prune(boolean prune) {
                this.prune = prune;
                return this;
            }

            @Override
            public FetchCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            public FetchCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public FetchCommand depth(Integer depth) {
                this.depth = depth;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                CliGitAPIImpl.this.listener.getLogger().println("Fetching upstream changes from " + this.url);
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add("fetch");
                args.add(this.tags ? "--tags" : "--no-tags");
                if (USE_FORCE_FETCH && CliGitAPIImpl.this.isAtLeastVersion(2, 20, 0, 0)) {
                    args.add("--force");
                }
                if (CliGitAPIImpl.this.isAtLeastVersion(1, 7, 1, 0)) {
                    args.add("--progress");
                }
                if (this.prune) {
                    args.add("--prune");
                }
                if (this.shallow) {
                    if (this.depth == null) {
                        this.depth = 1;
                    }
                    args.add("--depth=" + this.depth);
                }
                CliGitAPIImpl.this.warnIfWindowsTemporaryDirNameHasSpaces();
                StandardCredentials cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(this.url.toPrivateString());
                if (cred == null) {
                    cred = CliGitAPIImpl.this.defaultCredentials;
                }
                if (CliGitAPIImpl.this.isAtLeastVersion(1, 8, 0, 0)) {
                    CliGitAPIImpl.this.addCheckedRemoteUrl(args, this.url.toPrivateASCIIString());
                } else {
                    CliGitAPIImpl.this.addCheckedRemoteUrl(args, this.url.toString());
                }
                if (this.refspecs != null) {
                    for (RefSpec rs : this.refspecs) {
                        if (rs == null) continue;
                        args.add(rs.toString());
                    }
                }
                URIish remoteUrl = this.url;
                if (!this.url.isRemote() && !StringUtils.containsAny((String)this.url.toString(), (String)":@/\\")) {
                    try {
                        remoteUrl = new URIish(CliGitAPIImpl.this.getRemoteUrl(this.url.toString()));
                    }
                    catch (URISyntaxException e) {
                        CliGitAPIImpl.this.listener.getLogger().println("Unexpected remote name or URL: '" + this.url + "'");
                    }
                }
                CliGitAPIImpl.this.launchCommandWithCredentials(args, CliGitAPIImpl.this.workspace, cred, remoteUrl, this.timeout);
            }
        };
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.fetch_().from(url, refspecs).execute();
    }

    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException, InterruptedException {
        StandardCredentials cred;
        String url;
        this.listener.getLogger().println("Fetching upstream changes" + (remoteName != null ? " from " + remoteName : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (USE_FORCE_FETCH && this.isAtLeastVersion(2, 20, 0, 0)) {
            args.add("--force");
        }
        if (remoteName == null) {
            remoteName = this.getDefaultRemote();
        }
        if ((url = this.getRemoteUrl(remoteName)) == null) {
            throw new GitException("remote." + remoteName + ".url not defined");
        }
        this.addCheckedRemoteUrl(args, url);
        if (refspec != null && refspec.length > 0) {
            for (RefSpec rs : refspec) {
                if (rs == null) continue;
                args.add(rs.toString());
            }
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, url);
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException, InterruptedException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    @Override
    public void reset(boolean hard) throws GitException, InterruptedException {
        try {
            this.validateRevision("HEAD");
        }
        catch (GitException e) {
            this.listener.getLogger().println("No valid HEAD. Skipping the resetting");
            return;
        }
        this.listener.getLogger().println("Resetting working tree");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add("reset");
        if (hard) {
            args.add("--hard");
        }
        this.launchCommand(args);
    }

    @Override
    public CloneCommand clone_() {
        return new CloneCommand(){
            private String url;
            private String origin = "origin";
            private String reference;
            private boolean shallow;
            private boolean shared;
            private Integer timeout;
            private boolean tags = true;
            private List<RefSpec> refspecs;
            private Integer depth = 1;

            @Override
            public CloneCommand url(String url) {
                this.url = url;
                return this;
            }

            @Override
            public CloneCommand repositoryName(String name) {
                this.origin = name;
                return this;
            }

            @Override
            public CloneCommand shared() {
                return this.shared(true);
            }

            @Override
            public CloneCommand shared(boolean shared) {
                this.shared = shared;
                return this;
            }

            @Override
            public CloneCommand shallow() {
                return this.shallow(true);
            }

            @Override
            public CloneCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            public CloneCommand noCheckout() {
                return this;
            }

            @Override
            public CloneCommand tags(boolean tags) {
                this.tags = tags;
                return this;
            }

            @Override
            public CloneCommand reference(String reference) {
                this.reference = reference;
                return this;
            }

            @Override
            public CloneCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public CloneCommand depth(Integer depth) {
                this.depth = depth;
                return this;
            }

            @Override
            public CloneCommand refspecs(List<RefSpec> refspecs) {
                this.refspecs = new ArrayList<RefSpec>(refspecs);
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                URIish urIish = null;
                try {
                    urIish = new URIish(this.url);
                }
                catch (URISyntaxException e) {
                    CliGitAPIImpl.this.listener.getLogger().println("Invalid repository " + this.url);
                    throw new IllegalArgumentException("Invalid repository " + this.url, e);
                }
                CliGitAPIImpl.this.listener.getLogger().println("Cloning repository " + this.url);
                try {
                    Util.deleteContentsRecursive((File)CliGitAPIImpl.this.workspace);
                }
                catch (Exception e) {
                    e.printStackTrace(CliGitAPIImpl.this.listener.error("Failed to clean the workspace"));
                    throw new GitException("Failed to delete workspace", e);
                }
                CliGitAPIImpl.this.init_().workspace(CliGitAPIImpl.this.workspace.getAbsolutePath()).execute();
                if (this.shared) {
                    if (this.reference == null || this.reference.isEmpty()) {
                        this.reference = this.url;
                    } else {
                        CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Both shared and reference is used, shared is ignored.");
                    }
                }
                if (this.reference != null && !this.reference.isEmpty()) {
                    File referencePath = new File(this.reference);
                    if (!referencePath.exists()) {
                        CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path does not exist: " + this.reference);
                    } else if (!referencePath.isDirectory()) {
                        CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path is not a directory: " + this.reference);
                    } else {
                        File objectsPath = new File(referencePath, ".git/objects");
                        if (!objectsPath.isDirectory()) {
                            objectsPath = new File(referencePath, "objects");
                        }
                        if (!objectsPath.isDirectory()) {
                            CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path does not contain an objects directory (not a git repo?): " + objectsPath);
                        } else {
                            File alternates = new File(CliGitAPIImpl.this.workspace, ".git/objects/info/alternates");
                            try (PrintWriter w = new PrintWriter(alternates, Charset.defaultCharset().toString());){
                                String absoluteReference = objectsPath.getAbsolutePath().replace('\\', '/');
                                CliGitAPIImpl.this.listener.getLogger().println("Using reference repository: " + this.reference);
                                w.print(absoluteReference);
                            }
                            catch (UnsupportedEncodingException ex) {
                                CliGitAPIImpl.this.listener.error("Default character set is an unsupported encoding");
                            }
                            catch (FileNotFoundException e) {
                                CliGitAPIImpl.this.listener.error("Failed to setup reference");
                            }
                        }
                    }
                }
                if (this.refspecs == null) {
                    this.refspecs = Collections.singletonList(new RefSpec("+refs/heads/*:refs/remotes/" + this.origin + "/*"));
                }
                CliGitAPIImpl.this.fetch_().from(urIish, this.refspecs).shallow(this.shallow).depth(this.depth).timeout(this.timeout).tags(this.tags).execute();
                CliGitAPIImpl.this.setRemoteUrl(this.origin, this.url);
                for (RefSpec refSpec : this.refspecs) {
                    CliGitAPIImpl.this.launchCommand("config", "--add", "remote." + this.origin + ".fetch", refSpec.toString());
                }
            }
        };
    }

    @Override
    public MergeCommand merge() {
        return new MergeCommand(){
            private ObjectId rev;
            private String comment;
            private String strategy;
            private String fastForwardMode;
            private boolean squash;
            private boolean commit = true;

            @Override
            public MergeCommand setRevisionToMerge(ObjectId rev) {
                this.rev = rev;
                return this;
            }

            @Override
            public MergeCommand setStrategy(MergeCommand.Strategy strategy) {
                this.strategy = strategy.toString();
                return this;
            }

            @Override
            public MergeCommand setGitPluginFastForwardMode(MergeCommand.GitPluginFastForwardMode fastForwardMode) {
                this.fastForwardMode = fastForwardMode.toString();
                return this;
            }

            @Override
            public MergeCommand setSquash(boolean squash) {
                this.squash = squash;
                return this;
            }

            @Override
            public MergeCommand setMessage(String comment) {
                this.comment = comment;
                return this;
            }

            @Override
            public MergeCommand setCommit(boolean commit) {
                this.commit = commit;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add("merge");
                if (this.squash) {
                    args.add("--squash");
                }
                if (!this.commit) {
                    args.add("--no-commit");
                }
                if (this.comment != null && !this.comment.isEmpty()) {
                    args.add("-m");
                    args.add(this.comment);
                }
                if (this.strategy != null && !this.strategy.isEmpty() && !this.strategy.equals(MergeCommand.Strategy.DEFAULT.toString())) {
                    args.add("-s");
                    if (this.strategy.equals(MergeCommand.Strategy.RECURSIVE_THEIRS.toString())) {
                        args.add("recursive");
                        args.add("--strategy-option");
                        args.add("theirs");
                    } else {
                        args.add(this.strategy);
                    }
                }
                args.add(this.fastForwardMode);
                if (this.rev == null) {
                    throw new GitException("MergeCommand requires a revision to merge");
                }
                args.add(this.rev.name());
                String defaultRemote = null;
                try {
                    defaultRemote = CliGitAPIImpl.this.getDefaultRemote();
                }
                catch (GitException gitException) {
                    // empty catch block
                }
                if (defaultRemote != null && !defaultRemote.isEmpty()) {
                    String repoUrl = CliGitAPIImpl.this.getRemoteUrl(defaultRemote);
                    StandardCredentials cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(repoUrl);
                    if (cred == null) {
                        cred = CliGitAPIImpl.this.defaultCredentials;
                    }
                    CliGitAPIImpl.this.launchCommandWithCredentials(args, CliGitAPIImpl.this.workspace, cred, repoUrl);
                } else {
                    CliGitAPIImpl.this.launchCommand(args);
                }
            }
        };
    }

    @Override
    public RebaseCommand rebase() {
        return new RebaseCommand(){
            private String upstream;

            @Override
            public RebaseCommand setUpstream(String upstream) {
                this.upstream = upstream;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                try {
                    ArgumentListBuilder args = new ArgumentListBuilder();
                    args.add("rebase");
                    args.add(this.upstream);
                    CliGitAPIImpl.this.launchCommand(args);
                }
                catch (GitException e) {
                    CliGitAPIImpl.this.launchCommand("rebase", "--abort");
                    throw new GitException("Could not rebase " + this.upstream, e);
                }
            }
        };
    }

    @Override
    public InitCommand init_() {
        return new InitCommand(){
            private String workspace;
            private boolean bare;

            @Override
            public InitCommand workspace(String workspace) {
                this.workspace = workspace;
                return this;
            }

            @Override
            public InitCommand bare(boolean bare) {
                this.bare = bare;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                boolean ok;
                File workspaceDir = new File(this.workspace);
                if (!(workspaceDir.exists() || (ok = workspaceDir.mkdirs()) || workspaceDir.exists())) {
                    throw new GitException("Could not create directory '" + workspaceDir.getAbsolutePath() + "'");
                }
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"init", this.workspace});
                if (this.bare) {
                    args.add("--bare");
                }
                CliGitAPIImpl.this.warnIfWindowsTemporaryDirNameHasSpaces();
                try {
                    CliGitAPIImpl.this.launchCommand(args);
                }
                catch (GitException e) {
                    throw new GitException("Could not init " + this.workspace, e);
                }
            }
        };
    }

    @Override
    public void clean(boolean cleanSubmodule) throws GitException, InterruptedException {
        this.reset(true);
        String cmd = "-fdx";
        if (cleanSubmodule) {
            cmd = "-ffdx";
        }
        this.launchCommand("clean", cmd);
    }

    @Override
    public void clean() throws GitException, InterruptedException {
        this.clean(false);
    }

    @Override
    public ObjectId revParse(String revName) throws GitException, InterruptedException {
        String arg = this.sanitize(revName + "^{commit}");
        String result = this.launchCommand("rev-parse", arg);
        String line = StringUtils.trimToNull((String)result);
        if (line == null) {
            throw new GitException("rev-parse no content returned for " + revName);
        }
        return ObjectId.fromString((String)line);
    }

    private String sanitize(String arg) {
        if (this.isWindows()) {
            arg = '\"' + arg + '\"';
        }
        return arg;
    }

    public ObjectId validateRevision(String revName) throws GitException, InterruptedException {
        String result = this.launchCommand("rev-parse", "--verify", revName);
        String line = StringUtils.trimToNull((String)result);
        if (line == null) {
            throw new GitException("null result from rev-parse(" + revName + ")");
        }
        return ObjectId.fromString((String)line);
    }

    @Override
    public String describe(String commitIsh) throws GitException, InterruptedException {
        String result = this.launchCommand("describe", "--tags", commitIsh);
        String line = this.firstLine(result);
        if (line == null) {
            throw new GitException("null first line from describe(" + commitIsh + ")");
        }
        return line.trim();
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException, InterruptedException {
        String repoName = repository.getName();
        String repoUrl = this.getRemoteUrl(repoName);
        if (repoUrl != null && !repoUrl.isEmpty()) {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"remote", "prune", repoName});
            StandardCredentials cred = this.credentials.get(repoUrl);
            if (cred == null) {
                cred = this.defaultCredentials;
            }
            try {
                this.launchCommandWithCredentials(args, this.workspace, cred, new URIish(repoUrl));
            }
            catch (URISyntaxException ex) {
                throw new GitException("Invalid URL " + repoUrl, ex);
            }
        }
    }

    @SuppressFBWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"}, justification="Only needs first line, exception if multiple detected")
    @CheckForNull
    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", e);
        }
        return line;
    }

    @Override
    public ChangelogCommand changelog() {
        return new ChangelogCommand(){
            public static final String RAW = "commit %H%ntree %T%nparent %P%nauthor %aN <%aE> %ai%ncommitter %cN <%cE> %ci%n%n%w(0,4,4)%B";
            private final List<String> revs = new ArrayList<String>();
            private Integer n = null;
            private Writer out = null;

            @Override
            public ChangelogCommand excludes(String rev) {
                this.revs.add(CliGitAPIImpl.this.sanitize('^' + rev));
                return this;
            }

            @Override
            public ChangelogCommand excludes(ObjectId rev) {
                return this.excludes(rev.name());
            }

            @Override
            public ChangelogCommand includes(String rev) {
                this.revs.add(rev);
                return this;
            }

            @Override
            public ChangelogCommand includes(ObjectId rev) {
                return this.includes(rev.name());
            }

            @Override
            public ChangelogCommand to(Writer w) {
                this.out = w;
                return this;
            }

            @Override
            public ChangelogCommand max(int n) {
                this.n = n;
                return this;
            }

            @Override
            public void abort() {
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder(new String[]{CliGitAPIImpl.this.gitExe, "whatchanged", "--no-abbrev", "-M"});
                if (CliGitAPIImpl.this.isAtLeastVersion(1, 8, 3, 0)) {
                    args.add("--format=commit %H%ntree %T%nparent %P%nauthor %aN <%aE> %ai%ncommitter %cN <%cE> %ci%n%n%w(0,4,4)%B");
                } else {
                    args.add("--format=raw");
                }
                if (this.n != null) {
                    args.add("-n").add((Object)this.n);
                }
                for (String rev : this.revs) {
                    args.add(rev);
                }
                if (this.out == null) {
                    throw new IllegalStateException();
                }
                try (WriterOutputStream w = new WriterOutputStream(this.out, StandardCharsets.UTF_8);){
                    if (CliGitAPIImpl.this.launcher.launch().cmds(args).envs((Map)CliGitAPIImpl.this.environment).stdout((OutputStream)w).stderr((OutputStream)CliGitAPIImpl.this.listener.getLogger()).pwd(CliGitAPIImpl.this.workspace).join() != 0) {
                        throw new GitException("Error: " + args + " in " + CliGitAPIImpl.this.workspace);
                    }
                }
                catch (IOException e) {
                    throw new GitException("Error: " + args + " in " + CliGitAPIImpl.this.workspace, e);
                }
            }
        };
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException, InterruptedException {
        return this.showRevision(from, to, true);
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to, Boolean useRawOutput) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"log", "--full-history", "--no-abbrev", "--format=raw", "-M", "-m"});
        if (useRawOutput.booleanValue()) {
            args.add("--raw");
        }
        if (from != null) {
            args.add(from.name() + ".." + to.name());
        } else {
            args.add(new String[]{"-1", to.name()});
        }
        StringWriter writer = new StringWriter();
        writer.write(this.launchCommand(args));
        return new ArrayList<String>(Arrays.asList(writer.toString().split("\\n")));
    }

    @Override
    public void submoduleInit() throws GitException, InterruptedException {
        this.launchCommand("submodule", "init");
    }

    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException, InterruptedException {
        this.launchCommand("submodule", "add", remoteURL, subdir);
    }

    @Override
    public void submoduleSync() throws GitException, InterruptedException {
        this.launchCommand("submodule", "sync");
    }

    @Override
    public SubmoduleUpdateCommand submoduleUpdate() {
        return new SubmoduleUpdateCommand(){
            private boolean recursive = false;
            private boolean remoteTracking = false;
            private boolean parentCredentials = false;
            private boolean shallow = false;
            private String ref = null;
            private Map<String, String> submodBranch = new HashMap<String, String>();
            private Integer timeout;
            private Integer depth = 1;
            private int threads = 1;

            @Override
            public SubmoduleUpdateCommand recursive(boolean recursive) {
                this.recursive = recursive;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand remoteTracking(boolean remoteTracking) {
                this.remoteTracking = remoteTracking;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand parentCredentials(boolean parentCredentials) {
                this.parentCredentials = parentCredentials;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand useBranch(String submodule, String branchname) {
                this.submodBranch.put(submodule, branchname);
                return this;
            }

            @Override
            public SubmoduleUpdateCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand depth(Integer depth) {
                this.depth = depth;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand threads(int threads) {
                this.threads = threads;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                CliGitAPIImpl.this.submoduleInit();
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"submodule", "update"});
                if (this.recursive) {
                    args.add(new String[]{"--init", "--recursive"});
                }
                if (this.remoteTracking && CliGitAPIImpl.this.isAtLeastVersion(1, 8, 2, 0)) {
                    args.add("--remote");
                    for (Map.Entry<String, String> entry : this.submodBranch.entrySet()) {
                        CliGitAPIImpl.this.launchCommand("config", "-f", ".gitmodules", "submodule." + entry.getKey() + ".branch", entry.getValue());
                    }
                }
                if (this.ref != null && !this.ref.isEmpty()) {
                    File referencePath = new File(this.ref);
                    if (!referencePath.exists()) {
                        CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path does not exist: " + this.ref);
                    } else if (!referencePath.isDirectory()) {
                        CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path is not a directory: " + this.ref);
                    } else {
                        args.add(new String[]{"--reference", this.ref});
                    }
                }
                if (this.shallow) {
                    if (this.depth == null) {
                        this.depth = 1;
                    }
                    if (CliGitAPIImpl.this.isAtLeastVersion(1, 8, 4, 0)) {
                        args.add("--depth=" + this.depth);
                    } else {
                        CliGitAPIImpl.this.listener.getLogger().println("[WARNING] Git client older than 1.8.4 doesn't support shallow submodule updates. This flag is ignored.");
                    }
                }
                String cfgOutput = null;
                try {
                    cfgOutput = CliGitAPIImpl.this.launchCommand("config", "-f", ".gitmodules", "--get-regexp", CliGitAPIImpl.SUBMODULE_REMOTE_PATTERN_CONFIG_KEY);
                }
                catch (GitException e) {
                    CliGitAPIImpl.this.listener.error("No submodules found.");
                    return;
                }
                Pattern pattern = Pattern.compile(CliGitAPIImpl.SUBMODULE_REMOTE_PATTERN_STRING, 8);
                Matcher matcher = pattern.matcher(cfgOutput);
                ArrayList commands = new ArrayList();
                while (matcher.find()) {
                    ArgumentListBuilder perModuleArgs = args.clone();
                    String sModuleName = matcher.group(1);
                    URIish urIish = null;
                    try {
                        urIish = new URIish(CliGitAPIImpl.this.getSubmoduleUrl(sModuleName));
                    }
                    catch (URISyntaxException e) {
                        CliGitAPIImpl.this.listener.error("Invalid repository for " + sModuleName);
                        throw new GitException("Invalid repository for " + sModuleName);
                    }
                    StandardCredentials cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(urIish.toPrivateString());
                    if (this.parentCredentials) {
                        String parentUrl = CliGitAPIImpl.this.getRemoteUrl(CliGitAPIImpl.this.getDefaultRemote());
                        URIish parentUri = null;
                        try {
                            parentUri = new URIish(parentUrl);
                        }
                        catch (URISyntaxException e) {
                            CliGitAPIImpl.this.listener.error("Invalid URI for " + parentUrl);
                            throw new GitException("Invalid URI for " + parentUrl);
                        }
                        cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(parentUri.toPrivateString());
                    }
                    if (cred == null) {
                        cred = CliGitAPIImpl.this.defaultCredentials;
                    }
                    String sModulePath = CliGitAPIImpl.this.getSubmodulePath(sModuleName);
                    perModuleArgs.add(sModulePath);
                    StandardCredentials finalCred = cred;
                    URIish finalUrIish = urIish;
                    commands.add(() -> CliGitAPIImpl.this.launchCommandWithCredentials(perModuleArgs, CliGitAPIImpl.this.workspace, finalCred, finalUrIish, this.timeout));
                }
                new GitCommandsExecutor(this.threads, CliGitAPIImpl.this.listener).invokeAll(commands);
            }
        };
    }

    public void submoduleReset(boolean recursive, boolean hard) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git reset" + (hard ? " --hard" : ""));
        this.launchCommand(args);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException, InterruptedException {
        this.submoduleReset(true, true);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    @Override
    @CheckForNull
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "--get", "submodule." + name + ".url");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    public void setSubmoduleUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "submodule." + name + ".url", url);
    }

    @CheckForNull
    public String getSubmodulePath(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "-f", ".gitmodules", "--get", "submodule." + name + ".path");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    @CheckForNull
    public String getRemoteUrl(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "--get", "remote." + name + ".url");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "remote." + name + ".url", url);
    }

    @Override
    public void addRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "--add", "remote." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        String result;
        String remoteNameUrl = "remote." + name + ".url";
        if (StringUtils.isBlank((String)GIT_DIR)) {
            result = this.launchCommand("config", "--get", remoteNameUrl);
        } else {
            String dirArg = "--git-dir=" + GIT_DIR;
            result = this.launchCommand(dirArg, "config", "--get", remoteNameUrl);
        }
        String line = this.firstLine(result);
        if (line == null) {
            throw new GitException("No output from git config check for " + GIT_DIR);
        }
        return line.trim();
    }

    @Override
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        this.launchCommand("--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url);
    }

    @Override
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand("remote")));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException, InterruptedException {
        return this.getDefaultRemote("origin");
    }

    @Override
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        String ret;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand("rev-parse", "--is-bare-repository");
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(gitDir, "rev-parse", "--is-bare-repository");
        }
        String line = StringUtils.trimToNull((String)ret);
        if (line == null) {
            throw new GitException("No output from bare repository check for " + GIT_DIR);
        }
        return !"false".equals(line);
    }

    public boolean isShallowRepository() {
        return new File(this.workspace, this.pathJoin(".git", "shallow")).exists();
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    @Override
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            if (url == null) {
                throw new GitException("remote." + remote + ".url not defined in workspace");
            }
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (Exception e) {
            throw new GitException("Could not determine remote." + remote + ".url", e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException gitException) {
                }
            }
        }
        if (!is_bare) {
            try {
                List<IndexEntry> submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException gitException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException, InterruptedException {
        String remote = null;
        for (Branch br : rev.getBranches()) {
            int slash;
            String b = br.getName();
            if (b != null && (slash = b.indexOf(47)) != -1) {
                remote = this.getDefaultRemote(b.substring(0, slash));
            }
            if (remote == null) continue;
            break;
        }
        if (remote == null) {
            remote = this.getDefaultRemote();
        }
        if (remote != null) {
            this.setupSubmoduleUrls(remote, listener);
        }
    }

    @Override
    public void tag(String tagName, String comment) throws GitException, InterruptedException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-a", "-f", "-m", comment, tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, e);
        }
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException, InterruptedException {
        this.createNote(note, namespace, "append");
    }

    @Override
    public void addNote(String note, String namespace) throws GitException, InterruptedException {
        this.createNote(note, namespace, "add");
    }

    private File createTempFileInSystemDir(String prefix, String suffix) throws IOException {
        if (this.isWindows()) {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
        Set<PosixFilePermission> ownerOnly = PosixFilePermissions.fromString("rw-------");
        FileAttribute<Set<PosixFilePermission>> fileAttribute = PosixFilePermissions.asFileAttribute(ownerOnly);
        return Files.createTempFile(prefix, suffix, fileAttribute).toFile();
    }

    File createTempFile(String prefix, String suffix) throws IOException {
        String common_prefix = "jenkins-gitclient-";
        prefix = prefix == null ? common_prefix : common_prefix + prefix;
        if (this.workspace == null) {
            return this.createTempFileInSystemDir(prefix, suffix);
        }
        File workspaceTmp = new File(this.workspace.getAbsolutePath() + "@tmp");
        if (!(workspaceTmp.isDirectory() || workspaceTmp.mkdirs() || workspaceTmp.isDirectory())) {
            return this.createTempFileInSystemDir(prefix, suffix);
        }
        Path tmpPath = Paths.get(workspaceTmp.getAbsolutePath(), new String[0]);
        if (workspaceTmp.getAbsolutePath().contains("%")) {
            return this.createTempFileInSystemDir(prefix, suffix);
        }
        if (this.isWindows()) {
            if (workspaceTmp.getAbsolutePath().matches(".*[ ()|?*].*")) {
                return this.createTempFileInSystemDir(prefix, suffix);
            }
            return Files.createTempFile(tmpPath, prefix, suffix, new FileAttribute[0]).toFile();
        }
        if (workspaceTmp.getAbsolutePath().contains("%")) {
            return this.createTempFileInSystemDir(prefix, suffix);
        }
        if (workspaceTmp.getAbsolutePath().contains("`")) {
            return this.createTempFileInSystemDir(prefix, suffix);
        }
        Set<PosixFilePermission> ownerOnly = PosixFilePermissions.fromString("rw-------");
        FileAttribute<Set<PosixFilePermission>> fileAttribute = PosixFilePermissions.asFileAttribute(ownerOnly);
        return Files.createTempFile(tmpPath, prefix, suffix, fileAttribute).toFile();
    }

    private void deleteTempFile(File tempFile) {
        if (tempFile != null && !tempFile.delete() && tempFile.exists()) {
            this.listener.getLogger().println("[WARNING] temp file " + tempFile + " not deleted");
        }
    }

    private void createNote(String note, String namespace, String command) throws GitException, InterruptedException {
        File msg = null;
        try {
            msg = this.createTempFile("git-note", ".txt");
            FileUtils.writeStringToFile((File)msg, (String)note, (Charset)StandardCharsets.UTF_8);
            this.launchCommand("notes", "--ref=" + namespace, command, "-F", msg.getAbsolutePath());
        }
        catch (GitException | IOException e) {
            throw new GitException("Could not apply note " + note, e);
        }
        finally {
            this.deleteTempFile(msg);
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException, InterruptedException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException, InterruptedException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull String url) throws GitException, InterruptedException {
        try {
            return this.launchCommandWithCredentials(args, workDir, credentials, new URIish(url));
        }
        catch (URISyntaxException e) {
            throw new GitException("Invalid URL " + url, e);
        }
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull URIish url) throws GitException, InterruptedException {
        return this.launchCommandWithCredentials(args, workDir, credentials, url, TIMEOUT);
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull URIish url, Integer timeout) throws GitException, InterruptedException {
        File key = null;
        File ssh = null;
        File askpass = null;
        File usernameFile = null;
        File passwordFile = null;
        File passphrase = null;
        File knownHostsTemp = null;
        EnvVars env = this.environment;
        if (!PROMPT_FOR_AUTHENTICATION && this.isAtLeastVersion(2, 3, 0, 0)) {
            env = new EnvVars(env);
            env.put("GIT_TERMINAL_PROMPT", "false");
            if (this.isWindows()) {
                env.put("GCM_INTERACTIVE", "false");
            }
        }
        try {
            if (credentials instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey sshUser = (SSHUserPrivateKey)credentials;
                this.listener.getLogger().println("using GIT_SSH to set credentials " + sshUser.getDescription());
                key = this.createSshKeyFile(sshUser);
                Object userName = url.getUser();
                if (userName == null) {
                    userName = sshUser.getUsername();
                }
                passphrase = this.createPassphraseFile(sshUser);
                knownHostsTemp = this.createTempFile("known_hosts", "");
                if (this.launcher.isUnix()) {
                    ssh = this.createUnixGitSSH(key, (String)userName, knownHostsTemp);
                    askpass = this.createUnixSshAskpass(sshUser, passphrase);
                } else {
                    ssh = this.createWindowsGitSSH(key, (String)userName, knownHostsTemp);
                    askpass = this.createWindowsSshAskpass(sshUser, passphrase);
                }
                env = new EnvVars(env);
                env.put("GIT_SSH", ssh.getAbsolutePath());
                env.put("GIT_SSH_VARIANT", "ssh");
                env.put("SSH_ASKPASS", askpass.getAbsolutePath());
                if (!env.containsKey((Object)"DISPLAY")) {
                    env.put("DISPLAY", ":");
                }
            } else if (credentials instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials userPass = (StandardUsernamePasswordCredentials)credentials;
                this.listener.getLogger().println("using GIT_ASKPASS to set credentials " + userPass.getDescription());
                usernameFile = this.createUsernameFile(userPass);
                passwordFile = this.createPasswordFile(userPass);
                askpass = this.launcher.isUnix() ? this.createUnixStandardAskpass(userPass, usernameFile, passwordFile) : this.createWindowsStandardAskpass(userPass, usernameFile, passwordFile);
                env = new EnvVars(env);
                env.put("GIT_ASKPASS", askpass.getAbsolutePath());
                env.put("SSH_ASKPASS", askpass.getAbsolutePath());
            }
            if (("http".equalsIgnoreCase(url.getScheme()) || "https".equalsIgnoreCase(url.getScheme())) && this.proxy != null) {
                boolean shouldProxy = true;
                for (Pattern p : this.proxy.getNoProxyHostPatterns()) {
                    if (!p.matcher(url.getHost()).matches()) continue;
                    shouldProxy = false;
                    break;
                }
                if (shouldProxy) {
                    env = new EnvVars(env);
                    this.listener.getLogger().println("Setting http proxy: " + this.proxy.name + ":" + this.proxy.port);
                    String userInfo = null;
                    if (this.proxy.getUserName() != null) {
                        userInfo = this.proxy.getUserName();
                        if (this.proxy.getPassword() != null) {
                            userInfo = userInfo + ":" + this.proxy.getPassword();
                        }
                    }
                    try {
                        URI http_proxy = new URI("http", userInfo, this.proxy.name, this.proxy.port, null, null, null);
                        env.put("http_proxy", http_proxy.toString());
                        env.put("https_proxy", http_proxy.toString());
                    }
                    catch (URISyntaxException ex) {
                        throw new GitException("Failed to create http proxy uri", ex);
                    }
                }
            }
            String shouldProxy = this.launchCommandIn(args, workDir, env, timeout);
            this.deleteTempFile(key);
            this.deleteTempFile(ssh);
            this.deleteTempFile(askpass);
            this.deleteTempFile(passphrase);
            this.deleteTempFile(usernameFile);
            this.deleteTempFile(passwordFile);
            this.deleteTempFile(knownHostsTemp);
            return shouldProxy;
        }
        catch (IOException e) {
            try {
                throw new GitException("Failed to setup credentials", e);
            }
            catch (Throwable throwable) {
                this.deleteTempFile(key);
                this.deleteTempFile(ssh);
                this.deleteTempFile(askpass);
                this.deleteTempFile(passphrase);
                this.deleteTempFile(usernameFile);
                this.deleteTempFile(passwordFile);
                this.deleteTempFile(knownHostsTemp);
                throw throwable;
            }
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Path operations below intentionally use absolute '/usr/bin/chcon' and '/sys/fs/selinux/enforce' and '/proc/self/attr/current' at this time (as delivered in relevant popular Linux distros)")
    private Boolean fixSELinuxLabel(File key, String label) {
        if (!this.launcher.isUnix()) {
            return true;
        }
        if (Files.isExecutable(Paths.get("/usr/bin/chcon", new String[0]))) {
            String command;
            String stderr;
            String stdout;
            int status;
            block28: {
                Boolean clue_sysfs;
                Boolean clue_proc;
                block26: {
                    String s;
                    BufferedReader br2;
                    block24: {
                        clue_proc = false;
                        clue_sysfs = false;
                        try {
                            if (!Files.isRegularFile(Paths.get("/proc/self/attr/current", new String[0]), new LinkOption[0])) break block24;
                            br2 = Files.newBufferedReader(Paths.get("/proc/self/attr/current", new String[0]), StandardCharsets.UTF_8);
                            try {
                                s = br2.readLine();
                            }
                            finally {
                                br2.close();
                            }
                            if ("unconfined".equals(s)) {
                                return true;
                            }
                            if ("kernel".equals(s)) {
                                return true;
                            }
                            if (s.contains(":")) {
                                clue_proc = true;
                            }
                        }
                        catch (IOException | SecurityException br2) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!Files.isDirectory(Paths.get("/sys/fs/selinux", new String[0]), new LinkOption[0])) {
                            return true;
                        }
                        if (!Files.isRegularFile(Paths.get("/sys/fs/selinux/enforce", new String[0]), new LinkOption[0])) break block26;
                        br2 = Files.newBufferedReader(Paths.get("/sys/fs/selinux/enforce", new String[0]), StandardCharsets.UTF_8);
                        try {
                            s = br2.readLine();
                        }
                        finally {
                            br2.close();
                        }
                        if ("0".equals(s)) {
                            return true;
                        }
                        if ("1".equals(s)) {
                            clue_sysfs = true;
                        }
                    }
                    catch (IOException | SecurityException br3) {
                        // empty catch block
                    }
                }
                if (clue_proc.booleanValue()) {
                    this.listener.getLogger().println("[INFO] Currently running in a labeled security context");
                }
                if (clue_sysfs.booleanValue()) {
                    this.listener.getLogger().println("[INFO] Currently SELinux is 'enforcing' on the host");
                }
                if (!clue_sysfs.booleanValue() && !clue_proc.booleanValue()) {
                    this.listener.getLogger().println("[INFO] SELinux is present on the host and we could not confirm that it does not apply actively: will try to relabel temporary files now; this may complain if context labeling not applicable after all");
                }
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add("/usr/bin/chcon");
                args.add("--type=" + label);
                args.add(key.getPath());
                Launcher.ProcStarter p = this.launcher.launch().cmds(args.toCommandArray());
                status = -1;
                stdout = "";
                stderr = "";
                command = StringUtils.join((Object[])args.toCommandArray(), (String)" ");
                try {
                    ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream();
                    ByteArrayOutputStream stderrStream = new ByteArrayOutputStream();
                    p.stdout((OutputStream)stdoutStream).stderr((OutputStream)stderrStream);
                    this.listener.getLogger().println(" > " + command);
                    status = p.start().joinWithTimeout(1L, TimeUnit.MINUTES, this.listener);
                    stdout = stdoutStream.toString(this.encoding);
                    stderr = stderrStream.toString(this.encoding);
                }
                catch (Throwable e) {
                    this.listener.getLogger().println("Error performing chcon helper command for SELinux: " + command + " :\n" + e);
                    if (status > 0) break block28;
                    status = 126;
                }
            }
            if (status > 0) {
                this.failureClues.put(Instant.now(), "[WARNING] Failed (" + status + ") performing chcon helper command for SELinux:\n >>> " + command + "\n" + (stdout.equals("") ? "" : "=== STDOUT:\n" + stdout + "\n====\n") + (stderr.equals("") ? "" : "=== STDERR:\n" + stderr + "\n====\n") + "IMPACT: if SELinux is enabled, access to temporary key file may be denied for git+ssh later");
                return false;
            }
        }
        return true;
    }

    private void reportFailureClues() {
        if (!this.failureClues.isEmpty()) {
            this.listener.getLogger().println("ERROR: Git command failed, and previous operations logged the following error details:");
            for (Map.Entry<Instant, String> entry : this.failureClues.entrySet()) {
                this.listener.getLogger().println("[" + entry.getKey().toString() + "]" + entry.getValue() + "\n");
            }
            this.failureClues = new TreeMap<Instant, String>();
        }
    }

    private File createSshKeyFile(SSHUserPrivateKey sshUser) throws IOException, InterruptedException {
        File key = this.createTempFile("ssh", ".key");
        try (PrintWriter w = new PrintWriter(key, this.encoding);){
            List privateKeys = sshUser.getPrivateKeys();
            for (String s : privateKeys) {
                w.println(s);
            }
        }
        if (this.launcher.isUnix()) {
            new FilePath(key).chmod(256);
            this.fixSELinuxLabel(key, "ssh_home_t");
        } else {
            this.fixSshKeyOnWindows(key);
        }
        return key;
    }

    void fixSshKeyOnWindows(File key) throws GitException {
        if (this.launcher.isUnix()) {
            return;
        }
        Path file = Paths.get(key.toURI());
        AclFileAttributeView fileAttributeView = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView == null) {
            return;
        }
        try {
            UserPrincipal userPrincipal = fileAttributeView.getOwner();
            AclEntry aclEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setPermissions(ACL_ENTRY_PERMISSIONS).build();
            fileAttributeView.setAcl(Collections.singletonList(aclEntry));
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new GitException("Error updating file permission for \"" + key.getAbsolutePath() + "\"", e);
        }
    }

    private String windowsArgEncodeFileName(String filename) {
        if (filename.contains("\"")) {
            filename = filename.replace("\"", "^\"");
        }
        return "\"" + filename + "\"";
    }

    private File createWindowsSshAskpass(SSHUserPrivateKey sshUser, @NonNull File passphrase) throws IOException {
        File ssh = File.createTempFile("pass", ".bat");
        try (PrintWriter w = new PrintWriter(ssh, this.encoding);){
            w.println("@echo off");
            w.println("type " + this.windowsArgEncodeFileName(passphrase.getAbsolutePath()));
        }
        ssh.setExecutable(true, true);
        return ssh;
    }

    private String unixArgEncodeFileName(String filename) {
        if (filename.contains("'")) {
            filename = filename.replace("'", "'\\''");
        }
        return "'" + filename + "'";
    }

    private File createUnixSshAskpass(SSHUserPrivateKey sshUser, @NonNull File passphrase) throws IOException {
        File ssh = this.createTempFile("pass", ".sh");
        try (PrintWriter w = new PrintWriter(ssh, this.encoding);){
            w.println("#!/bin/sh");
            w.println("cat " + this.unixArgEncodeFileName(passphrase.getAbsolutePath()));
        }
        ssh.setExecutable(true, true);
        return ssh;
    }

    private File createWindowsStandardAskpass(StandardUsernamePasswordCredentials creds, File usernameFile, File passwordFile) throws IOException {
        File askpass = this.createTempFile("pass", ".bat");
        try (PrintWriter w = new PrintWriter(askpass, this.encoding);){
            w.println("@set arg=%~1");
            w.println("@if (%arg:~0,8%)==(Username) type " + this.windowsArgEncodeFileName(usernameFile.getAbsolutePath()));
            w.println("@if (%arg:~0,8%)==(Password) type " + this.windowsArgEncodeFileName(passwordFile.getAbsolutePath()));
        }
        askpass.setExecutable(true, true);
        return askpass;
    }

    private File createUnixStandardAskpass(StandardUsernamePasswordCredentials creds, File usernameFile, File passwordFile) throws IOException {
        File askpass = this.createTempFile("pass", ".sh");
        try (PrintWriter w = new PrintWriter(askpass, this.encoding);){
            w.println("#!/bin/sh");
            w.println("case \"$1\" in");
            w.println("Username*) cat " + this.unixArgEncodeFileName(usernameFile.getAbsolutePath()) + " ;;");
            w.println("Password*) cat " + this.unixArgEncodeFileName(passwordFile.getAbsolutePath()) + " ;;");
            w.println("esac");
        }
        askpass.setExecutable(true, true);
        return askpass;
    }

    private File createPassphraseFile(SSHUserPrivateKey sshUser) throws IOException {
        String charset = this.computeCredentialFileCharset("passphrase", "UTF-8");
        File passphraseFile = this.createTempFile("phrase", ".txt");
        try (PrintWriter w = new PrintWriter(passphraseFile, charset);){
            w.println(Secret.toString((Secret)sshUser.getPassphrase()));
        }
        return passphraseFile;
    }

    private File createUsernameFile(StandardUsernamePasswordCredentials userPass) throws IOException {
        String charset = this.computeCredentialFileCharset("name", "UTF-8");
        File usernameFile = this.createTempFile("username", ".txt");
        try (PrintWriter w = new PrintWriter(usernameFile, charset);){
            w.println(userPass.getUsername());
        }
        return usernameFile;
    }

    private File createPasswordFile(StandardUsernamePasswordCredentials userPass) throws IOException {
        String charset = this.computeCredentialFileCharset("password", "UTF-8");
        File passwordFile = this.createTempFile("password", ".txt");
        try (PrintWriter w = new PrintWriter(passwordFile, charset);){
            w.println(Secret.toString((Secret)userPass.getPassword()));
        }
        return passwordFile;
    }

    private String computeCredentialFileCharset(String context, String defaultValue) {
        String property = CliGitAPIImpl.class.getName() + ".user." + context + ".file.encoding";
        if (this.isZos() && System.getProperty(property) != null) {
            String charset = Charset.forName(System.getProperty(property)).toString();
            this.listener.getLogger().println("Using " + context + " charset '" + charset + "'");
            return charset;
        }
        return defaultValue;
    }

    private String getPathToExe(String userGitExe) {
        String[] pathDirs;
        String exe;
        String cmd;
        if ((userGitExe = userGitExe.toLowerCase(Locale.ENGLISH)).endsWith(".exe")) {
            cmd = userGitExe.replace(".exe", ".cmd");
            exe = userGitExe;
        } else if (userGitExe.endsWith(".cmd")) {
            cmd = userGitExe;
            exe = userGitExe.replace(".cmd", ".exe");
        } else {
            cmd = userGitExe + ".cmd";
            exe = userGitExe + ".exe";
        }
        for (String pathDir : pathDirs = System.getenv("PATH").split(File.pathSeparator)) {
            File exeFile = new File(pathDir, exe);
            if (exeFile.exists()) {
                return exeFile.getAbsolutePath();
            }
            File cmdFile = new File(pathDir, cmd);
            if (!cmdFile.exists()) continue;
            return cmdFile.getAbsolutePath();
        }
        File userGitFile = new File(userGitExe);
        if (userGitFile.exists()) {
            return userGitFile.getAbsolutePath();
        }
        return null;
    }

    private File getFileFromEnv(String envVar, String suffix) {
        String envValue = System.getenv(envVar);
        if (envValue == null) {
            return null;
        }
        return new File(envValue + suffix);
    }

    private File getSSHExeFromGitExeParentDir(String userGitExe) {
        String parentPath = new File(userGitExe).getParent();
        if (parentPath == null) {
            return null;
        }
        return new File(parentPath + "\\ssh.exe");
    }

    public File getSSHExecutable() {
        File sshexe = this.getFileFromEnv("GIT_SSH", "");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getFileFromEnv("ProgramFiles", "\\Git\\bin\\ssh.exe");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getFileFromEnv("ProgramFiles", "\\Git\\usr\\bin\\ssh.exe");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getFileFromEnv("ProgramFiles(x86)", "\\Git\\bin\\ssh.exe");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getFileFromEnv("ProgramFiles(x86)", "\\Git\\usr\\bin\\ssh.exe");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getSSHExeFromGitExeParentDir(this.gitExe);
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        String gitPath = this.getPathToExe(this.gitExe);
        if (gitPath != null) {
            sshexe = this.getSSHExeFromGitExeParentDir(gitPath.replace("/bin/", "/usr/bin/").replace("\\bin\\", "\\usr\\bin\\"));
            if (sshexe != null && sshexe.exists()) {
                return sshexe;
            }
            sshexe = this.getSSHExeFromGitExeParentDir(gitPath.replace("/cmd/", "/bin/").replace("\\cmd\\", "\\bin\\"));
            if (sshexe != null && sshexe.exists()) {
                return sshexe;
            }
            sshexe = this.getSSHExeFromGitExeParentDir(gitPath.replace("/cmd/", "/usr/bin/").replace("\\cmd\\", "\\usr\\bin\\"));
            if (sshexe != null && sshexe.exists()) {
                return sshexe;
            }
            sshexe = this.getSSHExeFromGitExeParentDir(gitPath.replace("/mingw64/", "/").replace("\\mingw64\\", "\\"));
            if (sshexe != null && sshexe.exists()) {
                return sshexe;
            }
            sshexe = this.getSSHExeFromGitExeParentDir(gitPath.replace("/mingw64/bin/", "/usr/bin/").replace("\\mingw64\\bin\\", "\\usr\\bin\\"));
            if (sshexe != null && sshexe.exists()) {
                return sshexe;
            }
        }
        throw new RuntimeException("ssh executable not found. The git plugin only supports official git client https://git-scm.com/download/win");
    }

    private File createWindowsGitSSH(File key, String user, File knownHosts) throws IOException {
        File ssh = this.createTempFile("ssh", ".bat");
        File sshexe = this.getSSHExecutable();
        try (PrintWriter w = new PrintWriter(ssh, this.encoding);){
            w.println("@echo off");
            w.println("\"" + sshexe.getAbsolutePath() + "\" -i \"" + key.getAbsolutePath() + "\" -l \"" + user + "\" " + this.getHostKeyFactory().forCliGit(this.listener).getVerifyHostKeyOption(knownHosts) + " %* ");
        }
        ssh.setExecutable(true, true);
        return ssh;
    }

    private File createUnixGitSSH(File key, String user, File knownHosts) throws IOException {
        File ssh = this.createTempFile("ssh", ".sh");
        File ssh_copy = new File(ssh.toString() + "-copy");
        boolean isCopied = false;
        try (PrintWriter w = new PrintWriter(ssh, this.encoding);){
            w.println("#!/bin/sh");
            w.println("if [ -z \"${DISPLAY}\" ]; then");
            w.println("  DISPLAY=:123.456");
            w.println("  export DISPLAY");
            w.println("fi");
            w.println("ssh -i \"" + key.getAbsolutePath() + "\" -l \"" + user + "\" " + this.getHostKeyFactory().forCliGit(this.listener).getVerifyHostKeyOption(knownHosts) + " \"$@\"");
        }
        ssh.setExecutable(true, true);
        String fromLocation = ssh.toString();
        String toLocation = ssh_copy.toString();
        try {
            new ProcessBuilder("cp", fromLocation, toLocation).start().waitFor();
            isCopied = true;
            ssh_copy.setExecutable(true, true);
            this.deleteTempFile(ssh);
        }
        catch (InterruptedException ie) {
            if (isCopied) {
                this.deleteTempFile(ssh_copy);
            }
            return ssh;
        }
        return ssh_copy;
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir) throws GitException, InterruptedException {
        return this.launchCommandIn(args, workDir, this.environment);
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir, EnvVars env) throws GitException, InterruptedException {
        return this.launchCommandIn(args, workDir, this.environment, TIMEOUT);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="earlier readStderr()/readStdout() call prevents null return")
    private String readProcessIntoString(Proc process, String encoding, boolean useStderr) throws IOException {
        if (useStderr) {
            return IOUtils.toString((InputStream)process.getStderr(), (String)encoding);
        }
        return IOUtils.toString((InputStream)process.getStdout(), (String)encoding);
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir, EnvVars env, Integer timeout) throws GitException, InterruptedException {
        EnvVars freshEnv = new EnvVars(env);
        if (!env.containsKey((Object)"GIT_ASKPASS")) {
            freshEnv.put("GIT_ASKPASS", "echo");
        }
        String command = this.gitExe + " " + StringUtils.join((Object[])args.toCommandArray(), (String)" ");
        try {
            String stderr;
            String stdout;
            int status;
            args.prepend(new String[]{this.gitExe});
            if (CALL_SETSID && this.launcher.isUnix() && env.containsKey((Object)"GIT_SSH") && env.containsKey((Object)"DISPLAY")) {
                args.prepend(new String[]{"setsid"});
            }
            int usedTimeout = timeout == null ? TIMEOUT : timeout;
            this.listener.getLogger().println(" > " + command + TIMEOUT_LOG_PREFIX + usedTimeout);
            Launcher.ProcStarter p = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)freshEnv);
            if (workDir != null) {
                p.pwd(workDir);
            }
            if (this.isZos()) {
                p.readStdout().readStderr();
                Proc process = p.start();
                status = process.joinWithTimeout((long)usedTimeout, TimeUnit.MINUTES, this.listener);
                stdout = this.readProcessIntoString(process, this.encoding, false);
                stderr = this.readProcessIntoString(process, this.encoding, true);
            } else {
                ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream();
                ByteArrayOutputStream stderrStream = new ByteArrayOutputStream();
                p.stdout((OutputStream)stdoutStream).stderr((OutputStream)stderrStream);
                status = p.start().joinWithTimeout((long)usedTimeout, TimeUnit.MINUTES, this.listener);
                stdout = stdoutStream.toString(this.encoding);
                stderr = stderrStream.toString(this.encoding);
            }
            if (status != 0) {
                throw new GitException("Command \"" + command + "\" returned status code " + status + ":\nstdout: " + stdout + "\nstderr: " + stderr);
            }
            return stdout;
        }
        catch (GitException | InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.reportFailureClues();
            throw new GitException("Error performing git command: " + command, e);
        }
    }

    @Override
    public PushCommand push() {
        return new PushCommand(){
            private URIish remote;
            private String refspec;
            private boolean force;
            private boolean tags;
            private Integer timeout;

            @Override
            public PushCommand to(URIish remote) {
                this.remote = remote;
                return this;
            }

            @Override
            public PushCommand ref(String refspec) {
                this.refspec = refspec;
                return this;
            }

            @Override
            public PushCommand force() {
                return this.force(true);
            }

            @Override
            public PushCommand force(boolean force) {
                this.force = force;
                return this;
            }

            @Override
            public PushCommand tags(boolean tags) {
                this.tags = tags;
                return this;
            }

            @Override
            public PushCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (this.remote == null) {
                    throw new GitException("PushCommand requires a 'remote'");
                }
                args.add(new String[]{"push", this.remote.toPrivateASCIIString()});
                if (this.refspec != null) {
                    args.add(this.refspec);
                }
                if (this.force) {
                    args.add("-f");
                }
                if (this.tags) {
                    args.add("--tags");
                }
                if (!CliGitAPIImpl.this.isAtLeastVersion(1, 9, 0, 0) && CliGitAPIImpl.this.isShallowRepository()) {
                    throw new GitException("Can't push from shallow repository using git client older than 1.9.0");
                }
                StandardCredentials cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(this.remote.toPrivateString());
                if (cred == null) {
                    cred = CliGitAPIImpl.this.defaultCredentials;
                }
                CliGitAPIImpl.this.launchCommandWithCredentials(args, CliGitAPIImpl.this.workspace, cred, this.remote, this.timeout);
            }
        };
    }

    Set<Branch> parseBranches(String fos) {
        fos = fos.replaceAll("\\r", "");
        HashSet<Branch> branches = new HashSet<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] branchVerboseOutput;
                if (line.length() < 44 || !line.contains(" ") || (branchVerboseOutput = line.substring(2).split(" +", 3)).length <= 1 || branchVerboseOutput[1].length() != 40) continue;
                branches.add(new Branch(branchVerboseOutput[0], ObjectId.fromString((String)branchVerboseOutput[1])));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return branches;
    }

    @Override
    public Set<Branch> getBranches() throws GitException, InterruptedException {
        return this.parseBranches(this.launchCommand("branch", "-a", "-v", "--no-abbrev"));
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException, InterruptedException {
        try (Repository db = this.getRepository();){
            Map refs = db.getAllRefs();
            HashSet<Branch> branches = new HashSet<Branch>();
            for (Ref candidate : refs.values()) {
                if (!candidate.getName().startsWith("refs/remotes/")) continue;
                Branch buildBranch = new Branch(candidate);
                if (!GitClient.quietRemoteBranches) {
                    this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
                }
                branches.add(buildBranch);
            }
            if (branches.size() == 1) {
                this.listener.getLogger().println("Seen 1 remote branch");
            } else {
                this.listener.getLogger().println(MessageFormat.format("Seen {0} remote branches", branches.size()));
            }
            HashSet<Branch> hashSet = branches;
            return hashSet;
        }
    }

    void interruptNextCheckoutWithMessage(String msg) {
        this.interruptNextCheckout = true;
        this.interruptMessage = msg;
    }

    @Override
    public CheckoutCommand checkout() {
        return new CheckoutCommand(){
            private String ref;
            private String branch;
            private boolean deleteBranch;
            private List<String> sparseCheckoutPaths = Collections.emptyList();
            private Integer timeout;
            private String lfsRemote;
            private StandardCredentials lfsCredentials;

            @Override
            public CheckoutCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public CheckoutCommand branch(String branch) {
                this.branch = branch;
                return this;
            }

            @Override
            public CheckoutCommand deleteBranchIfExist(boolean deleteBranch) {
                this.deleteBranch = deleteBranch;
                return this;
            }

            @Override
            public CheckoutCommand sparseCheckoutPaths(List<String> sparseCheckoutPaths) {
                this.sparseCheckoutPaths = sparseCheckoutPaths == null ? Collections.emptyList() : sparseCheckoutPaths;
                return this;
            }

            @Override
            public CheckoutCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public CheckoutCommand lfsRemote(String lfsRemote) {
                this.lfsRemote = lfsRemote;
                return this;
            }

            @Override
            public CheckoutCommand lfsCredentials(StandardCredentials lfsCredentials) {
                this.lfsCredentials = lfsCredentials;
                return this;
            }

            private void interruptThisCheckout() throws InterruptedException {
                File indexFile = new File(CliGitAPIImpl.this.workspace.getPath() + File.separator + INDEX_LOCK_FILE_PATH);
                boolean created = false;
                try {
                    created = indexFile.createNewFile();
                }
                catch (IOException ex) {
                    throw new InterruptedException(ex.getMessage());
                }
                throw new InterruptedException(created ? CliGitAPIImpl.this.interruptMessage : CliGitAPIImpl.this.interruptMessage + " " + INDEX_LOCK_FILE_PATH + " not created");
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                block18: {
                    long startTimeSeconds = System.currentTimeMillis() / 1000L * 1000L;
                    try {
                        ArgumentListBuilder args;
                        if (CliGitAPIImpl.this.interruptNextCheckout) {
                            CliGitAPIImpl.this.interruptNextCheckout = false;
                            this.interruptThisCheckout();
                        }
                        this.sparseCheckout(this.sparseCheckoutPaths);
                        EnvVars checkoutEnv = CliGitAPIImpl.this.environment;
                        if (this.lfsRemote != null) {
                            checkoutEnv = new EnvVars(checkoutEnv);
                            checkoutEnv.put("GIT_LFS_SKIP_SMUDGE", "1");
                        }
                        if (this.branch != null && this.deleteBranch) {
                            args = new ArgumentListBuilder();
                            args.add(new String[]{"checkout", "-f", this.ref});
                            CliGitAPIImpl.this.launchCommandIn(args, CliGitAPIImpl.this.workspace, checkoutEnv, this.timeout);
                            for (Branch b : CliGitAPIImpl.this.getBranches()) {
                                if (!b.getName().equals(this.branch)) continue;
                                CliGitAPIImpl.this.deleteBranch(this.branch);
                            }
                        }
                        args = new ArgumentListBuilder();
                        args.add("checkout");
                        if (this.branch != null) {
                            args.add("-b");
                            args.add(this.branch);
                        } else {
                            args.add("-f");
                        }
                        args.add(this.ref);
                        CliGitAPIImpl.this.launchCommandIn(args, CliGitAPIImpl.this.workspace, checkoutEnv, this.timeout);
                        if (this.lfsRemote == null) break block18;
                        String url = CliGitAPIImpl.this.getRemoteUrl(this.lfsRemote);
                        StandardCredentials cred = this.lfsCredentials;
                        if (cred == null) {
                            cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(url);
                        }
                        if (cred == null) {
                            cred = CliGitAPIImpl.this.defaultCredentials;
                        }
                        ArgumentListBuilder lfsArgs = new ArgumentListBuilder();
                        lfsArgs.add("lfs");
                        lfsArgs.add("pull");
                        lfsArgs.add(this.lfsRemote);
                        try {
                            CliGitAPIImpl.this.launchCommandWithCredentials(lfsArgs, CliGitAPIImpl.this.workspace, cred, new URIish(url), this.timeout);
                        }
                        catch (URISyntaxException e) {
                            throw new GitException("Invalid URL " + url, e);
                        }
                    }
                    catch (GitException e) {
                        if (Pattern.compile("index\\.lock").matcher(e.getMessage()).find()) {
                            throw new GitLockFailedException("Could not lock repository. Please try again", e);
                        }
                        if (this.branch != null) {
                            throw new GitException("Could not checkout " + this.branch + " with start point " + this.ref, e);
                        }
                        throw new GitException("Could not checkout " + this.ref, e);
                    }
                    catch (InterruptedException e) {
                        File indexFile = new File(CliGitAPIImpl.this.workspace.getPath() + File.separator + INDEX_LOCK_FILE_PATH);
                        if (indexFile.exists() && indexFile.lastModified() >= startTimeSeconds) {
                            try {
                                FileUtils.forceDelete((File)indexFile);
                            }
                            catch (IOException ioe) {
                                throw new GitException("Could not remove index lock file on interrupting thread", ioe);
                            }
                        }
                        throw e;
                    }
                }
            }

            private void sparseCheckout(@NonNull List<String> paths) throws GitException, InterruptedException {
                boolean deactivatingSparseCheckout;
                block29: {
                    boolean coreSparseCheckoutConfigEnable;
                    try {
                        coreSparseCheckoutConfigEnable = CliGitAPIImpl.this.launchCommand("config", "core.sparsecheckout").contains("true");
                    }
                    catch (GitException ge) {
                        coreSparseCheckoutConfigEnable = false;
                    }
                    deactivatingSparseCheckout = false;
                    if (paths.isEmpty() && !coreSparseCheckoutConfigEnable) {
                        return;
                    }
                    if (paths.isEmpty() && coreSparseCheckoutConfigEnable) {
                        deactivatingSparseCheckout = true;
                        paths = Collections.singletonList("/*");
                    } else if (!coreSparseCheckoutConfigEnable) {
                        CliGitAPIImpl.this.launchCommand("config", "core.sparsecheckout", "true");
                    }
                    File sparseCheckoutDir = new File(CliGitAPIImpl.this.workspace, CliGitAPIImpl.SPARSE_CHECKOUT_FILE_DIR);
                    if (!sparseCheckoutDir.exists() && !sparseCheckoutDir.mkdir()) {
                        throw new GitException("Impossible to create sparse checkout dir " + sparseCheckoutDir.getAbsolutePath());
                    }
                    File sparseCheckoutFile = new File(CliGitAPIImpl.this.workspace, CliGitAPIImpl.SPARSE_CHECKOUT_FILE_PATH);
                    try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(sparseCheckoutFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                        for (String path2 : paths) {
                            writer.println(path2);
                        }
                    }
                    catch (IOException e) {
                        throw new GitException("Could not write sparse checkout file " + sparseCheckoutFile.getAbsolutePath(), e);
                    }
                    if (this.lfsRemote != null) {
                        if (paths.stream().anyMatch(path -> path.contains(","))) {
                            this.setLfsFetchOption("lfs.fetchinclude", "");
                            this.setLfsFetchOption("lfs.fetchexclude", "");
                        } else {
                            String lfsIncludePaths = paths.stream().filter(path -> !path.startsWith("!")).collect(Collectors.joining(","));
                            String lfsExcludePaths = paths.stream().filter(path -> path.startsWith("!")).map(path -> path.substring(1)).collect(Collectors.joining(","));
                            this.setLfsFetchOption("lfs.fetchinclude", lfsIncludePaths);
                            this.setLfsFetchOption("lfs.fetchexclude", lfsExcludePaths);
                        }
                    }
                    try {
                        CliGitAPIImpl.this.launchCommand("read-tree", "-mu", "HEAD");
                    }
                    catch (GitException e) {
                        if (e.getMessage().contains("returned status code 128:")) break block29;
                        throw e;
                    }
                }
                if (deactivatingSparseCheckout) {
                    CliGitAPIImpl.this.launchCommand("config", "core.sparsecheckout", "false");
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void setLfsFetchOption(String key, String value) throws GitException, InterruptedException {
                if (value.isEmpty() || value.equals("/*")) {
                    try {
                        CliGitAPIImpl.this.launchCommand("config", "--unset", key);
                        return;
                    }
                    catch (GitException e) {
                        if (e.getMessage().contains("returned status code 5:")) return;
                        throw e;
                    }
                } else {
                    CliGitAPIImpl.this.launchCommand("config", key, value);
                }
            }
        };
    }

    @Override
    public boolean tagExists(String tagName) throws GitException, InterruptedException {
        return this.launchCommand("tag", "-l", tagName).trim().equals(tagName);
    }

    @Override
    public void deleteBranch(String name) throws GitException, InterruptedException {
        try {
            this.launchCommand("branch", "-D", name);
        }
        catch (GitException e) {
            throw new GitException("Could not delete branch " + name, e);
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException, InterruptedException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-d", tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, e);
        }
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand("ls-tree", recursive ? "-r" : null, treeIsh);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public RevListCommand revList_() {
        return new RevListCommand(){
            private boolean all;
            private boolean nowalk;
            private boolean firstParent;
            private String refspec;
            private List<ObjectId> out;

            @Override
            public RevListCommand all() {
                return this.all(true);
            }

            @Override
            public RevListCommand all(boolean all) {
                this.all = all;
                return this;
            }

            @Override
            public RevListCommand nowalk(boolean nowalk) {
                if (CliGitAPIImpl.this.isAtLeastVersion(1, 5, 3, 0)) {
                    this.nowalk = nowalk;
                }
                return this;
            }

            @Override
            public RevListCommand firstParent() {
                return this.firstParent(true);
            }

            @Override
            public RevListCommand firstParent(boolean firstParent) {
                this.firstParent = firstParent;
                return this;
            }

            @Override
            public RevListCommand to(List<ObjectId> revs) {
                this.out = revs;
                return this;
            }

            @Override
            public RevListCommand reference(String reference) {
                this.refspec = reference;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
                if (this.firstParent) {
                    args.add("--first-parent");
                }
                if (this.all) {
                    args.add("--all");
                }
                if (this.nowalk) {
                    args.add("--no-walk");
                }
                if (this.refspec != null) {
                    args.add(this.refspec);
                }
                String result = CliGitAPIImpl.this.launchCommand(args);
                BufferedReader rdr = new BufferedReader(new StringReader(result));
                if (this.out == null) {
                    throw new GitException("RevListCommand requires a value for 'to'");
                }
                try {
                    String line;
                    while ((line = rdr.readLine()) != null) {
                        this.out.add(ObjectId.fromString((String)line));
                    }
                }
                catch (IOException e) {
                    throw new GitException("Error parsing rev list", e);
                }
            }
        };
    }

    @Override
    public List<ObjectId> revListAll() throws GitException, InterruptedException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.all(true);
        revListCommand.to(oidList);
        revListCommand.execute();
        return oidList;
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException, InterruptedException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.reference(ref);
        revListCommand.to(oidList);
        revListCommand.execute();
        return oidList;
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws InterruptedException {
        if (commit == null) {
            return false;
        }
        try {
            ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
            RevListCommand revListCommand = this.revList_();
            revListCommand.reference(commit.name());
            revListCommand.to(oidList);
            revListCommand.nowalk(true);
            revListCommand.execute();
            return oidList.size() != 0;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void add(String filePattern) throws GitException, InterruptedException {
        try {
            this.launchCommand("add", filePattern);
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, e);
        }
    }

    @Override
    public void branch(String name) throws GitException, InterruptedException {
        try {
            this.launchCommand("branch", name);
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, e);
        }
    }

    @Override
    public void commit(String message) throws GitException, InterruptedException {
        File f = null;
        try {
            f = this.createTempFile("gitcommit", ".txt");
            try (OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                out.write(message.getBytes(Charset.defaultCharset().toString()));
            }
            this.launchCommand("commit", "-F", f.getAbsolutePath());
        }
        catch (GitException | IOException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        finally {
            this.deleteTempFile(f);
        }
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.credentials.put(url, credentials);
    }

    @Override
    public void clearCredentials() {
        this.credentials.clear();
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.defaultCredentials = credentials;
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.env("GIT_AUTHOR_NAME", name);
        this.env("GIT_AUTHOR_EMAIL", email);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.env("GIT_COMMITTER_NAME", name);
        this.env("GIT_COMMITTER_EMAIL", email);
    }

    private void env(String name, String value) {
        if (value == null) {
            this.environment.remove((Object)name);
        } else {
            this.environment.put(name, value);
        }
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="JGit interaction with spotbugs")
    @NonNull
    public Repository getRepository() throws GitException {
        try {
            return ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.workspace)).build();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public FilePath getWorkTree() {
        return new FilePath(this.workspace);
    }

    @Override
    public Set<String> getRemoteTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"ls-remote", "--tags"});
            String remoteUrl = this.getRemoteUrl("origin");
            if (remoteUrl != null) {
                this.addCheckedRemoteUrl(args, remoteUrl);
            }
            if (tagPattern != null) {
                args.add(tagPattern);
            }
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag.replaceFirst(".*refs/tags/", ""));
            }
            return tags;
        }
        catch (GitException | IOException | InterruptedException e) {
            throw new GitException("Error retrieving remote tag names", e);
        }
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (GitException | IOException | InterruptedException e) {
            throw new GitException("Error retrieving tag names", e);
        }
    }

    @Override
    public String getTagMessage(String tagName) throws GitException, InterruptedException {
        String out = this.launchCommand("tag", "-l", tagName, "-n10000");
        return out.substring(tagName.length()).replaceAll("(?m)(^    )", "").trim();
    }

    @Override
    public void ref(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try {
            this.launchCommand("update-ref", refName, "HEAD");
        }
        catch (GitException e) {
            throw new GitException("Could not apply ref " + refName, e);
        }
    }

    @Override
    public boolean refExists(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try {
            this.launchCommand("show-ref", refName);
            return true;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void deleteRef(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try {
            this.launchCommand("update-ref", "-d", refName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete ref " + refName, e);
        }
    }

    @Override
    public Set<String> getRefNames(String refPrefix) throws GitException, InterruptedException {
        refPrefix = refPrefix.isEmpty() ? "refs/" : refPrefix.replace(' ', '_');
        try {
            String ref;
            String result = this.launchCommand("for-each-ref", "--format=%(refname)", refPrefix);
            HashSet<String> refs = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((ref = rdr.readLine()) != null) {
                refs.add(ref);
            }
            return refs;
        }
        catch (GitException | IOException e) {
            throw new GitException("Error retrieving refs with prefix " + refPrefix, e);
        }
    }

    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        String[] lines;
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        args.add("-h");
        this.addCheckedRemoteUrl(args, url);
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        HashMap<String, ObjectId> heads = new HashMap<String, ObjectId>();
        for (String line : lines = result.split("\n")) {
            if (line.length() >= 41) {
                heads.put(line.substring(41), ObjectId.fromString((String)line.substring(0, 40)));
                continue;
            }
            this.listener.getLogger().println("Unexpected ls-remote output line '" + line + "'");
        }
        return heads;
    }

    @Override
    public ObjectId getHeadRev(String url, String branchSpec) throws GitException, InterruptedException {
        StandardCredentials cred;
        String branchName = this.extractBranchNameFromBranchSpec(branchSpec);
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        if (!branchName.startsWith("refs/tags/")) {
            args.add("-h");
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        this.addCheckedRemoteUrl(args, url);
        if (branchName.startsWith("refs/tags/")) {
            args.add(branchName + "^{}");
        } else {
            args.add(branchName);
        }
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        return result.length() >= 40 ? ObjectId.fromString((String)result.substring(0, 40)) : null;
    }

    @Override
    public Map<String, ObjectId> getRemoteReferences(String url, String pattern, boolean headsOnly, boolean tagsOnly) throws GitException, InterruptedException {
        String[] lines;
        StandardCredentials cred;
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        if (headsOnly) {
            args.add("-h");
        }
        if (tagsOnly) {
            args.add("-t");
        }
        this.addCheckedRemoteUrl(args, url);
        if (pattern != null) {
            args.add(pattern);
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        HashMap<String, ObjectId> references = new HashMap<String, ObjectId>();
        for (String line : lines = result.split("\n")) {
            if (line.length() < 41) continue;
            String refName = line.substring(41);
            ObjectId refObjectId = ObjectId.fromString((String)line.substring(0, 40));
            if (refName.startsWith("refs/tags") && refName.endsWith("^{}")) {
                String tagName = refName.replace("^{}", "");
                references.put(tagName, refObjectId);
                continue;
            }
            if (references.containsKey(refName)) continue;
            references.put(refName, refObjectId);
        }
        return references;
    }

    @Override
    public Map<String, String> getRemoteSymbolicReferences(String url, String pattern) throws GitException, InterruptedException {
        HashMap<String, String> references = new HashMap<String, String>();
        if (this.isAtLeastVersion(2, 8, 0, 0)) {
            StandardCredentials cred;
            ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
            args.add("--symref");
            this.addCheckedRemoteUrl(args, url);
            if (pattern != null) {
                args.add(pattern);
            }
            if ((cred = this.credentials.get(url)) == null) {
                cred = this.defaultCredentials;
            }
            String result = this.launchCommandWithCredentials(args, null, cred, url);
            String[] lines = result.split("\n");
            Pattern symRefPattern = Pattern.compile("^ref:\\s+([^ ]+)\\s+([^ ]+)$");
            for (String line : lines) {
                Matcher matcher = symRefPattern.matcher(line);
                if (!matcher.matches()) continue;
                references.put(matcher.group(2), matcher.group(1));
            }
        }
        return references;
    }

    @Override
    @Deprecated
    public void merge(String refSpec) throws GitException, InterruptedException {
        try {
            this.launchCommand("merge", refSpec);
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + refSpec, e);
        }
    }

    @Override
    @Deprecated
    public void push(RemoteConfig repository, String refspec) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        URIish uri = (URIish)repository.getURIs().get(0);
        String url = uri.toPrivateString();
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        args.add("push");
        this.addCheckedRemoteUrl(args, url);
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, uri);
    }

    @Override
    @Deprecated
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        return this.getBranchesContaining(revspec, true);
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec, boolean allBranches) throws GitException, InterruptedException {
        String commandOutput = allBranches ? this.launchCommand("branch", "-a", "-v", "--no-abbrev", "--contains", revspec) : this.launchCommand("branch", "-v", "--no-abbrev", "--contains", revspec);
        return new ArrayList<Branch>(this.parseBranches(commandOutput));
    }

    @Override
    @Deprecated
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) throws InterruptedException {
        try {
            String result;
            try {
                result = this.launchCommand("merge-base", id1.name(), id2.name());
            }
            catch (GitException ge) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (GitException | IOException e) {
            throw new GitException("Error parsing merge base", e);
        }
        return null;
    }

    @Override
    @Deprecated
    public String getAllLogEntries(String branch) throws InterruptedException {
        return this.launchCommand("log", "--all", "--pretty=format:'%H#%ct'", branch);
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private boolean isZos() {
        return File.pathSeparatorChar == ':' && System.getProperty("os.name").equals("z/OS");
    }

    private static boolean setsidExists() {
        String[] prefixes;
        if (File.pathSeparatorChar == ';') {
            return false;
        }
        for (String prefix : prefixes = new String[]{"/usr/local/bin/", "/usr/bin/", "/bin/", "/usr/local/sbin/", "/usr/sbin/", "/sbin/"}) {
            File setsidFile = new File(prefix + "setsid");
            if (!setsidFile.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<GitObject> getTags() throws GitException, InterruptedException {
        String result;
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"show-ref", "--tags", "-d"});
        try {
            result = this.launchCommandIn(args, this.workspace);
        }
        catch (GitException ge) {
            result = "";
        }
        String[] output = result.split("[\\n\\r]+");
        if (output.length == 0 || output.length == 1 && output[0].isEmpty()) {
            return Collections.emptySet();
        }
        Pattern pattern = Pattern.compile("(\\p{XDigit}{40})\\s+refs/tags/([^^]+)(\\^\\{\\})?");
        HashMap<String, ObjectId> tagMap = new HashMap<String, ObjectId>();
        for (String line : output) {
            boolean isPeeledRef;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) {
                String message = MessageFormat.format("git show-ref --tags -d output not matched in line: {0}", line);
                this.listener.getLogger().println(message);
                continue;
            }
            String sha1String = matcher.group(1);
            String tagName = matcher.group(2);
            String trailingText = matcher.group(3);
            boolean bl = isPeeledRef = trailingText != null && trailingText.equals("^{}");
            if (!isPeeledRef && tagMap.containsKey(tagName)) continue;
            tagMap.put(tagName, ObjectId.fromString((String)sha1String));
        }
        HashSet<GitObject> tags = new HashSet<GitObject>(tagMap.size());
        for (Map.Entry entry : tagMap.entrySet()) {
            tags.add(new GitObject((String)entry.getKey(), (ObjectId)entry.getValue()));
        }
        return tags;
    }

    static {
        ACL_ENTRY_PERMISSIONS = EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.EXECUTE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.READ_ACL, AclEntryPermission.SYNCHRONIZE});
        CALL_SETSID = CliGitAPIImpl.setsidExists() && USE_SETSID;
        USE_FORCE_FETCH = Boolean.parseBoolean(System.getProperty(CliGitAPIImpl.class.getName() + ".forceFetch", "true"));
        INDEX_LOCK_FILE_PATH = ".git" + File.separator + "index.lock";
        CHECK_REMOTE_URL = Boolean.parseBoolean(System.getProperty(CliGitAPIImpl.class.getName() + ".checkRemoteURL", "true"));
        TIMEOUT = Integer.getInteger(Git.class.getName() + ".timeOut", 10);
    }
}

