/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletDiskFileUpload;
import org.jvnet.tiger_types.Lister;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.AncestorImpl;
import org.kohsuke.stapler.BindInterceptor;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundResolvable;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.NoStaplerConstructorException;
import org.kohsuke.stapler.ReflectionUtils;
import org.kohsuke.stapler.SingleLinkedList;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.TokenList;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WrongTypeException;
import org.kohsuke.stapler.bind.Bound;
import org.kohsuke.stapler.bind.BoundObjectTable;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.MethodRef;
import org.kohsuke.stapler.util.IllegalReflectiveAccessLogHandler;

public class RequestImpl
extends HttpServletRequestWrapper
implements StaplerRequest2 {
    public final TokenList tokens;
    public final List<AncestorImpl> ancestors;
    private final List<Ancestor> ancestorsView;
    public final Stapler stapler;
    private final String originalRequestURI;
    private JSONObject structuredForm;
    private Map<String, FileItem> parsedFormData;
    private Map<String, String> parsedFormDataFormFields;
    private BindInterceptor bindInterceptor = BindInterceptor.NOOP;
    private static List<String> ALLOWED_HTTP_VERBS_FOR_FORMS;
    private static int FILEUPLOAD_MAX_FILES;
    private static long FILEUPLOAD_MAX_FILE_SIZE;
    private static long FILEUPLOAD_MAX_SIZE;
    private static final Logger LOGGER;

    public RequestImpl(Stapler stapler, HttpServletRequest request, List<AncestorImpl> ancestors, TokenList tokens) {
        super(request);
        this.stapler = stapler;
        this.ancestors = ancestors;
        this.ancestorsView = Collections.unmodifiableList(ancestors);
        this.tokens = tokens;
        this.originalRequestURI = request.getRequestURI();
    }

    @Deprecated
    public RequestImpl(Stapler stapler, javax.servlet.http.HttpServletRequest request, List<AncestorImpl> ancestors, TokenList tokens) {
        this(stapler, io.jenkins.servlet.http.HttpServletRequestWrapper.toJakartaHttpServletRequest(request), ancestors, tokens);
    }

    @Override
    public boolean isJavaScriptProxyCall() {
        String ct = this.getContentType();
        return ct != null && ct.startsWith("application/x-stapler-method-invocation");
    }

    @Override
    public BoundObjectTable getBoundObjectTable() {
        return this.stapler.getWebApp().boundObjectTable;
    }

    @Override
    public String createJavaScriptProxy(Object toBeExported) {
        return this.getBoundObjectTable().bind(toBeExported).getProxyScript();
    }

    @Override
    public StaplerRequest2.RenderOnDemandParameters createJavaScriptProxyParameters(Object toBeExported) {
        Bound bound = this.getBoundObjectTable().bind(toBeExported);
        return new StaplerRequest2.RenderOnDemandParameters("makeStaplerProxy", bound.getURL(), this.getWebApp().getCrumbIssuer().issueCrumb(), bound.getBoundJavaScriptUrlNames());
    }

    @Override
    public Stapler getStapler() {
        return this.stapler;
    }

    @Override
    public WebApp getWebApp() {
        return this.stapler.getWebApp();
    }

    @Override
    public String getRestOfPath() {
        return this.tokens.assembleRestOfPath();
    }

    @Override
    public String getOriginalRestOfPath() {
        return this.tokens.assembleOriginalRestOfPath();
    }

    @Override
    public ServletContext getServletContext() {
        return this.stapler.getServletContext();
    }

    public String getParameter(String name) {
        Map<String, String> data;
        String value;
        if (this.isMultipart() && (value = (data = this.getFormDataFormFields()).get(name)) != null) {
            return value;
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        Map<String, String[]> parameterMap = super.getParameterMap();
        if (this.isMultipart()) {
            Map<String, String> data = this.getFormDataFormFields();
            parameterMap = new HashMap(parameterMap);
            for (Map.Entry<String, String> e : data.entrySet()) {
                String[] values = (String[])parameterMap.get(e.getKey());
                if (values == null) {
                    values = new String[]{e.getValue()};
                } else {
                    int len = values.length;
                    String[] moreValues = Arrays.copyOf(values, len + 1);
                    moreValues[len] = e.getValue();
                    values = moreValues;
                }
                parameterMap.put(e.getKey(), values);
            }
            parameterMap = Collections.unmodifiableMap(parameterMap);
        }
        return parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        if (!this.isMultipart()) {
            return super.getParameterNames();
        }
        Map<String, String> data = this.getFormDataFormFields();
        if (data.isEmpty()) {
            return super.getParameterNames();
        }
        ArrayList paramNames = Collections.list(super.getParameterNames());
        paramNames.addAll(data.keySet());
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String name) {
        if (!this.isMultipart()) {
            return super.getParameterValues(name);
        }
        Map<String, String> data = this.getFormDataFormFields();
        if (data.isEmpty()) {
            return super.getParameterValues(name);
        }
        String formFieldVal = data.get(name);
        if (formFieldVal == null) {
            return super.getParameterValues(name);
        }
        String[] values = super.getParameterValues(name);
        if (values == null) {
            values = new String[]{};
        }
        String[] extValues = new String[values.length + 1];
        System.arraycopy(values, 0, extValues, 0, values.length);
        extValues[extValues.length - 1] = formFieldVal;
        return extValues;
    }

    @Override
    public String getRequestURIWithQueryString() {
        Object s = this.getRequestURI();
        String q = this.getQueryString();
        if (q != null) {
            s = (String)s + "?" + q;
        }
        return s;
    }

    @Override
    public StringBuffer getRequestURLWithQueryString() {
        StringBuffer s = this.getRequestURL();
        String q = this.getQueryString();
        if (q != null) {
            s.append('?').append(q);
        }
        return s;
    }

    @Override
    public RequestDispatcher getView(Object it, String viewName) throws IOException {
        return this.getView(Klass.java(it.getClass()), it, viewName);
    }

    @Override
    public RequestDispatcher getView(Class clazz, String viewName) throws IOException {
        return this.getView(Klass.java(clazz), null, viewName);
    }

    @Override
    public RequestDispatcher getView(Klass<?> clazz, String viewName) throws IOException {
        return this.getView(clazz, null, viewName);
    }

    public RequestDispatcher getView(Klass<?> clazz, Object it, String viewName) throws IOException {
        for (Facet f : this.stapler.getWebApp().facets) {
            RequestDispatcher rd = f.createRequestDispatcher(this, clazz, it, viewName);
            if (rd == null) continue;
            return rd;
        }
        return null;
    }

    @Override
    public String getRootPath() {
        StringBuffer buf = super.getRequestURL();
        int idx = 0;
        for (int i = 0; i < 3; ++i) {
            idx += buf.substring(idx).indexOf("/") + 1;
        }
        buf.setLength(idx - 1);
        buf.append(super.getContextPath());
        return buf.toString();
    }

    @Override
    public String getReferer() {
        return this.getHeader("Referer");
    }

    @Override
    public List<Ancestor> getAncestors() {
        return this.ancestorsView;
    }

    @Override
    public Ancestor findAncestor(Class type) {
        for (int i = this.ancestors.size() - 1; i >= 0; --i) {
            AncestorImpl a = this.ancestors.get(i);
            Object o = a.getObject();
            if (!type.isInstance(o)) continue;
            return a;
        }
        return null;
    }

    @Override
    public <T> T findAncestorObject(Class<T> type) {
        Ancestor a = this.findAncestor(type);
        if (a == null) {
            return null;
        }
        return type.cast(a.getObject());
    }

    @Override
    public Ancestor findAncestor(Object anc) {
        for (int i = this.ancestors.size() - 1; i >= 0; --i) {
            AncestorImpl a = this.ancestors.get(i);
            Object o = a.getObject();
            if (o != anc) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean hasParameter(String name) {
        return this.getParameter(name) != null;
    }

    @Override
    public String getOriginalRequestURI() {
        return this.originalRequestURI;
    }

    @Override
    public boolean checkIfModified(long lastModified, StaplerResponse2 rsp) {
        return this.checkIfModified(lastModified, rsp, 0L);
    }

    @Override
    public boolean checkIfModified(long lastModified, StaplerResponse2 rsp, long expiration) {
        if (lastModified <= 0L) {
            return false;
        }
        String since = this.getHeader("If-Modified-Since");
        SimpleDateFormat format = Stapler.HTTP_DATE_FORMAT.get();
        if (since != null) {
            try {
                long ims = format.parse(since).getTime();
                if (lastModified < ims + 1000L) {
                    rsp.setStatus(304);
                    return true;
                }
            }
            catch (NumberFormatException | ParseException ims) {
                // empty catch block
            }
        }
        String tm = format.format(new Date(lastModified));
        rsp.setHeader("Last-Modified", tm);
        if (expiration == 0L) {
            rsp.setHeader("Expires", tm);
        } else {
            rsp.setHeader("Expires", format.format(new Date(new Date().getTime() + expiration)));
        }
        return false;
    }

    @Override
    public boolean checkIfModified(Date timestampOfResource, StaplerResponse2 rsp) {
        return this.checkIfModified(timestampOfResource.getTime(), rsp);
    }

    @Override
    public boolean checkIfModified(Calendar timestampOfResource, StaplerResponse2 rsp) {
        return this.checkIfModified(timestampOfResource.getTimeInMillis(), rsp);
    }

    @Override
    public BindInterceptor getBindInterceptor() {
        return this.bindInterceptor;
    }

    @Override
    public BindInterceptor setBindListener(BindInterceptor bindListener) {
        return this.setBindInterceptor(bindListener);
    }

    @Override
    public BindInterceptor setBindInterceptpr(BindInterceptor bindListener) {
        return this.setBindInterceptor(bindListener);
    }

    @Override
    public BindInterceptor setBindInterceptor(BindInterceptor bindListener) {
        BindInterceptor o = this.bindInterceptor;
        this.bindInterceptor = bindListener;
        return o;
    }

    @Override
    public void bindParameters(Object bean) {
        this.bindParameters(bean, "");
    }

    @Override
    public void bindParameters(Object bean, String prefix) {
        Enumeration<String> e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            if (!name.startsWith(prefix)) continue;
            RequestImpl.fill(bean, name.substring(prefix.length()), this.getParameter(name));
        }
    }

    @Override
    public <T> List<T> bindParametersToList(Class<T> type, String prefix) {
        ArrayList<T> r = new ArrayList<T>();
        int len = Integer.MAX_VALUE;
        Enumeration<String> e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            if (!name.startsWith(prefix)) continue;
            len = Math.min(len, this.getParameterValues(name).length);
        }
        if (len == Integer.MAX_VALUE) {
            return r;
        }
        try {
            new ClassDescriptor(type, new Class[0]).loadConstructorParamNames();
            for (int i = 0; i < len; ++i) {
                r.add(this.bindParameters(type, prefix, i));
            }
        }
        catch (NoStaplerConstructorException unused) {
            try {
                for (int i = 0; i < len; ++i) {
                    T t = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    r.add(t);
                    e = this.getParameterNames();
                    while (e.hasMoreElements()) {
                        String name = e.nextElement();
                        if (!name.startsWith(prefix)) continue;
                        RequestImpl.fill(t, name.substring(prefix.length()), this.getParameterValues(name)[i]);
                    }
                }
            }
            catch (NoSuchMethodException x) {
                throw new NoSuchMethodError(x.getMessage());
            }
            catch (InstantiationException x) {
                throw new InstantiationError(x.getMessage());
            }
            catch (IllegalAccessException x) {
                throw new IllegalAccessError(x.getMessage());
            }
            catch (InvocationTargetException x) {
                Throwable t = x.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof IOException) {
                    throw new UncheckedIOException((IOException)t);
                }
                if (t instanceof Exception) {
                    throw new RuntimeException(t);
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error(x);
            }
        }
        return r;
    }

    @Override
    public <T> T bindParameters(Class<T> type, String prefix) {
        return this.bindParameters(type, prefix, 0);
    }

    @Override
    public <T> T bindParameters(Class<T> type, String prefix, int index) {
        String[] names = new ClassDescriptor(type, new Class[0]).loadConstructorParamNames();
        Object[] args = new Object[names.length];
        Constructor<T> c = this.findConstructor(type, names.length);
        Class<?>[] types = c.getParameterTypes();
        for (int i = 0; i < names.length; ++i) {
            String[] values = this.getParameterValues(prefix + names[i]);
            String param = values != null ? values[index] : null;
            Converter converter = Stapler.lookupConverter(types[i]);
            if (converter == null) {
                throw new IllegalArgumentException("Unable to convert to " + String.valueOf(types[i]));
            }
            args[i] = converter.convert(types[i], (Object)param);
        }
        return this.invokeConstructor(c, args);
    }

    @Override
    public <T> T bindJSON(Class<T> type, JSONObject src) {
        return type.cast(this.bindJSON((Type)type, (Class)type, (Object)src));
    }

    public Object bindJSON(Type type, Class erasure, Object json) {
        return new TypePair(type, erasure).convertJSON(json);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void bindJSON(Object bean, JSONObject src) {
        try {
            for (String key : src.keySet()) {
                TypePair type = this.getPropertyType(bean, key);
                if (type == null) continue;
                try {
                    RequestImpl.fill(bean, key, type.convertJSON(src.get(key)));
                }
                catch (WrongTypeException e) {
                    throw new IllegalArgumentException(String.format("Error binding field %s: %s", key, e.getMessage()));
                    return;
                }
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError(e.getMessage());
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException x) {
            Throwable e = x.getTargetException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (!(e instanceof Error)) throw new RuntimeException(x);
            throw (Error)e;
        }
    }

    @Override
    public <T> List<T> bindJSONToList(Class<T> type, Object src) {
        ArrayList<T> r = new ArrayList<T>();
        if (src instanceof JSONObject) {
            JSONObject j = (JSONObject)src;
            r.add(this.bindJSON(type, j));
        }
        if (src instanceof JSONArray) {
            JSONArray a = (JSONArray)src;
            for (Object o : a) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject j = (JSONObject)o;
                r.add(this.bindJSON(type, j));
            }
        }
        return r;
    }

    private <T> T invokeConstructor(Constructor<T> c, Object[] args) {
        try {
            return c.newInstance(args);
        }
        catch (InstantiationException e) {
            InstantiationError x = new InstantiationError(e.getMessage());
            x.initCause(e);
            throw x;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError(e.getMessage());
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            RequestImpl.launderITE(e);
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to invoke " + String.valueOf(c) + " with " + String.valueOf(Arrays.asList(args)), e);
        }
    }

    private <T> Constructor<T> findConstructor(Class<T> type, int length) {
        Constructor<?>[] ctrs;
        for (Constructor<?> c : ctrs = type.getConstructors()) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            if (c.getParameterTypes().length != length) {
                throw new IllegalArgumentException(String.valueOf(c) + " has @DataBoundConstructor but it doesn't match with your .stapler file. Try clean rebuild");
            }
            return c;
        }
        for (Constructor<?> c : ctrs) {
            if (c.getParameterTypes().length != length) continue;
            return c;
        }
        throw new IllegalArgumentException(String.valueOf(type) + " does not have a constructor with " + length + " arguments");
    }

    private static void fill(Object bean, String key, Object value) {
        StringTokenizer tokens = new StringTokenizer(key);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            boolean last = !tokens.hasMoreTokens();
            try {
                if (last) {
                    RequestImpl.copyProperty(bean, token, value);
                    continue;
                }
                bean = BeanUtils.getProperty((Object)bean, (String)token);
            }
            catch (IllegalAccessException x) {
                throw new IllegalAccessError(x.getMessage());
            }
            catch (InvocationTargetException x) {
                Throwable e = x.getTargetException();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException(x);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
    }

    private Object instantiate(Class actualType, JSONObject j) {
        Object r = this.bindInterceptor.instantiate(actualType, j);
        if (r != BindInterceptor.DEFAULT) {
            return r;
        }
        for (BindInterceptor bi : this.getWebApp().bindInterceptors) {
            r = bi.instantiate(actualType, j);
            if (r == BindInterceptor.DEFAULT) continue;
            return r;
        }
        if (actualType == JSONObject.class || actualType == JSON.class) {
            return actualType.cast(j);
        }
        String[] names = new ClassDescriptor(actualType, new Class[0]).loadConstructorParamNames();
        Object[] args = new Object[names.length];
        Constructor c = this.findConstructor(actualType, names.length);
        Class<?>[] types = c.getParameterTypes();
        Type[] genTypes = c.getGenericParameterTypes();
        for (int i = 0; i < names.length; ++i) {
            try {
                args[i] = this.bindJSON(genTypes[i], (Class)types[i], j.get(names[i]));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to convert the " + names[i] + " parameter of the constructor " + String.valueOf(c), e);
            }
        }
        Object o = this.injectSetters(this.invokeConstructor(c, args), j, Arrays.asList(names));
        o = this.bindResolve(o, j);
        return o;
    }

    private Object bindResolve(Object o, JSONObject src) {
        if (o instanceof DataBoundResolvable) {
            DataBoundResolvable dbr = (DataBoundResolvable)o;
            o = dbr.bindResolve(this, src);
        }
        return o;
    }

    private <T> T injectSetters(T r, JSONObject j, Collection<String> exclusions) {
        block7: for (String key : j.keySet()) {
            if (exclusions.contains(key)) continue;
            try {
                for (Class<?> c = r.getClass(); c != null; c = c.getSuperclass()) {
                    try {
                        Field f = c.getDeclaredField(key);
                        if (f.getAnnotation(DataBoundSetter.class) == null) continue;
                        try {
                            f.set(r, this.bindJSON(f.getGenericType(), (Class)f.getType(), j.get(key)));
                        }
                        catch (IllegalAccessException e) {
                            LOGGER.warning(IllegalReflectiveAccessLogHandler.get(e));
                            f.setAccessible(true);
                            f.set(r, this.bindJSON(f.getGenericType(), (Class)f.getType(), j.get(key)));
                        }
                        continue block7;
                    }
                    catch (NoSuchFieldException f) {
                        // empty catch block
                    }
                }
                Method wm = this.findDataBoundSetter(r.getClass(), key);
                if (wm == null) continue;
                Class<?>[] pt = wm.getParameterTypes();
                assert (pt.length == 1);
                wm.invoke(r, this.bindJSON(wm.getGenericParameterTypes()[0], (Class)pt[0], j.get(key)));
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.WARNING, "Cannot access property " + key + " of " + String.valueOf(r.getClass()), e);
            }
            catch (InvocationTargetException e) {
                RequestImpl.launderITE(e);
            }
        }
        this.invokePostConstruct(this.getWebApp().getMetaClass(r).getPostConstructMethods(), r);
        return r;
    }

    private static void launderITE(InvocationTargetException e) {
        Throwable x = e.getTargetException();
        if (x instanceof Error) {
            Error err = (Error)x;
            throw err;
        }
        if (x instanceof RuntimeException) {
            RuntimeException rt = (RuntimeException)x;
            throw rt;
        }
        if (x instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)((Object)x);
            throw HttpResponses.wrap(httpResponse);
        }
        throw new IllegalArgumentException(x);
    }

    private Method findDataBoundSetter(Class c, String name) {
        while (c != null) {
            for (Method m : c.getDeclaredMethods()) {
                String propertyName;
                if (!Modifier.isPublic(m.getModifiers()) || !m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !m.isAnnotationPresent(DataBoundSetter.class) || !name.equals(propertyName = Introspector.decapitalize(m.getName().substring(3)))) continue;
                return m;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private void invokePostConstruct(SingleLinkedList<MethodRef> methods, Object r) {
        if (methods.isEmpty()) {
            return;
        }
        this.invokePostConstruct(methods.tail, r);
        try {
            ((MethodRef)methods.head).invoke(r, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to post-construct " + String.valueOf(r), e);
        }
        catch (IllegalAccessException e) {
            throw (Error)new IllegalAccessError().initCause(e);
        }
    }

    private TypePair getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException {
        try {
            Method m;
            PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)name);
            if (propDescriptor != null && (m = propDescriptor.getWriteMethod()) != null) {
                return new TypePair(m.getGenericParameterTypes()[0], m.getParameterTypes()[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            return new TypePair(bean.getClass().getField(name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static void copyProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor propDescriptor;
        try {
            propDescriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)name);
        }
        catch (NoSuchMethodException e) {
            propDescriptor = null;
        }
        if (propDescriptor != null && propDescriptor.getWriteMethod() == null) {
            propDescriptor = null;
        }
        if (propDescriptor != null) {
            Converter converter = Stapler.lookupConverter(propDescriptor.getPropertyType());
            if (converter != null) {
                value = converter.convert(propDescriptor.getPropertyType(), value);
            }
            try {
                PropertyUtils.setSimpleProperty((Object)bean, (String)name, (Object)value);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
            return;
        }
        try {
            Field field = bean.getClass().getField(name);
            Converter converter = ConvertUtils.lookup(field.getType());
            if (converter != null) {
                value = converter.convert(field.getType(), value);
            }
            field.set(bean, value);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void parseMultipartFormData() throws IOException, ServletException {
        File tmpDir;
        if (this.parsedFormData != null) {
            return;
        }
        this.parsedFormData = new HashMap<String, FileItem>();
        this.parsedFormDataFormFields = new HashMap<String, String>();
        try {
            tmpDir = Files.createTempDirectory("jenkins-stapler-uploads", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new ServletException("Error creating temporary directory", (Throwable)e);
        }
        tmpDir.deleteOnExit();
        JakartaServletDiskFileUpload upload = new JakartaServletDiskFileUpload(((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setFile(tmpDir)).get());
        upload.setFileCountMax((long)FILEUPLOAD_MAX_FILES);
        upload.setFileSizeMax(FILEUPLOAD_MAX_FILE_SIZE);
        upload.setSizeMax(FILEUPLOAD_MAX_SIZE);
        try {
            for (FileItem fi : upload.parseRequest((HttpServletRequest)this)) {
                this.parsedFormData.put(fi.getFieldName(), fi);
                if (!fi.isFormField()) continue;
                this.parsedFormDataFormFields.put(fi.getFieldName(), fi.getString());
            }
        }
        catch (FileUploadFileCountLimitException e) {
            throw new ServletException("File upload field count limit exceeded. Consider setting the Java system property " + RequestImpl.class.getName() + ".FILEUPLOAD_MAX_FILES to a value greater than " + FILEUPLOAD_MAX_FILES + ", or to -1 to disable this limit.", (Throwable)e);
        }
        catch (FileUploadByteCountLimitException e) {
            throw new ServletException("File upload field size limit exceeded. Consider setting the Java system property " + RequestImpl.class.getName() + ".FILEUPLOAD_MAX_FILE_SIZE to a value greater than " + FILEUPLOAD_MAX_FILE_SIZE + ", or to -1 to disable this limit.", (Throwable)e);
        }
        catch (FileUploadSizeException e) {
            throw new ServletException("File upload total size limit exceeded. Consider setting the Java system property " + RequestImpl.class.getName() + ".FILEUPLOAD_MAX_SIZE to a value greater than " + FILEUPLOAD_MAX_SIZE + ", or to -1 to disable this limit.", (Throwable)e);
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Map<String, String> getFormDataFormFields() {
        try {
            this.parseMultipartFormData();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error parsing multipart/form-data.", e);
        }
        return this.parsedFormDataFormFields;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public JSONObject getSubmittedForm() throws ServletException {
        method = this.getMethod();
        if (!RequestImpl.ALLOWED_HTTP_VERBS_FOR_FORMS.contains(method)) {
            throw HttpResponses.errorWithoutStack(400, "Form submission expected but a " + method + " request was sent");
        }
        if (this.structuredForm == null) {
            p = null;
            if (this.isMultipart()) {
                isSubmission = true;
                try {
                    this.parseMultipartFormData();
                    item = this.parsedFormData.get("json");
                    if (item == null) ** GOTO lbl26
                    if (item.getContentType() == null && this.getCharacterEncoding() != null) {
                        try {
                            p = item.getString(Charset.forName(this.getCharacterEncoding()));
                        }
                        catch (UnsupportedEncodingException uee) {
                            RequestImpl.LOGGER.log(Level.WARNING, "Request has unsupported charset, using default for 'json' parameter", uee);
                            p = item.getString();
                        }
                    }
                    p = item.getString();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                p = this.getParameter("json");
                v0 = isSubmission = this.getParameterMap().isEmpty() == false;
            }
lbl26:
            // 5 sources

            if (p == null || p.isEmpty()) {
                try {
                    rsp = Stapler.getCurrentResponse2();
                    if (isSubmission) {
                        rsp.sendError(400, "This page expects a form submission");
                    } else {
                        rsp.sendError(400, "Nothing is submitted");
                    }
                    throw new ServletException("This page expects a form submission but had only " + String.valueOf(this.getParameterMap()));
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            try {
                this.structuredForm = JSONObject.fromObject((Object)p);
            }
            catch (JSONException e) {
                throw new ServletException("Failed to parse JSON:" + p, (Throwable)e);
            }
        }
        return this.structuredForm;
    }

    private boolean isMultipart() {
        String ct = this.getContentType();
        return ct != null && ct.startsWith("multipart/");
    }

    @Override
    public FileItem getFileItem2(String name) throws ServletException, IOException {
        this.parseMultipartFormData();
        if (this.parsedFormData == null) {
            return null;
        }
        FileItem item = this.parsedFormData.get(name);
        if (item == null || item.isFormField()) {
            return null;
        }
        return item;
    }

    @Override
    @Deprecated
    public org.apache.commons.fileupload.FileItem getFileItem(String name) throws ServletException, IOException {
        FileItem fileItem = this.getFileItem2(name);
        return fileItem != null ? org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem(fileItem) : null;
    }

    static {
        FILEUPLOAD_MAX_FILES = Integer.getInteger(RequestImpl.class.getName() + ".FILEUPLOAD_MAX_FILES", 1000);
        FILEUPLOAD_MAX_FILE_SIZE = Long.getLong(RequestImpl.class.getName() + ".FILEUPLOAD_MAX_FILE_SIZE", -1L);
        FILEUPLOAD_MAX_SIZE = Long.getLong(RequestImpl.class.getName() + ".FILEUPLOAD_MAX_SIZE", -1L);
        ALLOWED_HTTP_VERBS_FOR_FORMS = Arrays.stream(System.getProperty(RequestImpl.class.getName() + ".ALLOWED_HTTP_VERBS_FOR_FORMS", "POST").split(",")).map(String::trim).collect(Collectors.toList());
        LOGGER = Logger.getLogger(RequestImpl.class.getName());
    }

    private final class TypePair {
        final Type genericType;
        final Class type;

        TypePair(Type genericType, Class type) {
            this.genericType = genericType;
            this.type = type;
        }

        TypePair(Field f) {
            this(f.getGenericType(), f.getType());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object convertJSON(Object o) {
            Converter converter;
            Object r = RequestImpl.this.bindInterceptor.onConvert(this.genericType, this.type, o);
            if (r != BindInterceptor.DEFAULT) {
                return r;
            }
            for (BindInterceptor i : RequestImpl.this.getWebApp().bindInterceptors) {
                r = i.onConvert(this.genericType, this.type, o);
                if (r == BindInterceptor.DEFAULT) continue;
                return r;
            }
            if (o == null || o instanceof JSONNull) {
                return ReflectionUtils.getVmDefaultValueFor(this.type);
            }
            if (this.type == JSONArray.class) {
                if (o instanceof JSONArray) {
                    return o;
                }
                JSONArray a = new JSONArray();
                a.add(o);
                return a;
            }
            Lister l = this.createNullFreeLister(this.type, this.genericType);
            if (o instanceof JSONObject) {
                JSONObject j = (JSONObject)o;
                if (j.isNullObject()) {
                    return ReflectionUtils.getVmDefaultValueFor(this.type);
                }
                if (l == null) {
                    try {
                        Class<?> actualType = this.type;
                        boolean isArray = false;
                        String className = null;
                        if (j.has("stapler-class")) {
                            if (j.optJSONArray("stapler-class") != null) {
                                isArray = true;
                            }
                            className = j.getString("stapler-class");
                            LOGGER.log(Level.FINE, "stapler-class is deprecated in favor of $class: {0}", className);
                        }
                        if (j.has("$class")) {
                            if (j.optJSONArray("$class") != null) {
                                isArray = true;
                            }
                            className = j.getString("$class");
                        }
                        if (className == null) return RequestImpl.this.instantiate(actualType, j);
                        if (isArray) {
                            throw new IllegalArgumentException("The frontend sent an unexpected list of classes (" + className + ") rather than an expected single class. See https://www.jenkins.io/doc/developer/views/table-to-div-migration/ for more information.");
                        }
                        ClassLoader cl = RequestImpl.this.stapler.getWebApp().getClassLoader();
                        try {
                            Class<?> subType = cl.loadClass(className);
                            if (!actualType.isAssignableFrom(subType)) {
                                throw new IllegalArgumentException("Specified type " + String.valueOf(subType) + " is not assignable to the expected " + String.valueOf(actualType));
                            }
                            actualType = subType;
                            return RequestImpl.this.instantiate(actualType, j);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Class " + className + " is specified in JSON, but no such class found in " + String.valueOf(cl), e);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        JSONObject sanitizedJson = RequestImpl.this.getWebApp().getJsonInErrorMessageSanitizer().sanitize(j);
                        throw new IllegalArgumentException("Failed to instantiate " + String.valueOf(this.type) + " from " + String.valueOf(sanitizedJson), e);
                    }
                }
                if (j.has("stapler-class-bag")) {
                    ClassLoader cl = RequestImpl.this.stapler.getWebApp().getClassLoader();
                    for (Map.Entry e : j.entrySet()) {
                        Object v = e.getValue();
                        String className = ((String)e.getKey()).replace('-', '.');
                        try {
                            Class<?> itemType = cl.loadClass(className);
                            if (v instanceof JSONObject) {
                                l.add(RequestImpl.this.bindJSON(itemType, (JSONObject)v));
                            }
                            if (!(v instanceof JSONArray)) continue;
                            for (Object i : RequestImpl.this.bindJSONToList(itemType, (JSONArray)v)) {
                                l.add(i);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                    return l.toCollection();
                } else if (Enum.class.isAssignableFrom(l.itemType)) {
                    for (Map.Entry e : j.entrySet()) {
                        Object v = e.getValue();
                        if (v == null || v instanceof Boolean && !((Boolean)v).booleanValue()) continue;
                        l.add(Enum.valueOf(l.itemType, (String)e.getKey()));
                    }
                    return l.toCollection();
                } else {
                    l.add(new TypePair(l.itemGenericType, l.itemType).convertJSON(j));
                }
                return l.toCollection();
            }
            if (o instanceof JSONArray) {
                JSONArray a = (JSONArray)o;
                if (l == null) {
                    throw new WrongTypeException(String.format("Got type array but no lister class found for type %s", this.type));
                }
                TypePair itemType = new TypePair(l.itemGenericType, l.itemType);
                for (Object item : a) {
                    l.add(itemType.convertJSON(item));
                }
                return l.toCollection();
            }
            if (Enum.class.isAssignableFrom(this.type)) {
                return Enum.valueOf(this.type, o.toString());
            }
            if (l == null) {
                converter = Stapler.lookupConverter(this.type);
                if (converter != null) return converter.convert(this.type, o);
                if (this.type != Object.class) throw new IllegalArgumentException("Unable to convert to " + String.valueOf(this.type));
                return o;
            }
            converter = Stapler.lookupConverter(l.itemType);
            if (converter == null) {
                if (l.itemType != Object.class) throw new IllegalArgumentException("Unable to convert to " + String.valueOf(l.itemType));
                l.add(o);
                return l.toCollection();
            } else {
                l.add(converter.convert(l.itemType, o));
            }
            return l.toCollection();
        }

        private Lister createNullFreeLister(Class itemType, Type itemGenericType) {
            final Lister l = Lister.create((Class)itemType, (Type)itemGenericType);
            if (l == null) {
                return null;
            }
            return new Lister(l.itemType, l.itemGenericType){

                public Object toCollection() {
                    return l.toCollection();
                }

                public void add(Object o) {
                    if (o != null) {
                        l.add(o);
                    }
                }
            };
        }
    }
}

