/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.json;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@InjectedParameter(value=Handler.class)
public @interface JsonBody {

    public static class Handler
    extends AnnotationHandler {
        public Object parse(StaplerRequest2 request, Annotation a, Class type, String parameterName) throws ServletException {
            String ct = request.getContentType();
            if (ct == null || !ct.startsWith("application/json")) {
                throw new ServletException("Expected application/json but got " + ct);
            }
            try {
                JSONObject o = JSONObject.fromObject((Object)IOUtils.toString((Reader)request.getReader()));
                return JSONObject.toBean((JSONObject)o, (Class)type);
            }
            catch (IOException e) {
                throw new ServletException("Failed to read JSON", (Throwable)e);
            }
        }
    }
}

