/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Util;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class Revision
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7203898556389073882L;
    ObjectId sha1;
    Collection<Branch> branches;

    public Revision(ObjectId sha1) {
        this.sha1 = sha1 == null ? null : sha1.toObjectId();
        this.branches = new ArrayList<Branch>();
    }

    public Revision(ObjectId sha1, Collection<Branch> branches) {
        this.sha1 = sha1 == null ? null : sha1.toObjectId();
        this.branches = branches;
    }

    public ObjectId getSha1() {
        return this.sha1 == null ? null : this.sha1.toObjectId();
    }

    @Exported(name="SHA1")
    public String getSha1String() {
        return this.sha1 == null ? "" : this.sha1.name();
    }

    public void setSha1(ObjectId sha1) {
        this.sha1 = sha1 == null ? null : sha1.toObjectId();
    }

    @Exported(name="branch")
    public Collection<Branch> getBranches() {
        return this.branches;
    }

    public void setBranches(Collection<Branch> branches) {
        this.branches = branches;
    }

    public boolean containsBranchName(String name) {
        return this.branches.stream().anyMatch(branch -> branch.getName().equals(name));
    }

    public String toString() {
        String revisionName = this.sha1 != null ? this.sha1.name() : "null";
        StringBuilder s = new StringBuilder("Revision " + revisionName + " (");
        if (this.branches != null) {
            s.append(this.branches.stream().map(GitObject::getName).map(Util::fixNull).collect(Collectors.joining(", ")));
        }
        s.append(')');
        return s.toString();
    }

    public Revision clone() {
        try {
            Revision clone = (Revision)super.clone();
            clone.branches = new ArrayList<Branch>(this.branches);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning Revision", e);
        }
    }

    public int hashCode() {
        return this.sha1 != null ? 31 + this.sha1.hashCode() : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)obj;
        if (other.sha1 != null) {
            return other.sha1.equals((AnyObjectId)this.sha1);
        }
        return this.sha1 == null;
    }
}

