/*
 * Decompiled with CFR 0.152.
 */
package hudson.scheduler;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scheduler.CronTab;
import hudson.scheduler.Hash;
import hudson.scheduler.Messages;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class CronTabList {
    private final Vector<CronTab> tabs;
    private static final Logger LOGGER = Logger.getLogger(CronTabList.class.getName());

    public CronTabList(Collection<CronTab> tabs) {
        this.tabs = new Vector<CronTab>(tabs);
    }

    public synchronized boolean check(Calendar cal) {
        for (CronTab tab : this.tabs) {
            if (!tab.check(cal)) continue;
            return true;
        }
        return false;
    }

    public String checkSanity() {
        for (CronTab tab : this.tabs) {
            String s = tab.checkSanity();
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @CheckForNull
    public static String getValidTimezone(String timezone) {
        String[] validIDs;
        for (String str : validIDs = TimeZone.getAvailableIDs()) {
            if (str == null || !str.equals(timezone)) continue;
            return timezone;
        }
        return null;
    }

    public static CronTabList create(@NonNull String format) {
        return CronTabList.create(format, null);
    }

    public static CronTabList create(@NonNull String format, Hash hash) {
        Vector<CronTab> r = new Vector<CronTab>();
        int lineNumber = 0;
        String timezone = null;
        for (String line : format.split("\\r?\\n")) {
            line = line.trim();
            if (++lineNumber == 1 && line.startsWith("TZ=")) {
                String timezoneString = line.replace("TZ=", "");
                timezone = CronTabList.getValidTimezone(timezoneString);
                if (timezone != null) {
                    LOGGER.log(Level.CONFIG, "CRON with timezone {0}", timezone);
                    continue;
                }
                throw new ANTLRException("Invalid or unsupported timezone '" + timezoneString + "'");
            }
            if (line.isEmpty() || line.startsWith("#")) continue;
            try {
                r.add(new CronTab(line, lineNumber, hash, timezone));
            }
            catch (IllegalArgumentException e) {
                throw new ANTLRException(Messages.CronTabList_InvalidInput(line, e.getMessage()), e);
            }
        }
        return new CronTabList(r);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Calendar previous() {
        Calendar nearest = null;
        Iterator<CronTab> iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            CronTab tab;
            Calendar scheduled = tab.floor((tab = iterator.next()).getTimeZone() == null ? Calendar.getInstance() : Calendar.getInstance(tab.getTimeZone()));
            if (nearest != null && !nearest.before(scheduled)) continue;
            nearest = scheduled;
        }
        return nearest;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Calendar next() {
        Calendar nearest = null;
        Iterator<CronTab> iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            CronTab tab;
            Calendar scheduled = tab.ceil((tab = iterator.next()).getTimeZone() == null ? Calendar.getInstance() : Calendar.getInstance(tab.getTimeZone()));
            if (nearest != null && !nearest.after(scheduled)) continue;
            nearest = scheduled;
        }
        return nearest;
    }
}

