/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import io.jenkins.servlet.ServletExceptionWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.ReflectionUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class AnnotationHandler<T extends Annotation> {
    private static final ClassValue<AnnotationHandler> HANDLERS = new ClassValue<AnnotationHandler>(){

        @Override
        protected AnnotationHandler computeValue(Class<?> at) {
            InjectedParameter ip = at.getAnnotation(InjectedParameter.class);
            if (ip != null) {
                try {
                    return ip.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to instantiate parameter injector for " + String.valueOf(at), e);
                }
            }
            return NOT_HANDLER;
        }
    };
    private static final AnnotationHandler NOT_HANDLER = new AnnotationHandler(){

        public Object parse(StaplerRequest2 request, Annotation a, Class type, String parameterName) throws jakarta.servlet.ServletException {
            return null;
        }
    };

    public Object parse(StaplerRequest2 request, T a, Class type, String parameterName) throws jakarta.servlet.ServletException {
        if (ReflectionUtils.isOverridden(AnnotationHandler.class, this.getClass(), "parse", StaplerRequest.class, Annotation.class, Class.class, String.class)) {
            try {
                return this.parse(StaplerRequest.fromStaplerRequest2(request), a, type, parameterName);
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException(e);
            }
        }
        throw new AbstractMethodError("The class " + this.getClass().getName() + " must override at least one of the " + AnnotationHandler.class.getSimpleName() + ".parse methods");
    }

    @Deprecated
    public Object parse(StaplerRequest request, T a, Class type, String parameterName) throws ServletException {
        if (ReflectionUtils.isOverridden(AnnotationHandler.class, this.getClass(), "parse", StaplerRequest2.class, Annotation.class, Class.class, String.class)) {
            try {
                return this.parse(StaplerRequest.toStaplerRequest2(request), a, type, parameterName);
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException(e);
            }
        }
        throw new AbstractMethodError("The class " + this.getClass().getName() + " must override at least one of the " + AnnotationHandler.class.getSimpleName() + ".parse methods");
    }

    protected final Object convert(Class targetType, String value) {
        Converter converter = Stapler.lookupConverter(targetType);
        if (converter == null) {
            throw new IllegalArgumentException("Unable to convert to " + String.valueOf(targetType));
        }
        return converter.convert(targetType, (Object)value);
    }

    static Object handle(StaplerRequest2 request, Annotation[] annotations, String parameterName, Class targetType) throws jakarta.servlet.ServletException {
        for (Annotation a : annotations) {
            Class<? extends Annotation> at = a.annotationType();
            AnnotationHandler h = HANDLERS.get(at);
            if (h == NOT_HANDLER) continue;
            return h.parse(request, a, targetType, parameterName);
        }
        return null;
    }
}

