/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorException;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

public class JSchConnector {
    private final JSch jsch;
    private final String host;
    private final int port;
    private Session session = null;
    private final String username;

    public JSchConnector(String username, String host, int port) {
        this(new JSch(), username, host, port);
    }

    public JSchConnector(JSch jsch, String username, String host, int port) {
        this.host = host;
        this.jsch = jsch;
        this.port = port;
        this.username = username;
    }

    public JSch getJSch() {
        return this.jsch;
    }

    public synchronized boolean hasSession() {
        return this.session != null;
    }

    public synchronized Session getSession() {
        if (!this.hasSession()) {
            try {
                this.session = this.jsch.getSession(this.username, this.host, this.port);
            }
            catch (JSchException e) {
                throw new SSHAuthenticatorException(e);
            }
        }
        return this.session;
    }

    public synchronized void close() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }
}

