/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import hudson.util.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jenkins.security.ConfidentialKey;
import jenkins.security.ConfidentialStore;

public class CredentialsConfidentialKey
extends ConfidentialKey {
    private volatile SecretKey secret;
    private static final int SPICE_SIZE = 16;
    private static final String DIGEST_ALG = "SHA-256";
    private static final String KEY_ALG = "AES";
    private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";

    public CredentialsConfidentialKey(String id) {
        super(id);
    }

    public CredentialsConfidentialKey(Class owner, String shortName) {
        this(owner.getName() + '.' + shortName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getKey() {
        try {
            if (this.secret == null) {
                CredentialsConfidentialKey credentialsConfidentialKey = this;
                synchronized (credentialsConfidentialKey) {
                    if (this.secret == null) {
                        byte[] payload = this.load();
                        if (payload == null) {
                            payload = ConfidentialStore.get().randomBytes(256);
                            this.store(payload);
                        }
                        this.secret = new SecretKeySpec(payload, 0, 16, KEY_ALG);
                    }
                }
            }
            return this.secret;
        }
        catch (IOException e) {
            throw new Error("Failed to load the key: " + this.getId(), e);
        }
    }

    public Cipher encrypt(byte[] salt) {
        try {
            return this.createCipher(this.getKey().getEncoded(), salt, 1);
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Cipher decrypt(byte[] salt) {
        try {
            return this.createCipher(this.getKey().getEncoded(), salt, 2);
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Cipher createCipher(byte[] pwdAsBytes, byte[] salt, int mode) throws GeneralSecurityException {
        MessageDigest _digester = MessageDigest.getInstance(DIGEST_ALG);
        _digester.reset();
        byte[] keyAndIv = new byte[32];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            _digester.update(pwdAsBytes);
            if (salt != null) {
                _digester.update(salt, 0, 8);
            }
            if ((result = _digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            _digester.reset();
            _digester.update(result);
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        Cipher cipher = Secret.getCipher((String)CIPHER_ALG);
        cipher.init(mode, (Key)new SecretKeySpec(key, KEY_ALG), new IvParameterSpec(iv));
        return cipher;
    }
}

