/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class CredentialsNameComparator
implements Comparator<Credentials>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Locale locale;
    private final boolean ignoreCase;
    private transient Collator collator;

    public CredentialsNameComparator() {
        this(null, true);
    }

    public CredentialsNameComparator(@CheckForNull Locale locale) {
        this(locale, true);
    }

    public CredentialsNameComparator(@CheckForNull Locale locale, boolean ignoreCase) {
        if (locale == null) {
            StaplerRequest req = Stapler.getCurrentRequest();
            if (req != null) {
                locale = req.getLocale();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
        }
        this.locale = locale;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public int compare(Credentials c1, Credentials c2) {
        String n1 = StringUtils.defaultString((String)CredentialsNameProvider.name(c1));
        String n2 = StringUtils.defaultString((String)CredentialsNameProvider.name(c2));
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.locale);
        }
        return this.ignoreCase ? this.collator.compare(n1.toLowerCase(this.locale), n2.toLowerCase(this.locale)) : this.collator.compare(n1, n2);
    }

    public int hashCode() {
        int result = this.locale.hashCode();
        result = 31 * result + (this.ignoreCase ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialsNameComparator that = (CredentialsNameComparator)o;
        if (this.ignoreCase != that.ignoreCase) {
            return false;
        }
        return this.locale.equals(that.locale);
    }

    public String toString() {
        return "CredentialsNameComparator{locale=" + this.locale + ", ignoreCase=" + this.ignoreCase + '}';
    }
}

