/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.MethodHandleFactory;
import org.kohsuke.stapler.PreInvokeInterceptedFunction;
import org.kohsuke.stapler.ReflectionUtils;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.SelectionInterceptedFunction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;

public abstract class Function {
    private static final Logger LOGGER = Logger.getLogger(Function.class.getName());
    private static final ClassValue<Function> PARSE_METHODS;
    private static final Function RETURN_NULL;

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract String getSignature();

    public abstract String getQualifiedName();

    public abstract Class[] getParameterTypes();

    public abstract Type[] getGenericParameterTypes();

    public abstract Annotation[][] getParameterAnnotations();

    public abstract String[] getParameterNames();

    public abstract Class getReturnType();

    public abstract Class[] getCheckedExceptionTypes();

    public abstract Class getDeclaringClass();

    public abstract boolean isStatic();

    public Function contextualize(Object usage) {
        return this;
    }

    boolean bindAndInvokeAndServeResponse(Object node, RequestImpl req, ResponseImpl rsp, Object ... headArgs) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
        try {
            Object r = this.bindAndInvoke(node, req, rsp, headArgs);
            if (this.getReturnType() != Void.TYPE) {
                Function.renderResponse(req, rsp, node, r);
            }
            return true;
        }
        catch (CancelRequestHandlingException unused) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof CancelRequestHandlingException) {
                return false;
            }
            if (Function.renderResponse(req, rsp, node, te)) {
                return true;
            }
            throw e;
        }
    }

    static boolean renderResponse(RequestImpl req, ResponseImpl rsp, Object node, Object ret) throws IOException, ServletException {
        for (HttpResponseRenderer r : req.stapler.getWebApp().getResponseRenderers()) {
            if (!r.generateResponse(req, rsp, node, ret)) continue;
            return true;
        }
        return false;
    }

    Object bindAndInvoke(Object o, StaplerRequest req, StaplerResponse rsp, Object ... headArgs) throws IllegalAccessException, InvocationTargetException, ServletException {
        Class[] types = this.getParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotations();
        String[] parameterNames = this.getParameterNames();
        Object[] arguments = new Object[types.length];
        System.arraycopy(headArgs, 0, arguments, 0, headArgs.length);
        try {
            for (int i = headArgs.length; i < types.length; ++i) {
                Function binder;
                Class t = types[i];
                arguments[i] = t == StaplerRequest.class || t == HttpServletRequest.class ? req : (t == StaplerResponse.class || t == HttpServletResponse.class ? rsp : ((binder = PARSE_METHODS.get(t)) != RETURN_NULL ? binder.bindAndInvoke(null, req, rsp, new Object[0]) : AnnotationHandler.handle(req, annotations[i], i < parameterNames.length ? parameterNames[i] : null, t)));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to invoke " + this.getDisplayName(), e);
        }
        return this.invoke(req, rsp, o, arguments);
    }

    public static Object returnNull() {
        return null;
    }

    public abstract Object invoke(StaplerRequest var1, StaplerResponse var2, Object var3, Object ... var4) throws IllegalAccessException, InvocationTargetException, ServletException;

    final Function wrapByInterceptors(AnnotatedElement m) {
        try {
            Function f = this;
            for (Annotation a : m.getAnnotations()) {
                InterceptorAnnotation ia = a.annotationType().getAnnotation(InterceptorAnnotation.class);
                if (ia == null) continue;
                try {
                    Interceptor i = ia.value().newInstance();
                    switch (ia.stage()) {
                        case SELECTION: {
                            f = new SelectionInterceptedFunction(f, i);
                            break;
                        }
                        case PREINVOKE: {
                            f = new PreInvokeInterceptedFunction(f, i);
                        }
                    }
                }
                catch (InstantiationException e) {
                    throw (Error)new InstantiationError("Failed to instantiate interceptor for " + f.getDisplayName()).initCause(e);
                }
                catch (IllegalAccessException e) {
                    throw (Error)new IllegalAccessError("Failed to instantiate interceptor for " + f.getDisplayName()).initCause(e);
                }
            }
            return f;
        }
        catch (LinkageError e) {
            return this;
        }
    }

    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    public abstract Annotation[] getAnnotations();

    static {
        try {
            RETURN_NULL = new StaticFunction(Function.class.getMethod("returnNull", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        PARSE_METHODS = new ClassValue<Function>(){

            @Override
            public Function computeValue(Class<?> from) {
                FunctionList methods = new ClassDescriptor(from, (Class[])new Class[0]).methods.name("fromStapler");
                switch (methods.size()) {
                    case 0: {
                        return RETURN_NULL;
                    }
                    default: {
                        throw new IllegalArgumentException("Too many 'fromStapler' methods on " + from);
                    }
                    case 1: 
                }
                Method m = ((MethodFunction)methods.get((int)0)).m;
                return new MethodFunction(m){

                    @Override
                    public Class[] getParameterTypes() {
                        return this.m.getParameterTypes();
                    }

                    @Override
                    public Type[] getGenericParameterTypes() {
                        return this.m.getGenericParameterTypes();
                    }

                    @Override
                    public Annotation[][] getParameterAnnotations() {
                        return this.m.getParameterAnnotations();
                    }

                    @Override
                    public Object invoke(StaplerRequest req, StaplerResponse rsp, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
                        return this.m.invoke(null, args);
                    }
                };
            }
        };
    }

    static final class StaticFunction
    extends MethodFunction {
        public StaticFunction(Method m) {
            super(m);
        }

        @Override
        public Class[] getParameterTypes() {
            Class<?>[] p = this.m.getParameterTypes();
            Class[] r = new Class[p.length - 1];
            System.arraycopy(p, 1, r, 0, r.length);
            return r;
        }

        @Override
        public Type[] getGenericParameterTypes() {
            Type[] p = this.m.getGenericParameterTypes();
            Type[] r = new Type[p.length - 1];
            System.arraycopy(p, 1, r, 0, r.length);
            return r;
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            Annotation[][] a = this.m.getParameterAnnotations();
            Annotation[][] r = new Annotation[a.length - 1][];
            System.arraycopy(a, 1, r, 0, r.length);
            return r;
        }
    }

    static final class OverridingInstanceFunction
    extends InstanceFunction {
        private final List<Method> methods;

        public OverridingInstanceFunction(List<Method> m) {
            super(m.get(0));
            this.methods = m;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotation) {
            for (Method m : this.methods) {
                A a = m.getAnnotation(annotation);
                if (a == null) continue;
                return a;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            Annotation[] x = new Annotation[]{};
            for (Method m : this.methods) {
                x = ReflectionUtils.union(x, m.getAnnotations());
            }
            return x;
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            Annotation[][] all = null;
            for (Method m : this.methods) {
                Annotation[][] next = m.getParameterAnnotations();
                if (all == null) {
                    all = next;
                    continue;
                }
                for (int i = 0; i < next.length; ++i) {
                    all[i] = ReflectionUtils.union(all[i], next[i]);
                }
            }
            return all;
        }
    }

    public static class InstanceFunction
    extends MethodFunction {
        public InstanceFunction(Method m) {
            super(m);
        }

        @Override
        public Class[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.m.getGenericParameterTypes();
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.m.getParameterAnnotations();
        }
    }

    private static abstract class MethodFunction
    extends Function {
        protected final Method m;
        private volatile MethodHandle handle;
        private volatile String[] names;

        public MethodFunction(Method m) {
            this.m = m;
        }

        @Override
        public final String getName() {
            return this.m.getName();
        }

        @Override
        public final String getDisplayName() {
            return this.m.toGenericString();
        }

        @Override
        public String getSignature() {
            String prefix = this.isStatic() ? "staticMethod" : "method";
            String value = StringUtils.join(Arrays.asList(prefix, this.m.getDeclaringClass().getName(), this.getName()), (char)' ');
            if (this.getParameterTypes().length > 0) {
                value = value + " " + StringUtils.join((Collection)Arrays.stream(this.getParameterTypes()).map(Class::getName).collect(Collectors.toList()), (char)' ');
            }
            return value;
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this.m.getModifiers());
        }

        @Override
        public String getQualifiedName() {
            return this.m.getDeclaringClass().getName() + '.' + this.getName();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotation) {
            return this.m.getAnnotation(annotation);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.m.getAnnotations();
        }

        @Override
        public final String[] getParameterNames() {
            if (this.names == null) {
                this.names = ClassDescriptor.loadParameterNames(this.m);
            }
            return this.names;
        }

        @Override
        public Class getReturnType() {
            return this.m.getReturnType();
        }

        @Override
        public Class[] getCheckedExceptionTypes() {
            return this.m.getExceptionTypes();
        }

        @Override
        public Class getDeclaringClass() {
            return this.m.getDeclaringClass();
        }

        protected MethodHandle handle() {
            if (this.handle == null) {
                this.handle = MethodHandleFactory.get(this.m);
            }
            return this.handle;
        }

        @Override
        public Object invoke(StaplerRequest req, StaplerResponse rsp, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            Object[] arguments;
            if (Modifier.isStatic(this.m.getModifiers())) {
                arguments = args;
            } else {
                arguments = new Object[args.length + 1];
                arguments[0] = o;
                System.arraycopy(args, 0, arguments, 1, args.length);
            }
            try {
                return this.handle().invokeWithArguments(arguments);
            }
            catch (WrongMethodTypeException x) {
                LOGGER.log(Level.WARNING, this.handle + " failed on " + o + "." + this.m + Arrays.toString(arguments), x);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
            return this.m.invoke(o, args);
        }
    }
}

