/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.TearOffSupport;

public class MetaClassLoader
extends TearOffSupport {
    public final MetaClassLoader parent;
    public final ClassLoader loader;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"}, justification="Legacy switch.")
    public static MetaClassLoader debugLoader = null;
    private static final Map<ClassLoader, MetaClassLoader> classMap = new HashMap<ClassLoader, MetaClassLoader>();

    public MetaClassLoader(ClassLoader loader) {
        this.loader = loader;
        this.parent = MetaClassLoader.get(loader.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaClassLoader get(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        Map<ClassLoader, MetaClassLoader> map = classMap;
        synchronized (map) {
            MetaClassLoader mc = classMap.get(cl);
            if (mc == null) {
                mc = new MetaClassLoader(cl);
                classMap.put(cl, mc);
            }
            return mc;
        }
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Not used with an installed security manager.")
    private static MetaClassLoader createDebugLoader() {
        try {
            String path = System.getProperty("stapler.resourcePath");
            if (path != null) {
                String[] tokens = path.split(";");
                URL[] urls = new URL[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    urls[i] = new File(tokens[i]).toURI().toURL();
                }
                return new MetaClassLoader(new URLClassLoader(urls));
            }
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        return null;
    }

    static {
        debugLoader = MetaClassLoader.createDebugLoader();
    }
}

