/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import org.kohsuke.stapler.AbstractTearOff;
import org.kohsuke.stapler.BindInterceptor;
import org.kohsuke.stapler.CrumbIssuer;
import org.kohsuke.stapler.DispatchValidator;
import org.kohsuke.stapler.DispatchersFilter;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.JsonInErrorMessageSanitizer;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.bind.BoundObjectTable;
import org.kohsuke.stapler.event.FilteredDispatchTriggerListener;
import org.kohsuke.stapler.event.FilteredDoActionTriggerListener;
import org.kohsuke.stapler.event.FilteredFieldTriggerListener;
import org.kohsuke.stapler.event.FilteredGetterTriggerListener;
import org.kohsuke.stapler.lang.FieldRef;
import org.kohsuke.stapler.lang.KInstance;
import org.kohsuke.stapler.lang.Klass;

public class WebApp {
    public final ServletContext context;
    public final Map<Class, Class[]> wrappers = new HashMap<Class, Class[]>();
    public final Map<String, String> defaultEncodingForStaticResources = new HashMap<String, String>();
    public final List<Facet> facets = new Vector<Facet>();
    public final List<BindInterceptor> bindInterceptors = new CopyOnWriteArrayList<BindInterceptor>();
    public final Map<String, String> mimeTypes = new Hashtable<String, String>();
    private volatile ClassLoader classLoader;
    private final Map<Klass<?>, MetaClass> classMap = new HashMap();
    public final BoundObjectTable boundObjectTable = new BoundObjectTable();
    private final CopyOnWriteArrayList<HttpResponseRenderer> responseRenderers = new CopyOnWriteArrayList();
    private CrumbIssuer crumbIssuer = CrumbIssuer.DEFAULT;
    private final ConcurrentMap<String, Stapler> servlets = new ConcurrentHashMap<String, Stapler>();
    private FunctionList.Filter filterForGetMethods = FunctionList.Filter.ALWAYS_OK;
    private FunctionList.Filter filterForDoActions = FunctionList.Filter.ALWAYS_OK;
    private FieldRef.Filter filterForFields = FieldRef.Filter.ALWAYS_OK;
    private DispatchersFilter dispatchersFilter;
    private FilteredDoActionTriggerListener filteredDoActionTriggerListener = FilteredDoActionTriggerListener.JUST_WARN;
    private FilteredGetterTriggerListener filteredGetterTriggerListener = FilteredGetterTriggerListener.JUST_WARN;
    private FilteredFieldTriggerListener filteredFieldTriggerListener = FilteredFieldTriggerListener.JUST_WARN;
    private DispatchValidator dispatchValidator = DispatchValidator.DEFAULT;
    private FilteredDispatchTriggerListener filteredDispatchTriggerListener = FilteredDispatchTriggerListener.JUST_WARN;
    private JsonInErrorMessageSanitizer jsonInErrorMessageSanitizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebApp get(ServletContext context) {
        Object o = context.getAttribute(WebApp.class.getName());
        if (o != null) return (WebApp)o;
        Class<WebApp> clazz = WebApp.class;
        synchronized (WebApp.class) {
            o = context.getAttribute(WebApp.class.getName());
            if (o != null) return (WebApp)o;
            o = new WebApp(context);
            context.setAttribute(WebApp.class.getName(), o);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (WebApp)o;
        }
    }

    public WebApp(ServletContext context) {
        this.context = context;
        this.facets.addAll(Facet.discoverExtensions(Facet.class, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader()));
        this.responseRenderers.add(new HttpResponseRenderer.Default());
    }

    public Object getApp() {
        return this.context.getAttribute("app");
    }

    public void setApp(Object app) {
        this.context.setAttribute("app", app);
    }

    public CrumbIssuer getCrumbIssuer() {
        return this.crumbIssuer;
    }

    public void setCrumbIssuer(CrumbIssuer crumbIssuer) {
        this.crumbIssuer = crumbIssuer;
    }

    public CopyOnWriteArrayList<HttpResponseRenderer> getResponseRenderers() {
        return this.responseRenderers;
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = this.classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = Stapler.class.getClassLoader();
        }
        return cl;
    }

    public <T extends Facet> T getFacet(Class<T> type) {
        for (Facet f : this.facets) {
            if (type != f.getClass()) continue;
            return (T)((Facet)type.cast(f));
        }
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public MetaClass getMetaClass(Class c) {
        return this.getMetaClass(Klass.java(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Klass<?> c) {
        if (c == null) {
            return null;
        }
        Map<Klass<?>, MetaClass> map = this.classMap;
        synchronized (map) {
            MetaClass mc = this.classMap.get(c);
            if (mc == null) {
                mc = new MetaClass(this, c);
                this.classMap.put(c, mc);
            }
            return mc;
        }
    }

    public MetaClass getMetaClass(Object o) {
        return this.getMetaClass(this.getKlass(o));
    }

    public Klass<?> getKlass(Object o) {
        KInstance ki;
        Klass k;
        if (o instanceof KInstance && (k = (ki = (KInstance)o).getKlass()) != null) {
            return k;
        }
        for (Facet f : this.facets) {
            Klass<?> k2 = f.getKlass(o);
            if (k2 == null) continue;
            return k2;
        }
        return Klass.java(o.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScripts(Class<? extends AbstractTearOff> clazz) {
        Map<Klass<?>, MetaClass> map = this.classMap;
        synchronized (map) {
            for (MetaClass v : this.classMap.values()) {
                AbstractTearOff t = v.getTearOff(clazz);
                if (t == null) continue;
                t.clearScripts();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMetaClassCache() {
        Map<Klass<?>, MetaClass> map = this.classMap;
        synchronized (map) {
            this.classMap.clear();
        }
    }

    void addStaplerServlet(String servletName, Stapler servlet) {
        if (servletName == null) {
            servletName = "";
        }
        this.servlets.put(servletName, servlet);
    }

    public Stapler getSomeStapler() {
        return (Stapler)((Object)this.servlets.values().iterator().next());
    }

    public static WebApp getCurrent() {
        return Stapler.getCurrent().getWebApp();
    }

    public FunctionList.Filter getFilterForGetMethods() {
        return this.filterForGetMethods;
    }

    public void setFilterForGetMethods(FunctionList.Filter filterForGetMethods) {
        this.filterForGetMethods = filterForGetMethods;
    }

    public FunctionList.Filter getFilterForDoActions() {
        return this.filterForDoActions;
    }

    public void setFilterForDoActions(FunctionList.Filter filterForDoActions) {
        this.filterForDoActions = filterForDoActions;
    }

    public FieldRef.Filter getFilterForFields() {
        return this.filterForFields;
    }

    public void setFilterForFields(FieldRef.Filter filterForFields) {
        this.filterForFields = filterForFields;
    }

    public DispatchersFilter getDispatchersFilter() {
        return this.dispatchersFilter;
    }

    public void setDispatchersFilter(DispatchersFilter dispatchersFilter) {
        this.dispatchersFilter = dispatchersFilter;
    }

    public FilteredDoActionTriggerListener getFilteredDoActionTriggerListener() {
        return this.filteredDoActionTriggerListener;
    }

    public void setFilteredDoActionTriggerListener(FilteredDoActionTriggerListener filteredDoActionTriggerListener) {
        this.filteredDoActionTriggerListener = filteredDoActionTriggerListener == null ? FilteredDoActionTriggerListener.JUST_WARN : filteredDoActionTriggerListener;
    }

    public FilteredGetterTriggerListener getFilteredGetterTriggerListener() {
        return this.filteredGetterTriggerListener;
    }

    public void setFilteredGetterTriggerListener(FilteredGetterTriggerListener filteredGetterTriggerListener) {
        this.filteredGetterTriggerListener = filteredGetterTriggerListener == null ? FilteredGetterTriggerListener.JUST_WARN : filteredGetterTriggerListener;
    }

    public FilteredFieldTriggerListener getFilteredFieldTriggerListener() {
        return this.filteredFieldTriggerListener;
    }

    public void setFilteredFieldTriggerListener(FilteredFieldTriggerListener filteredFieldTriggerListener) {
        this.filteredFieldTriggerListener = filteredFieldTriggerListener == null ? FilteredFieldTriggerListener.JUST_WARN : filteredFieldTriggerListener;
    }

    public JsonInErrorMessageSanitizer getJsonInErrorMessageSanitizer() {
        if (this.jsonInErrorMessageSanitizer == null) {
            return JsonInErrorMessageSanitizer.NOOP;
        }
        return this.jsonInErrorMessageSanitizer;
    }

    public void setJsonInErrorMessageSanitizer(JsonInErrorMessageSanitizer jsonInErrorMessageSanitizer) {
        this.jsonInErrorMessageSanitizer = jsonInErrorMessageSanitizer;
    }

    public DispatchValidator getDispatchValidator() {
        if (this.dispatchValidator == null) {
            this.dispatchValidator = DispatchValidator.DEFAULT;
        }
        return this.dispatchValidator;
    }

    public void setDispatchValidator(DispatchValidator dispatchValidator) {
        this.dispatchValidator = dispatchValidator;
    }

    public FilteredDispatchTriggerListener getFilteredDispatchTriggerListener() {
        if (this.filteredDispatchTriggerListener == null) {
            this.filteredDispatchTriggerListener = FilteredDispatchTriggerListener.JUST_WARN;
        }
        return this.filteredDispatchTriggerListener;
    }

    public void setFilteredDispatchTriggerListener(FilteredDispatchTriggerListener filteredDispatchTriggerListener) {
        this.filteredDispatchTriggerListener = filteredDispatchTriggerListener;
    }
}

