/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.config;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.beanutils.ConvertUtils;
import org.kohsuke.stapler.config.Configuration;

public class ConfigurationLoader {
    private final Function<String, String> source;
    private static final String[] GETTER_PREFIX = new String[]{"get", "has", "is"};

    private ConfigurationLoader(Function<String, String> source) {
        this.source = source;
    }

    private static Properties load(File f) throws IOException {
        Properties config = new Properties();
        try (InputStream in = Files.newInputStream(f.toPath(), StandardOpenOption.READ);){
            config.load(in);
            Properties properties = config;
            return properties;
        }
    }

    public static ConfigurationLoader from(File configPropertyFile) throws IOException {
        return ConfigurationLoader.from(ConfigurationLoader.load(configPropertyFile));
    }

    public static ConfigurationLoader from(Properties props) throws IOException {
        return new ConfigurationLoader(props::getProperty);
    }

    public static ConfigurationLoader from(Map<String, String> props) throws IOException {
        return new ConfigurationLoader(props::get);
    }

    public static ConfigurationLoader fromSystemProperties() throws IOException {
        return ConfigurationLoader.from(System.getProperties());
    }

    public static ConfigurationLoader fromEnvironmentVariables() throws IOException {
        TreeMap<String, String> m = new TreeMap<String, String>(String::compareToIgnoreCase);
        m.putAll(System.getenv());
        return ConfigurationLoader.from(m);
    }

    public <T> T as(Class<T> type) {
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                Configuration cn = method.getAnnotation(Configuration.class);
                Class<?> r = method.getReturnType();
                String key = this.getKey(method, cn);
                String v = (String)ConfigurationLoader.this.source.apply(key);
                if (v == null && cn != null && !cn.defaultValue().equals("\u0000")) {
                    v = cn.defaultValue();
                }
                if (v == null) {
                    return null;
                }
                return ConvertUtils.convert((String)v, r);
            }

            private String getKey(Method method, Configuration c) {
                if (c != null && !c.name().equals("\u0000")) {
                    return c.name();
                }
                String n = method.getName();
                for (String p : GETTER_PREFIX) {
                    if (!n.startsWith(p)) continue;
                    return Introspector.decapitalize(n.substring(p.length()));
                }
                return n;
            }
        }));
    }
}

