/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.lang.AnnotatedRef;
import org.kohsuke.stapler.util.IllegalReflectiveAccessLogHandler;

public abstract class FieldRef
extends AnnotatedRef {
    private static final Logger LOGGER = Logger.getLogger(FieldRef.class.getName());

    public abstract String getName();

    public abstract boolean isStatic();

    public abstract Object get(Object var1) throws IllegalAccessException;

    public abstract String getQualifiedName();

    public abstract String getSignature();

    public abstract Class<?> getReturnType();

    public boolean isRoutable() {
        return true;
    }

    public static FieldRef wrap(final Field f) {
        return new FieldRef(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> type) {
                return f.getAnnotation(type);
            }

            @Override
            public String getName() {
                return f.getName();
            }

            @Override
            public Object get(Object instance) throws IllegalAccessException {
                try {
                    return f.get(instance);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warning(IllegalReflectiveAccessLogHandler.get(e));
                    f.setAccessible(true);
                    return f.get(instance);
                }
            }

            @Override
            public boolean isStatic() {
                return Modifier.isStatic(f.getModifiers());
            }

            @Override
            public Class<?> getReturnType() {
                return f.getType();
            }

            @Override
            public String getSignature() {
                String prefix = this.isStatic() ? "staticField" : "field";
                return StringUtils.join(Arrays.asList(prefix, f.getDeclaringClass().getName(), this.getName()), (char)' ');
            }

            @Override
            public String getQualifiedName() {
                return f.getDeclaringClass().getName() + "." + this.getName();
            }

            @Override
            public boolean isRoutable() {
                return Modifier.isPublic(f.getModifiers());
            }
        };
    }

    public static interface Filter {
        public static final Filter ALWAYS_OK = new Filter(){

            @Override
            public boolean keep(FieldRef m) {
                return true;
            }
        };

        public boolean keep(FieldRef var1);
    }
}

