/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.Timer;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

final class DelayBufferedOutputStream
extends BufferedOutputStream {
    private static final Logger LOGGER = Logger.getLogger(DelayBufferedOutputStream.class.getName());
    private final Tuning tuning;
    private long recurrencePeriod;

    DelayBufferedOutputStream(OutputStream out) {
        this(out, Tuning.DEFAULT);
    }

    DelayBufferedOutputStream(OutputStream out, Tuning tuning) {
        super(new FlushControlledOutputStream(out), tuning.bufferSize);
        this.tuning = tuning;
        this.recurrencePeriod = tuning.minRecurrencePeriod;
        this.reschedule();
    }

    private void reschedule() {
        Timer.get().schedule(new Flush(this), this.recurrencePeriod, TimeUnit.MILLISECONDS);
        this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * this.tuning.recurrencePeriodBackoff), this.tuning.maxRecurrencePeriod);
    }

    private void flushBuffer() throws IOException {
        ThreadLocal enableFlush = ((FlushControlledOutputStream)this.out).enableFlush;
        enableFlush.set(false);
        this.flush();
    }

    void flushAndReschedule() {
        try {
            this.flushBuffer();
        }
        catch (IOException x) {
            LOGGER.log(Level.FINE, null, x);
        }
        this.reschedule();
    }

    public String toString() {
        return "DelayBufferedOutputStream[" + this.out + "]";
    }

    private static final class FlushControlledOutputStream
    extends FilterOutputStream {
        private final ThreadLocal<Boolean> enableFlush = ThreadLocal.withInitial(() -> true);

        FlushControlledOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            try {
                if (this.enableFlush.get().booleanValue()) {
                    super.flush();
                }
            }
            finally {
                this.enableFlush.remove();
            }
        }

        public String toString() {
            return "FlushControlledOutputStream[" + this.out + "]";
        }
    }

    private static final class Flush
    implements Runnable {
        private final Reference<DelayBufferedOutputStream> osr;

        Flush(DelayBufferedOutputStream os) {
            this.osr = new WeakReference<DelayBufferedOutputStream>(os);
        }

        @Override
        public void run() {
            DelayBufferedOutputStream os = this.osr.get();
            if (os != null) {
                os.flushAndReschedule();
            }
        }
    }

    static final class Tuning
    implements SerializableOnlyOverRemoting {
        long minRecurrencePeriod = Long.getLong(DelayBufferedOutputStream.class.getName() + ".minRecurrencePeriod", 1000L);
        long maxRecurrencePeriod = Long.getLong(DelayBufferedOutputStream.class.getName() + ".maxRecurrencePeriod", 10000L);
        float recurrencePeriodBackoff = Float.parseFloat(System.getProperty(DelayBufferedOutputStream.class.getName() + ".recurrencePeriodBackoff", "1.05"));
        int bufferSize = Integer.getInteger(DelayBufferedOutputStream.class.getName() + ".bufferSize", 65536);
        static final Tuning DEFAULT = new Tuning();

        private Tuning() {
        }
    }
}

