/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.AncestorImpl;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.EvaluationTrace;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.LocaleDrivenResourceProvider;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RawHtmlArgument;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.TokenList;
import org.kohsuke.stapler.TruncatedInputStream;
import org.kohsuke.stapler.WebApp;

public class Stapler
extends HttpServlet {
    private static final Set<String> EXCEPTIONS_DO_NOT_PRINT_STACKTRACE = Set.of("org.acegisecurity.AccessDeniedException", "org.springframework.security.access.AccessDeniedException");
    private ServletContext context;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="The Stapler class is not expected to be serialized.")
    private WebApp webApp;
    private volatile Map<String, URL> resourcePaths;
    private boolean diagnosticThreadName = true;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="The Stapler class is not expected to be serialized.")
    private final LocaleDrivenResourceSelector resourcePathLocaleSelector = new LocaleDrivenResourceSelector(){

        @Override
        URL map(String path) throws IOException {
            URL override = LocaleDrivenResourceProvider.lookupResource(path);
            if (override != null) {
                return override;
            }
            return Stapler.this.getResource(path);
        }
    };
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="The Stapler class is not expected to be serialized.")
    private final LocaleDrivenResourceSelector urlLocaleSelector = new LocaleDrivenResourceSelector(){

        @Override
        URL map(String url) throws IOException {
            URL override = LocaleDrivenResourceProvider.lookupResource(url);
            if (override != null) {
                return override;
            }
            return new URL(url);
        }
    };
    private static final Pattern RANGE_SPEC = Pattern.compile("([\\d]+)-([\\d]*)");
    static final ThreadLocal<SimpleDateFormat> HTTP_DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    });
    static ThreadLocal<RequestImpl> CURRENT_REQUEST = new ThreadLocal();
    static ThreadLocal<ResponseImpl> CURRENT_RESPONSE = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Stapler.class.getName());
    public static final ConvertUtilsBean CONVERT_UTILS = new ConvertUtilsBean();
    private static final Converter ENUM_CONVERTER;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        this.webApp = WebApp.get(this.context);
        String defaultEncodings = servletConfig.getInitParameter("default-encodings");
        if (defaultEncodings != null) {
            for (String t : defaultEncodings.split(";")) {
                int idx = (t = t.trim()).indexOf(61);
                if (idx < 0) {
                    throw new ServletException("Invalid format: " + t);
                }
                this.webApp.defaultEncodingForStaticResources.put(t.substring(0, idx), t.substring(idx + 1));
            }
        }
        this.buildResourcePaths();
        this.webApp.addStaplerServlet(servletConfig.getServletName(), this);
        String v = servletConfig.getInitParameter("diagnosticThreadName");
        if (v != null) {
            this.diagnosticThreadName = Boolean.parseBoolean(v);
        }
    }

    public void buildResourcePaths() {
        try {
            if (Boolean.getBoolean(Stapler.class.getName() + ".noResourcePathCache")) {
                this.resourcePaths = null;
                return;
            }
            HashMap<String, URL> paths = new HashMap<String, URL>();
            Stack<String> q = new Stack<String>();
            q.push("/");
            while (!q.isEmpty()) {
                String dir = (String)q.pop();
                Set children = this.context.getResourcePaths(dir);
                if (children == null) continue;
                for (String child : children) {
                    if (child.endsWith("/")) {
                        q.push(child);
                        continue;
                    }
                    URL v = this.context.getResource(child);
                    if (v == null) {
                        this.resourcePaths = null;
                        return;
                    }
                    paths.put(child, v);
                }
            }
            this.resourcePaths = Collections.unmodifiableMap(paths);
        }
        catch (MalformedURLException e) {
            this.resourcePaths = null;
        }
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    void setWebApp(WebApp webApp) {
        this.webApp = webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            Object root;
            OpenConnection con;
            int idx;
            if (this.diagnosticThreadName) {
                t.setName("Handling " + req.getMethod() + " " + req.getRequestURI() + " : " + oldName);
            }
            String servletPath = this.getServletPath(req);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing request for " + servletPath);
            }
            if (servletPath.startsWith("/$stapler/bound/")) {
                this.invoke(req, rsp, this.webApp.boundObjectTable, servletPath.substring("/$stapler/bound/".length()));
                return;
            }
            boolean staticLink = false;
            if (servletPath.startsWith("/static/") && (idx = servletPath.indexOf(47, 8)) != -1) {
                servletPath = servletPath.substring(idx);
                staticLink = true;
            }
            String lowerPath = servletPath.toLowerCase(Locale.ENGLISH);
            if (!(servletPath.isEmpty() || lowerPath.startsWith("/web-inf") || lowerPath.startsWith("/meta-inf") || (con = this.openResourcePathByLocale(req, servletPath)) == null)) {
                long expires;
                long l = expires = MetaClass.NO_CACHE ? 0L : 86400000L;
                if (staticLink) {
                    expires *= 365L;
                }
                if (this.serveStaticResource(req, (StaplerResponse2)new ResponseImpl(this, rsp), con, expires)) {
                    return;
                }
            }
            if ((root = this.webApp.getApp()) == null) {
                throw new ServletException("there's no \"app\" attribute in the application context.");
            }
            this.invoke(req, rsp, root, servletPath);
        }
        finally {
            t.setName(oldName);
        }
    }

    private OpenConnection openResourcePathByLocale(HttpServletRequest req, String resourcePath) throws IOException {
        URL url = this.getResource(resourcePath);
        if (url == null) {
            return null;
        }
        return this.resourcePathLocaleSelector.open(resourcePath, req.getLocale(), url);
    }

    OpenConnection selectResourceByLocale(URL url, Locale locale) throws IOException {
        return this.urlLocaleSelector.open(url.toString(), locale, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean serveStaticResource(HttpServletRequest req, StaplerResponse2 rsp, OpenConnection con, long expiration) throws IOException {
        if (con == null) {
            return false;
        }
        try {
            boolean bl = this.serveStaticResource(req, rsp, con.stream, con.getLastModified(), expiration, con.connection.getContentLength(), con.connection.getURL().toString());
            return bl;
        }
        finally {
            con.close();
        }
    }

    boolean serveStaticResource(HttpServletRequest req, StaplerResponse2 rsp, URL url, long expiration) throws IOException {
        return this.serveStaticResource(req, rsp, this.openURL(url), expiration);
    }

    private OpenConnection openURL(URL url) {
        if (url == null) {
            return null;
        }
        File f = this.toFile(url);
        if (f != null && f.isDirectory()) {
            return null;
        }
        try {
            URLConnection con = Stapler.openConnection(url);
            OpenConnection c = new OpenConnection(con);
            if (c.stream == null) {
                return null;
            }
            return c;
        }
        catch (IOException e) {
            return null;
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Not relevant in this situation.")
    private static URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean serveStaticResource(HttpServletRequest req, StaplerResponse2 rsp, InputStream in, long lastModified, long expiration, long contentLength, String fileName) throws IOException {
        try {
            Matcher m;
            if (lastModified != 0L) {
                String since = req.getHeader("If-Modified-Since");
                SimpleDateFormat format = HTTP_DATE_FORMAT.get();
                if (since != null) {
                    try {
                        long ims = format.parse(since).getTime();
                        if (lastModified < ims + 1000L) {
                            rsp.setStatus(304);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (ParseException ims) {
                    }
                    catch (NumberFormatException e) {
                        this.getServletContext().log("Error parsing [" + since + "]", (Throwable)e);
                        throw e;
                    }
                }
                String lastModifiedStr = format.format(new Date(lastModified));
                rsp.setHeader("Last-Modified", lastModifiedStr);
                if (expiration <= 0L) {
                    rsp.setHeader("Expires", lastModifiedStr);
                } else {
                    rsp.setHeader("Expires", format.format(new Date(new Date().getTime() + expiration)));
                }
            }
            rsp.setHeader("Accept-Ranges", "bytes");
            String mimeType = this.getMimeType(fileName);
            rsp.setContentType(mimeType);
            rsp.setHeader("X-Content-Type-Options", "nosniff");
            String range = req.getHeader("Range");
            if (range != null && contentLength != -1L && range.startsWith("bytes=") && (m = RANGE_SPEC.matcher(range = range.substring(6))).matches()) {
                long toSkip;
                long thisSkip;
                long s = Long.parseLong(m.group(1));
                long e = !m.group(2).isEmpty() ? Long.parseLong(m.group(2)) + 1L : contentLength;
                e = Math.min(e, contentLength);
                rsp.setStatus(206);
                rsp.setHeader("Content-Range", "bytes " + s + "-" + (e - 1L) + "/" + contentLength);
                DataInputStream dis = new DataInputStream(in);
                for (toSkip = s; toSkip > 0L && (thisSkip = (long)dis.skipBytes((int)Math.min(toSkip, Integer.MAX_VALUE))) > 0L; toSkip -= thisSkip) {
                }
                if (toSkip > 0L) {
                    throw new IOException("skipBytes failure (" + toSkip + " of " + s + " bytes unskipped)");
                }
                in = new TruncatedInputStream(in, e - s);
                contentLength = Math.min(e - s, contentLength);
            }
            if (contentLength != -1L) {
                rsp.setHeader("Content-Length", Long.toString(contentLength));
            }
            ServletOutputStream out = rsp.getOutputStream();
            in.transferTo((OutputStream)out);
            out.close();
            boolean bl = true;
            return bl;
        }
        finally {
            in.close();
        }
    }

    private String getMimeType(String fileName) {
        if (fileName.startsWith("mime-type:")) {
            return fileName.substring("mime-type:".length());
        }
        int idx = fileName.lastIndexOf(47);
        fileName = fileName.substring(idx + 1);
        idx = fileName.lastIndexOf(92);
        fileName = fileName.substring(idx + 1);
        Object mimeType = this.getServletContext().getMimeType(fileName);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        if (this.webApp.defaultEncodingForStaticResources.containsKey(mimeType)) {
            mimeType = (String)mimeType + ";charset=" + this.webApp.defaultEncodingForStaticResources.get(mimeType);
        }
        return mimeType;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Protected by checks at other layers.")
    File toFile(URL url) {
        String urlstr = url.toExternalForm();
        if (!urlstr.startsWith("file:")) {
            return null;
        }
        return new File(URLDecoder.decode(urlstr.substring(5), StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpServletRequest req, HttpServletResponse rsp, Object root, String url) throws IOException, ServletException {
        RequestImpl sreq = new RequestImpl(this, req, new ArrayList<AncestorImpl>(), new TokenList(url));
        RequestImpl oreq = CURRENT_REQUEST.get();
        CURRENT_REQUEST.set(sreq);
        ResponseImpl srsp = new ResponseImpl(this, rsp);
        ResponseImpl orsp = CURRENT_RESPONSE.get();
        CURRENT_RESPONSE.set(srsp);
        try {
            this.invoke(sreq, srsp, root);
        }
        finally {
            CURRENT_REQUEST.set(oreq);
            CURRENT_RESPONSE.set(orsp);
        }
    }

    boolean tryInvoke(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
        StaplerOverridable o;
        Object list;
        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s: Dispatch", new String[0]);
        if (Dispatcher.traceable()) {
            Dispatcher.traceEval(req, rsp, node);
        }
        if (node instanceof StaplerProxy) {
            Dispatcher.anonymizedTraceEval(req, rsp, node, "%s: StaplerProxy.getTarget()", new String[0]);
            if (Dispatcher.traceable()) {
                Dispatcher.traceEval(req, rsp, node, "((StaplerProxy)", ").getTarget()");
            }
            Object n = null;
            try {
                n = ((StaplerProxy)node).getTarget();
            }
            catch (RuntimeException e) {
                if (Function.renderResponse(req, rsp, node, e)) {
                    return true;
                }
                throw e;
            }
            if (n != node) {
                if (n == null) {
                    return false;
                }
                this.invoke(req, rsp, n);
                return true;
            }
        }
        AncestorImpl ancestor = new AncestorImpl(req, node);
        ancestor.addToOwner();
        if (node instanceof StaplerOverridable && (list = (o = (StaplerOverridable)node).getOverrides()) != null) {
            int count = 0;
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object subject = iterator.next();
                if (subject == null) continue;
                Dispatcher.anonymizedTraceEval(req, rsp, node, "%s: StaplerOverridable.getOverrides()[i]", new String[0]);
                if (Dispatcher.traceable()) {
                    Dispatcher.traceEval(req, rsp, node, "((StaplerOverridable)", ").getOverrides()[" + count++ + "]");
                }
                if (!this.tryInvoke(req, rsp, subject)) continue;
                return true;
            }
        }
        MetaClass metaClass = this.webApp.getMetaClass(node);
        try {
            for (Dispatcher d : metaClass.dispatchers) {
                if (!d.dispatch(req, rsp, node)) continue;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Handled by " + d);
                }
                return true;
            }
        }
        catch (IllegalAccessException e) {
            if (!Stapler.isSocketException(e)) {
                this.getServletContext().log("Error while serving " + req.getRequestURL(), (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                this.getServletContext().log("Error while serving " + req.getRequestURL(), (Throwable)e);
                throw new ServletException();
            }
            for (HttpResponseRenderer r : this.webApp.getResponseRenderers()) {
                if (!r.generateResponse(req, rsp, node, cause)) continue;
                return true;
            }
            StringBuffer url = req.getRequestURL();
            if (cause instanceof IOException) {
                if (!Stapler.isSocketException(e)) {
                    this.getServletContext().log("Error while serving " + url, (Throwable)e);
                }
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                if (!Stapler.isSocketException(e)) {
                    this.getServletContext().log("Error while serving " + url, (Throwable)e);
                }
                throw (ServletException)cause;
            }
            for (Class<?> c = cause.getClass(); c != null; c = c.getSuperclass()) {
                if (c == Object.class) {
                    if (Stapler.isSocketException(e)) continue;
                    this.getServletContext().log("Error while serving " + url, (Throwable)e);
                    continue;
                }
                if (!EXCEPTIONS_DO_NOT_PRINT_STACKTRACE.contains(c.getName())) continue;
                this.getServletContext().log("While serving " + url + ": " + cause);
                break;
            }
            throw new ServletException(cause);
        }
        if (node instanceof StaplerFallback) {
            Object n;
            Dispatcher.anonymizedTraceEval(req, rsp, node, "%s: StaplerFallback.getStaplerFallback()", new String[0]);
            if (Dispatcher.traceable()) {
                Dispatcher.traceEval(req, rsp, node, "((StaplerFallback)", ").getStaplerFallback()");
            }
            try {
                n = ((StaplerFallback)node).getStaplerFallback();
            }
            catch (RuntimeException e) {
                if (Function.renderResponse(req, rsp, node, e)) {
                    return true;
                }
                throw e;
            }
            if (n != node && n != null) {
                this.invoke(req, rsp, n);
                return true;
            }
        }
        return false;
    }

    public static boolean isSocketException(Throwable x) {
        if (x == null) {
            return false;
        }
        if (x instanceof SocketException) {
            return true;
        }
        if (String.valueOf(x.getMessage()).equals("Broken pipe")) {
            return true;
        }
        if (x instanceof EOFException) {
            return true;
        }
        if (x instanceof IOException && "Closed".equals(x.getMessage())) {
            return true;
        }
        if (x instanceof IOException && "write beyond end of stream".equals(x.getMessage())) {
            return true;
        }
        return Stapler.isSocketException(x.getCause());
    }

    @SuppressFBWarnings(value={"XSS_SERVLET"}, justification="Handled by the escape() method or implementing code.")
    void invoke(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
        if (node == null) {
            if (!Dispatcher.isTraceEnabled(req)) {
                rsp.sendError(404);
            } else {
                rsp.setStatus(404);
                rsp.setContentType("text/html;charset=UTF-8");
                PrintWriter w = rsp.getWriter();
                w.println("<html><body>");
                w.println("<h1>404 Not Found</h1>");
                w.println("<p>Stapler processed this HTTP request as follows, but couldn't find the resource to consume the request");
                w.println("<pre>");
                EvaluationTrace.get(req).printHtml(w);
                w.println("<font color=red>-&gt; unexpected null!</font>");
                w.println("</pre>");
                w.println("<p>If this 404 is unexpected, double check the last part of the trace to see if it should have evaluated to null.");
                w.println("</body></html>");
            }
            return;
        }
        if (this.tryInvoke(req, rsp, node)) {
            return;
        }
        if (!Dispatcher.isTraceEnabled(req)) {
            rsp.sendError(404);
        } else {
            rsp.setStatus(404);
            rsp.setContentType("text/html;charset=UTF-8");
            PrintWriter w = rsp.getWriter();
            w.println("<html><body>");
            w.println("<h1>404 Not Found</h1>");
            w.println("<p>Stapler processed this HTTP request as follows, but couldn't find the resource to consume the request");
            w.println("<pre>");
            EvaluationTrace.get(req).printHtml(w);
            w.printf("<font color=red>-&gt; No matching rule was found on &lt;%s&gt; for \"%s\"</font>%n", Stapler.escape(node.toString()), req.tokens.assembleOriginalRestOfPath());
            w.println("</pre>");
            w.printf("<p>&lt;%s&gt; has the following URL mappings, in the order of preference:", Stapler.escape(node.toString()));
            w.println("<ol>");
            MetaClass metaClass = this.webApp.getMetaClass(node);
            for (Dispatcher d : metaClass.dispatchers) {
                w.println("<li>");
                w.println(d.toString());
            }
            w.println("</ol>");
            w.println("</body></html>");
        }
    }

    @SuppressFBWarnings(value={"REQUESTDISPATCHER_FILE_DISCLOSURE"}, justification="Forwarding the request to be handled correctly.")
    public void forward(RequestDispatcher dispatcher, StaplerRequest2 req, HttpServletResponse rsp) throws ServletException, IOException {
        dispatcher.forward((ServletRequest)req, (ServletResponse)new ResponseImpl(this, rsp));
    }

    URL getResource(String name) throws MalformedURLException {
        if (this.resourcePaths != null) {
            return this.resourcePaths.get(name);
        }
        return this.context.getResource(name);
    }

    public static String getViewURL(Class clazz, String jspName) {
        return "/WEB-INF/side-files/" + clazz.getName().replace('.', '/') + "/" + jspName;
    }

    public static void setRoot(ServletContextEvent event, Object rootApp) {
        event.getServletContext().setAttribute("app", rootApp);
    }

    @Deprecated
    public static void setClassLoader(ServletContext context, ClassLoader classLoader) {
        WebApp.get(context).setClassLoader(classLoader);
    }

    @Deprecated
    public static ClassLoader getClassLoader(ServletContext context) {
        return WebApp.get(context).getClassLoader();
    }

    @Deprecated
    public ClassLoader getClassLoader() {
        return this.webApp.getClassLoader();
    }

    public static StaplerRequest2 getCurrentRequest2() {
        return CURRENT_REQUEST.get();
    }

    @Deprecated
    public static StaplerRequest getCurrentRequest() {
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        return currentRequest != null ? StaplerRequest.fromStaplerRequest2(currentRequest) : null;
    }

    public static StaplerResponse2 getCurrentResponse2() {
        return CURRENT_RESPONSE.get();
    }

    @Deprecated
    public static StaplerResponse getCurrentResponse() {
        StaplerResponse2 currentResponse = Stapler.getCurrentResponse2();
        return currentResponse != null ? StaplerResponse.fromStaplerResponse2(currentResponse) : null;
    }

    public static Stapler getCurrent() {
        RequestImpl req = CURRENT_REQUEST.get();
        return req != null ? req.getStapler() : null;
    }

    String getServletPath(HttpServletRequest req) {
        return Stapler.canonicalPath(req.getRequestURI().substring(req.getContextPath().length()));
    }

    static String canonicalPath(String path) {
        ArrayList<String> r = new ArrayList<String>(Arrays.asList(path.split("/+")));
        int i = 0;
        while (i < r.size()) {
            if (((String)r.get(i)).isEmpty() || ((String)r.get(i)).equals(".")) {
                r.remove(i);
                continue;
            }
            if (((String)r.get(i)).equals("..")) {
                r.remove(i);
                if (i <= 0) continue;
                r.remove(i - 1);
                --i;
                continue;
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        if (path.startsWith("/")) {
            buf.append('/');
        }
        boolean first = true;
        for (String token : r) {
            if (!first) {
                buf.append('/');
            } else {
                first = false;
            }
            buf.append(token);
        }
        if (path.endsWith("/") && (buf.isEmpty() || buf.charAt(buf.length() - 1) != '/')) {
            buf.append('/');
        }
        return buf.toString();
    }

    public static Converter lookupConverter(Class type) {
        Converter c = CONVERT_UTILS.lookup(type);
        if (c != null) {
            return c;
        }
        c = ConvertUtils.lookup((Class)type);
        if (c != null) {
            return c;
        }
        try {
            if (type.getClassLoader() == null) {
                return null;
            }
            Class<?> cl = type.getClassLoader().loadClass(type.getName() + "$StaplerConverterImpl");
            c = (Converter)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            CONVERT_UTILS.register(c, type);
            return c;
        }
        catch (ClassNotFoundException cl) {
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError();
            x.initCause(e);
            throw x;
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError x = new NoSuchMethodError();
            x.initCause(e);
            throw x;
        }
        catch (InstantiationException e) {
            InstantiationError x = new InstantiationError();
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw new UncheckedIOException((IOException)t);
            }
            if (t instanceof Exception) {
                throw new RuntimeException(t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(e);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return ENUM_CONVERTER;
        }
        return null;
    }

    public static String escape(String v) {
        if (v == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(v.length() + 64);
        for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() == v.length()) {
            return v;
        }
        return buf.toString();
    }

    public static Object[] htmlSafeArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = Stapler.htmlSafeArgument(args[i]);
        }
        return args;
    }

    public static Object htmlSafeArgument(Object o) {
        if (o instanceof RawHtmlArgument) {
            return ((RawHtmlArgument)o).getValue();
        }
        if (o instanceof Number || o instanceof Calendar || o instanceof Date) {
            return o;
        }
        if (o == null) {
            return o;
        }
        return Stapler.escape(o.toString());
    }

    static {
        CONVERT_UTILS.register(new Converter(){

            public Object convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new ConversionException((Throwable)e);
                }
            }
        }, URL.class);
        CONVERT_UTILS.register(new Converter(){

            public FileItem convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return Stapler.getCurrentRequest2().getFileItem2(value.toString());
                }
                catch (ServletException | IOException e) {
                    throw new ConversionException(e);
                }
            }
        }, FileItem.class);
        CONVERT_UTILS.register(new Converter(){

            public org.apache.commons.fileupload.FileItem convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem(Stapler.getCurrentRequest2().getFileItem2(value.toString()));
                }
                catch (ServletException | IOException e) {
                    throw new ConversionException(e);
                }
            }
        }, org.apache.commons.fileupload.FileItem.class);
        CONVERT_UTILS.register((Converter)new IntegerConverter(null), Integer.class);
        CONVERT_UTILS.register((Converter)new FloatConverter(null), Float.class);
        CONVERT_UTILS.register((Converter)new DoubleConverter(null), Double.class);
        ENUM_CONVERTER = new Converter(){

            public Object convert(Class type, Object value) {
                return Enum.valueOf(type, value.toString());
            }
        };
    }

    private abstract class LocaleDrivenResourceSelector {
        private LocaleDrivenResourceSelector() {
        }

        OpenConnection open(String path, Locale locale, URL fallback) throws IOException {
            OpenConnection con;
            String s = path;
            int idx = s.lastIndexOf(46);
            if (idx < 0) {
                return Stapler.this.openURL(fallback);
            }
            String base = s.substring(0, idx);
            String ext = s.substring(idx);
            if (ext.indexOf(47) >= 0) {
                return Stapler.this.openURL(fallback);
            }
            String language = locale.getLanguage();
            boolean languageOk = language.matches("^[a-zA-Z]{2,8}$");
            String country = locale.getCountry();
            boolean countryOk = country.matches("^[a-zA-Z]{2}|[0-9]{3}$");
            String variant = locale.getVariant();
            String SUBTAG = "(?:[0-9][0-9a-zA-Z]{3}|[0-9a-zA-Z]{5,8})";
            boolean variantOk = variant.matches("^" + SUBTAG + "(?:[_\\-]" + SUBTAG + ")*$");
            if (languageOk && countryOk && variantOk && (con = Stapler.this.openURL(this.map(base + "_" + language + "_" + country + "_" + variant + ext))) != null) {
                return con;
            }
            if (languageOk && countryOk && (con = Stapler.this.openURL(this.map(base + "_" + language + "_" + country + ext))) != null) {
                return con;
            }
            if (languageOk && (con = Stapler.this.openURL(this.map(base + "_" + language + ext))) != null) {
                return con;
            }
            return Stapler.this.openURL(fallback);
        }

        abstract URL map(String var1) throws IOException;
    }

    private static final class OpenConnection {
        final URLConnection connection;
        final InputStream stream;

        private OpenConnection(URLConnection connection, InputStream stream) {
            this.connection = connection;
            this.stream = stream;
        }

        private OpenConnection(URLConnection connection) throws IOException {
            this(connection, connection.getInputStream());
        }

        private void close() throws IOException {
            this.stream.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastModified() {
            if (this.connection instanceof JarURLConnection) {
                URL jarURL = ((JarURLConnection)this.connection).getJarFileURL();
                if (jarURL.getProtocol().equals("file")) {
                    return this.determineLastModified(jarURL);
                }
                URLConnection jarConn = null;
                try {
                    jarConn = Stapler.openConnection(jarURL);
                    long l = jarConn.getLastModified();
                    return l;
                }
                catch (IOException e) {
                    long l = -1L;
                    return l;
                }
                finally {
                    if (jarConn != null) {
                        try {
                            IOUtils.closeQuietly((InputStream)jarConn.getInputStream());
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return this.connection.getLastModified();
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Protected by checks at other layers.")
        private long determineLastModified(URL jarURL) {
            return new File(jarURL.getFile()).lastModified();
        }
    }
}

