/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.json;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class JsonHttpResponse
extends HttpResponses.HttpResponseException {
    @Nullable
    private final JSONObject responseJson;
    private final int status;

    public JsonHttpResponse(JSONObject o) {
        this(o, o == null ? 204 : 200);
    }

    public JsonHttpResponse(JSONObject o, int status) {
        this.responseJson = o;
        this.status = status;
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="Jenkins handles this issue differently or doesn't care about it")
    public JsonHttpResponse(Throwable t, int status) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.responseJson = new JSONObject().element("error", (Object)(t.getClass().getName() + ": " + t.getMessage())).element("stackTrace", (Object)sw.toString());
        this.status = status;
    }

    @Override
    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
        if (this.status > 0) {
            rsp.setStatus(this.status);
        }
        if (this.responseJson != null) {
            rsp.setContentType("application/json;charset=UTF-8");
            try (PrintWriter w = rsp.getWriter();){
                this.responseJson.write((Writer)w);
            }
        }
    }
}

