/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchPropertyStrategyDescriptor;
import jenkins.branch.Messages;
import jenkins.scm.api.SCMHead;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultBranchPropertyStrategy
extends BranchPropertyStrategy {
    @NonNull
    private final List<BranchProperty> properties;

    @DataBoundConstructor
    public DefaultBranchPropertyStrategy(@CheckForNull BranchProperty[] props) {
        this.properties = props == null ? Collections.emptyList() : Arrays.asList(props);
    }

    @NonNull
    public List<BranchProperty> getProps() {
        return this.properties;
    }

    @Override
    @NonNull
    public List<BranchProperty> getPropertiesFor(SCMHead head) {
        return new ArrayList<BranchProperty>(this.properties);
    }

    @Symbol(value={"allBranchesSame"})
    @Extension
    public static class DescriptorImpl
    extends BranchPropertyStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.DefaultBranchPropertyStrategy_DisplayName();
        }
    }
}

