/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.lifecycle.Lifecycle;
import hudson.util.StreamTaskListener;
import hudson.util.jna.Kernel32;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class WindowsServiceLifecycle
extends Lifecycle {
    private static final Logger LOGGER = Logger.getLogger(WindowsServiceLifecycle.class.getName());

    public WindowsServiceLifecycle() {
        this.updateJenkinsExeIfNeeded();
    }

    private void updateJenkinsExeIfNeeded() {
        try {
            File baseDir = WindowsServiceLifecycle.getBaseDir();
            URL exe = this.getClass().getResource("/windows-service/jenkins.exe");
            String ourCopy = Util.getDigestOf(exe.openStream());
            for (String name : new String[]{"hudson.exe", "jenkins.exe"}) {
                try {
                    String curCopy;
                    File currentCopy = new File(baseDir, name);
                    if (!currentCopy.exists() || ourCopy.equals(curCopy = new FilePath(currentCopy).digest())) continue;
                    File stage = new File(baseDir, name + ".new");
                    FileUtils.copyURLToFile((URL)exe, (File)stage);
                    Kernel32.INSTANCE.MoveFileExA(stage.getAbsolutePath(), currentCopy.getAbsolutePath(), 5);
                    LOGGER.info("Scheduled a replacement of " + name);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to replace " + name, e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to replace jenkins.exe", e);
        }
    }

    @Override
    public void rewriteHudsonWar(File by) throws IOException {
        File dest = this.getHudsonWar();
        if (dest == null) {
            throw new IOException("jenkins.war location is not known.");
        }
        File bak = new File(dest.getPath() + ".bak");
        if (!by.equals(bak)) {
            FileUtils.copyFile((File)dest, (File)bak);
        }
        String baseName = dest.getName();
        baseName = baseName.substring(0, baseName.indexOf(46));
        File baseDir = WindowsServiceLifecycle.getBaseDir();
        File copyFiles = new File(baseDir, baseName + ".copies");
        try (BufferedWriter w = Files.newBufferedWriter(Util.fileToPath(copyFiles), Charset.defaultCharset(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            w.write(by.getAbsolutePath() + '>' + this.getHudsonWar().getAbsolutePath() + '\n');
        }
    }

    @Override
    public void restart() throws IOException, InterruptedException {
        int r;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        try {
            if (jenkins != null) {
                jenkins.cleanUp();
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to clean up. Restart will continue.", e);
        }
        File me = this.getHudsonWar();
        File home = me.getParentFile();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamTaskListener task = new StreamTaskListener((OutputStream)baos);
        task.getLogger().println("Restarting a service");
        String exe = System.getenv("WINSW_EXECUTABLE");
        File executable = exe != null ? new File(exe) : new File(home, "hudson.exe");
        if (!executable.exists()) {
            executable = new File(home, "jenkins.exe");
        }
        if ((r = new Launcher.LocalLauncher(task).launch().cmds(executable, "restart!").stdout(task).pwd(home).join()) != 0) {
            throw new IOException(baos.toString());
        }
    }

    private static File getBaseDir() {
        File baseDir;
        String baseEnv = System.getenv("BASE");
        if (baseEnv != null) {
            baseDir = new File(baseEnv);
        } else {
            LOGGER.log(Level.WARNING, "Could not find environment variable 'BASE' for Jenkins base directory. Falling back to JENKINS_HOME");
            baseDir = Jenkins.get().getRootDir();
        }
        return baseDir;
    }
}

