/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Messages;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.ItemListener;
import hudson.security.AccessControlled;
import hudson.util.CopyOnWriteMap;
import hudson.util.Function1;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.servlet.ServletException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.xml.XMLUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.access.AccessDeniedException;
import org.xml.sax.SAXException;

public abstract class ItemGroupMixIn {
    private final ItemGroup parent;
    private final AccessControlled acl;
    public static final Function1<String, Item> KEYED_BY_NAME = Item::getName;

    protected ItemGroupMixIn(ItemGroup parent, AccessControlled acl) {
        this.parent = parent;
        this.acl = acl;
    }

    protected abstract void add(TopLevelItem var1);

    protected abstract File getRootDirFor(String var1);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K, V extends Item> Map<K, V> loadChildren(ItemGroup parent, File modulesDir, Function1<? extends K, ? super V> key) {
        try {
            Util.createDirectories(modulesDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] subdirs = modulesDir.listFiles(File::isDirectory);
        CopyOnWriteMap.Tree<K, void> configurations = new CopyOnWriteMap.Tree<K, void>();
        File[] fileArray = subdirs;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            block8: {
                if (n2 >= n) {
                    return configurations;
                }
                File subdir = fileArray[n2];
                try {
                    void var9_13;
                    block10: {
                        Object t;
                        block9: {
                            t = parent.getItem(subdir.getName());
                            if (t != null) break block9;
                            XmlFile xmlFile = Items.getConfigFile(subdir);
                            if (xmlFile.exists()) {
                                Item item = Items.load(parent, subdir);
                                break block10;
                            } else {
                                Logger.getLogger(ItemGroupMixIn.class.getName()).log(Level.WARNING, "could not find file " + xmlFile.getFile());
                                break block8;
                            }
                        }
                        t.onLoad(parent, subdir.getName());
                    }
                    configurations.put(key.call(var9_13), var9_13);
                }
                catch (Exception exception) {
                    Logger.getLogger(ItemGroupMixIn.class.getName()).log(Level.WARNING, "could not load " + subdir, exception);
                }
            }
            ++n2;
        }
    }

    public synchronized TopLevelItem createTopLevelItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        TopLevelItem result;
        this.acl.checkPermission(Item.CREATE);
        String requestContentType = req.getContentType();
        String mode = req.getParameter("mode");
        if (!(requestContentType != null || mode != null && mode.equals("copy"))) {
            throw new Failure("No Content-Type header set");
        }
        boolean isXmlSubmission = requestContentType != null && (requestContentType.startsWith("application/xml") || requestContentType.startsWith("text/xml"));
        String name = req.getParameter("name");
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        Jenkins.checkGoodName(name);
        name = name.trim();
        if (this.parent.getItem(name) != null) {
            throw new Failure(Messages.Hudson_JobAlreadyExists(name));
        }
        if (mode != null && mode.equals("copy")) {
            String from = req.getParameter("from");
            Item src = Jenkins.get().getItem(from, this.parent);
            if (src == null) {
                if (Util.fixEmpty(from) == null) {
                    throw new Failure("Specify which job to copy");
                }
                throw new Failure("No such job: " + from);
            }
            if (!(src instanceof TopLevelItem)) {
                throw new Failure(from + " cannot be copied");
            }
            result = this.copy((TopLevelItem)src, name);
        } else {
            if (isXmlSubmission) {
                TopLevelItem result2 = this.createProjectFromXML(name, (InputStream)req.getInputStream());
                rsp.setStatus(200);
                return result2;
            }
            if (mode == null) {
                throw new Failure("No mode given");
            }
            TopLevelItemDescriptor descriptor = Items.all().findByName(mode);
            if (descriptor == null) {
                throw new Failure("No item type \u2018" + mode + "\u2019 is known");
            }
            descriptor.checkApplicableIn(this.parent);
            this.acl.getACL().checkCreatePermission(this.parent, descriptor);
            result = this.createProject(descriptor, name, true);
        }
        rsp.sendRedirect2(this.redirectAfterCreateItem(req, result));
        return result;
    }

    protected String redirectAfterCreateItem(StaplerRequest req, TopLevelItem result) throws IOException {
        return req.getContextPath() + '/' + result.getUrl() + "configure";
    }

    public synchronized <T extends TopLevelItem> T copy(T src, String name) throws IOException {
        this.acl.checkPermission(Item.CREATE);
        src.checkPermission(Item.EXTENDED_READ);
        XmlFile srcConfigFile = Items.getConfigFile(src);
        if (!src.hasPermission(Item.CONFIGURE)) {
            Matcher matcher = AbstractItem.SECRET_PATTERN.matcher(srcConfigFile.asString());
            while (matcher.find()) {
                if (Secret.decrypt(matcher.group(1)) == null) continue;
                throw new AccessDeniedException(Messages.ItemGroupMixIn_may_not_copy_as_it_contains_secrets_and_(src.getFullName(), Jenkins.getAuthentication2().getName(), Item.PERMISSIONS.title, Item.EXTENDED_READ.name, Item.CONFIGURE.name));
            }
        }
        src.getDescriptor().checkApplicableIn(this.parent);
        this.acl.getACL().checkCreatePermission(this.parent, src.getDescriptor());
        Jenkins.checkGoodName(name);
        ItemListener.checkBeforeCopy(src, this.parent);
        TopLevelItem result = this.createProject(src.getDescriptor(), name, false);
        Files.copy(Util.fileToPath(srcConfigFile.getFile()), Util.fileToPath(Items.getConfigFile(result).getFile()), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        final File rootDir = result.getRootDir();
        result = (TopLevelItem)Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<T, IOException>(){

            public T call() throws IOException {
                return (TopLevelItem)Items.load(ItemGroupMixIn.this.parent, rootDir);
            }
        });
        result.onCopiedFrom(src);
        this.add(result);
        ItemListener.fireOnCopied(src, result);
        Jenkins.get().rebuildDependencyGraphAsync();
        return (T)result;
    }

    public synchronized TopLevelItem createProjectFromXML(String name, InputStream xml) throws IOException {
        this.acl.checkPermission(Item.CREATE);
        Jenkins.get().getProjectNamingStrategy().checkName(name);
        Items.verifyItemDoesNotAlreadyExist(this.parent, name, null);
        Jenkins.checkGoodName(name);
        File configXml = Items.getConfigFile(this.getRootDirFor(name)).getFile();
        final File dir = configXml.getParentFile();
        boolean success = false;
        try {
            Util.createDirectories(dir.toPath(), new FileAttribute[0]);
            XMLUtils.safeTransform(new StreamSource(xml), new StreamResult(configXml));
            TopLevelItem result = Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<TopLevelItem, IOException>(){

                public TopLevelItem call() throws IOException {
                    return (TopLevelItem)Items.load(ItemGroupMixIn.this.parent, dir);
                }
            });
            success = this.acl.getACL().hasCreatePermission2(Jenkins.getAuthentication2(), this.parent, result.getDescriptor()) && result.getDescriptor().isApplicableIn(this.parent);
            this.add(result);
            ItemListener.fireOnCreated(result);
            Jenkins.get().rebuildDependencyGraphAsync();
            TopLevelItem topLevelItem = result;
            return topLevelItem;
        }
        catch (TransformerException | SAXException e) {
            success = false;
            throw new IOException("Failed to persist config.xml", e);
        }
        catch (IOException | RuntimeException e) {
            success = false;
            throw e;
        }
        finally {
            if (!success) {
                Util.deleteRecursive(dir);
            }
        }
    }

    public synchronized TopLevelItem createProject(TopLevelItemDescriptor type, String name, boolean notify) throws IOException {
        this.acl.checkPermission(Item.CREATE);
        type.checkApplicableIn(this.parent);
        this.acl.getACL().checkCreatePermission(this.parent, type);
        Jenkins.get().getProjectNamingStrategy().checkName(name);
        Items.verifyItemDoesNotAlreadyExist(this.parent, name, null);
        Jenkins.checkGoodName(name);
        TopLevelItem item = type.newInstance(this.parent, name);
        item.onCreatedFromScratch();
        item.save();
        this.add(item);
        Jenkins.get().rebuildDependencyGraphAsync();
        if (notify) {
            ItemListener.fireOnCreated(item);
        }
        return item;
    }
}

