/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.queue.ScheduleResult;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.OptionalJobProperty;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.util.TimeDuration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class ParametersDefinitionProperty
extends OptionalJobProperty<Job<?, ?>>
implements Action {
    private final List<ParameterDefinition> parameterDefinitions;

    @DataBoundConstructor
    public ParametersDefinitionProperty(@NonNull List<ParameterDefinition> parameterDefinitions) {
        this.parameterDefinitions = parameterDefinitions != null ? parameterDefinitions : new ArrayList();
    }

    public ParametersDefinitionProperty(ParameterDefinition ... parameterDefinitions) {
        this.parameterDefinitions = parameterDefinitions != null ? Arrays.asList(parameterDefinitions) : new ArrayList<ParameterDefinition>();
    }

    private Object readResolve() {
        return this.parameterDefinitions == null ? new ParametersDefinitionProperty(new ParameterDefinition[0]) : this;
    }

    @Deprecated
    public AbstractProject<?, ?> getOwner() {
        return (AbstractProject)this.owner;
    }

    @Restricted(value={NoExternalUse.class})
    public ParameterizedJobMixIn.ParameterizedJob getJob() {
        return (ParameterizedJobMixIn.ParameterizedJob)((Object)this.owner);
    }

    @Exported
    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public List<String> getParameterDefinitionNames() {
        return new DefinitionsAbstractList(this.parameterDefinitions);
    }

    @Override
    @NonNull
    public Collection<Action> getJobActions(Job<?, ?> job) {
        return Collections.singleton(this);
    }

    @Override
    @Deprecated
    public Collection<Action> getJobActions(AbstractProject<?, ?> job) {
        return this.getJobActions((Job<?, ?>)job);
    }

    @Deprecated
    public AbstractProject<?, ?> getProject() {
        return (AbstractProject)this.owner;
    }

    @Deprecated
    public void _doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this._doBuild(req, rsp, TimeDuration.fromString(req.getParameter("delay")));
    }

    public void _doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        if (delay == null) {
            delay = new TimeDuration(TimeUnit.MILLISECONDS.convert(this.getJob().getQuietPeriod(), TimeUnit.SECONDS));
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
        for (Object o : a) {
            JSONObject jo = (JSONObject)o;
            String name = jo.getString("name");
            ParameterDefinition d = this.getParameterDefinition(name);
            if (d == null) {
                throw new IllegalArgumentException("No such parameter definition: " + name);
            }
            ParameterValue parameterValue = d.createValue(req, jo);
            if (parameterValue != null) {
                values.add(parameterValue);
                continue;
            }
            throw new IllegalArgumentException("Cannot retrieve the parameter value: " + name);
        }
        Queue.WaitingItem item = Jenkins.get().getQueue().schedule((Queue.Task)this.getJob(), delay.getTimeInSeconds(), new ParametersAction(values), new CauseAction((Cause)new Cause.UserIdCause()));
        if (item != null) {
            String url = formData.optString("redirectTo");
            if (url == null || !Util.isSafeToRedirectTo(url)) {
                url = req.getContextPath() + '/' + item.getUrl();
            }
            rsp.sendRedirect(formData.optInt("statusCode", 201), url);
        } else {
            rsp.sendRedirect(".");
        }
    }

    @Deprecated
    public void buildWithParameters(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.buildWithParameters(req, rsp, TimeDuration.fromString(req.getParameter("delay")));
    }

    public void buildWithParameters(StaplerRequest req, StaplerResponse rsp, @CheckForNull TimeDuration delay) throws IOException, ServletException {
        ScheduleResult scheduleResult;
        Queue.Item item;
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (ParameterDefinition d : this.parameterDefinitions) {
            ParameterValue value = d.createValue(req);
            if (value == null) continue;
            values.add(value);
        }
        if (delay == null) {
            delay = new TimeDuration(TimeUnit.MILLISECONDS.convert(this.getJob().getQuietPeriod(), TimeUnit.SECONDS));
        }
        if ((item = (scheduleResult = Jenkins.get().getQueue().schedule2((Queue.Task)this.getJob(), delay.getTimeInSeconds(), new ParametersAction(values), ParameterizedJobMixIn.getBuildCause(this.getJob(), req))).getItem()) != null && !scheduleResult.isCreated()) {
            rsp.sendRedirect(303, req.getContextPath() + '/' + item.getUrl());
            return;
        }
        if (item != null) {
            rsp.sendRedirect(201, req.getContextPath() + '/' + item.getUrl());
            return;
        }
        rsp.sendRedirect(".");
    }

    @CheckForNull
    public ParameterDefinition getParameterDefinition(String name) {
        for (ParameterDefinition pd : this.parameterDefinitions) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return null;
    }

    private static class DefinitionsAbstractList
    extends AbstractList<String> {
        private final List<ParameterDefinition> parameterDefinitions;

        DefinitionsAbstractList(List<ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = parameterDefinitions;
        }

        @Override
        public String get(int index) {
            return this.parameterDefinitions.get(index).getName();
        }

        @Override
        public int size() {
            return this.parameterDefinitions.size();
        }
    }

    @Extension
    @Symbol(value={"parameters"})
    public static class DescriptorImpl
    extends OptionalJobProperty.OptionalJobPropertyDescriptor {
        @Override
        public ParametersDefinitionProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ParametersDefinitionProperty prop = (ParametersDefinitionProperty)super.newInstance(req, formData);
            if (prop != null && prop.parameterDefinitions.isEmpty()) {
                return null;
            }
            return prop;
        }

        @Override
        public boolean isApplicable(Class<? extends Job> jobType) {
            return ParameterizedJobMixIn.ParameterizedJob.class.isAssignableFrom(jobType);
        }

        @Override
        public String getDisplayName() {
            return Messages.ParametersDefinitionProperty_DisplayName();
        }
    }
}

