/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.queue.FutureLoad;
import hudson.model.queue.MappingWorksheet;
import java.util.ArrayList;
import java.util.Collections;

public abstract class LoadPredictor
implements ExtensionPoint {
    public Iterable<FutureLoad> predict(MappingWorksheet plan, Computer computer, long start, long end) {
        return this.predict(computer, start, end);
    }

    @Deprecated
    public Iterable<FutureLoad> predict(Computer computer, long start, long end) {
        return Collections.emptyList();
    }

    public static ExtensionList<LoadPredictor> all() {
        return ExtensionList.lookup(LoadPredictor.class);
    }

    @Extension
    public static class CurrentlyRunningTasks
    extends LoadPredictor {
        @Override
        public Iterable<FutureLoad> predict(MappingWorksheet plan, Computer computer, long start, long eternity) {
            long now = System.currentTimeMillis();
            ArrayList<FutureLoad> fl = new ArrayList<FutureLoad>();
            for (Executor e : computer.getExecutors()) {
                long end;
                if (e.isIdle()) continue;
                long eta = e.getEstimatedRemainingTimeMillis();
                long l = end = eta < 0L ? eternity : now + eta;
                if (end < start) continue;
                fl.add(new FutureLoad(start, end - start, 1));
            }
            return fl;
        }
    }
}

