/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.Messages;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ZipExtractionInstaller
extends ToolInstaller {
    private final String url;
    private final String subdir;

    @DataBoundConstructor
    public ZipExtractionInstaller(String label, String url, String subdir) {
        super(label);
        this.url = url;
        this.subdir = Util.fixEmptyAndTrim(subdir);
    }

    public String getUrl() {
        return this.url;
    }

    public String getSubdir() {
        return this.subdir;
    }

    @Override
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath dir = this.preferredLocation(tool, node);
        if (dir.installIfNecessaryFrom(new URL(this.url), log, "Unpacking " + this.url + " to " + dir + " on " + node.getDisplayName())) {
            dir.act(new ChmodRecAPlusX());
        }
        if (this.subdir == null) {
            return dir;
        }
        return dir.child(this.subdir);
    }

    static class ChmodRecAPlusX
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        ChmodRecAPlusX() {
        }

        @Override
        public Void invoke(File d, VirtualChannel channel) throws IOException {
            if (!Functions.isWindows()) {
                this.process(d);
            }
            return null;
        }

        private void process(File f) {
            if (f.isFile()) {
                f.setExecutable(true, false);
            } else {
                File[] kids = f.listFiles();
                if (kids != null) {
                    for (File kid : kids) {
                        this.process(kid);
                    }
                }
            }
        }
    }

    @Extension
    @Symbol(value={"zip"})
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<ZipExtractionInstaller> {
        @Override
        public String getDisplayName() {
            return Messages.ZipExtractionInstaller_DescriptorImpl_displayName();
        }

        @RequirePOST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                URLConnection conn = ProxyConfiguration.open(new URL(value));
                conn.connect();
                if (conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() != 200) {
                    return FormValidation.error(Messages.ZipExtractionInstaller_bad_connection());
                }
                return FormValidation.ok();
            }
            catch (MalformedURLException x) {
                return FormValidation.error(Messages.ZipExtractionInstaller_malformed_url());
            }
            catch (IOException x) {
                return FormValidation.error(x, Messages.ZipExtractionInstaller_could_not_connect());
            }
        }
    }
}

