/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.util.Iterators;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ConsistentHash<T> {
    private final Map<T, Point[]> items = new HashMap<T, Point[]>();
    private int numPoints;
    private final int defaultReplication;
    private final Hash<T> hash;
    private volatile Table table;
    static final Hash<?> DEFAULT_HASH = Object::toString;

    public ConsistentHash() {
        this(DEFAULT_HASH);
    }

    public ConsistentHash(int defaultReplication) {
        this(DEFAULT_HASH, defaultReplication);
    }

    public ConsistentHash(Hash<T> hash) {
        this(hash, 100);
    }

    public ConsistentHash(Hash<T> hash, int defaultReplication) {
        this.hash = hash;
        this.defaultReplication = defaultReplication;
        this.refreshTable();
    }

    public int countAllPoints() {
        return this.numPoints;
    }

    public synchronized void add(T node) {
        this.add(node, this.defaultReplication);
    }

    public synchronized void addAll(T ... nodes) {
        for (T node : nodes) {
            this.addInternal(node, this.defaultReplication);
        }
        this.refreshTable();
    }

    public synchronized void addAll(Collection<? extends T> nodes) {
        for (T node : nodes) {
            this.addInternal(node, this.defaultReplication);
        }
        this.refreshTable();
    }

    public synchronized void addAll(Map<? extends T, Integer> nodes) {
        for (Map.Entry<T, Integer> node : nodes.entrySet()) {
            this.addInternal(node.getKey(), node.getValue());
        }
        this.refreshTable();
    }

    public synchronized void remove(T node) {
        this.add(node, 0);
    }

    public synchronized void add(T node, int replica) {
        this.addInternal(node, replica);
        this.refreshTable();
    }

    private synchronized void addInternal(T node, int replica) {
        if (replica == 0) {
            this.items.remove(node);
        } else {
            Point[] points = new Point[replica];
            String seed = this.hash.hash(node);
            for (int i = 0; i < replica; ++i) {
                points[i] = new Point(this.digest(seed + ':' + i), node);
            }
            this.items.put(node, points);
        }
    }

    private synchronized void refreshTable() {
        this.table = new Table();
    }

    private int digest(String s) {
        try {
            MessageDigest messageDigest = this.createMessageDigest();
            messageDigest.update(s.getBytes(StandardCharsets.UTF_8));
            byte[] digest = messageDigest.digest();
            for (int i = 0; i < 4; ++i) {
                int n = i;
                digest[n] = (byte)(digest[n] ^ digest[i + 4] + digest[i + 8] + digest[i + 12]);
            }
            return this.b2i(digest[0]) << 24 | this.b2i(digest[1]) << 16 | this.b2i(digest[2]) << 8 | this.b2i(digest[3]);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not generate SHA-256 hash", e);
        }
    }

    private MessageDigest createMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-256");
    }

    private int b2i(byte b) {
        return b & 0xFF;
    }

    public T lookup(int queryPoint) {
        return this.table.lookup(queryPoint);
    }

    public T lookup(String queryPoint) {
        return this.lookup(this.digest(queryPoint));
    }

    public Iterable<T> list(int queryPoint) {
        return () -> this.table.list(queryPoint);
    }

    public Iterable<T> list(String queryPoint) {
        return this.list(this.digest(queryPoint));
    }

    public static interface Hash<T> {
        public String hash(T var1);
    }

    private final class Table {
        private final int[] hash;
        private final Object[] owner;

        private Table() {
            int r = 0;
            for (Point[] v : ConsistentHash.this.items.values()) {
                r += v.length;
            }
            ConsistentHash.this.numPoints = r;
            Object[] allPoints = new Point[ConsistentHash.this.numPoints];
            int p = 0;
            for (Point[] v : ConsistentHash.this.items.values()) {
                System.arraycopy(v, 0, allPoints, p, v.length);
                p += v.length;
            }
            Arrays.sort(allPoints);
            this.hash = new int[allPoints.length];
            this.owner = new Object[allPoints.length];
            for (int i = 0; i < allPoints.length; ++i) {
                Object pt = allPoints[i];
                this.hash[i] = ((Point)pt).hash;
                this.owner[i] = ((Point)pt).item;
            }
        }

        T lookup(int queryPoint) {
            int i = this.index(queryPoint);
            if (i < 0) {
                return null;
            }
            return this.owner[i];
        }

        Iterator<T> list(int queryPoint) {
            final int start = this.index(queryPoint);
            return new Iterators.DuplicateFilterIterator(new Iterator<T>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < Table.this.owner.length;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return Table.this.owner[(start + this.pos++) % Table.this.owner.length];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }

        private int index(int queryPoint) {
            int idx = Arrays.binarySearch(this.hash, queryPoint);
            if (idx < 0) {
                idx = -idx - 1;
                if (this.hash.length == 0) {
                    return -1;
                }
                idx %= this.hash.length;
            }
            return idx;
        }
    }

    private static final class Point
    implements Comparable<Point> {
        final int hash;
        final Object item;

        private Point(int hash, Object item) {
            this.hash = hash;
            this.item = item;
        }

        @Override
        public int compareTo(Point that) {
            return Integer.compare(this.hash, that.hash);
        }
    }
}

