/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.RestrictedSince;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import jenkins.util.JenkinsClassLoader;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="TODO")
public class ClassLoaderReflectionToolkit {
    private static <T extends Exception> Object invoke(Method method, Class<T> exception, Object obj, Object ... args) throws T {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException x) {
            throw new LinkageError(x.getMessage(), x);
        }
        catch (InvocationTargetException x) {
            Throwable x2 = x.getCause();
            if (x2 instanceof RuntimeException) {
                throw (RuntimeException)x2;
            }
            if (x2 instanceof Error) {
                throw (Error)x2;
            }
            if (exception.isInstance(x2)) {
                throw (Exception)exception.cast(x2);
            }
            throw new AssertionError((Object)x2);
        }
    }

    private static Object getClassLoadingLock(ClassLoader cl, String name) {
        if (cl instanceof JenkinsClassLoader) {
            return ((JenkinsClassLoader)((Object)cl)).getClassLoadingLock(name);
        }
        return ClassLoaderReflectionToolkit.invoke(GetClassLoadingLock.GET_CLASS_LOADING_LOCK, RuntimeException.class, cl, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Class<?> loadClass(ClassLoader cl, String name) throws ClassNotFoundException {
        Object object = ClassLoaderReflectionToolkit.getClassLoadingLock(cl, name);
        synchronized (object) {
            Class c = cl instanceof JenkinsClassLoader ? ((JenkinsClassLoader)((Object)cl)).findLoadedClass2(name) : (Class)ClassLoaderReflectionToolkit.invoke(FindLoadedClass.FIND_LOADED_CLASS, RuntimeException.class, cl, name);
            if (c == null) {
                c = cl instanceof JenkinsClassLoader ? ((JenkinsClassLoader)((Object)cl)).findClass(name) : (Class)ClassLoaderReflectionToolkit.invoke(FindClass.FIND_CLASS, ClassNotFoundException.class, cl, name);
            }
            return c;
        }
    }

    @CheckForNull
    public static URL _findResource(ClassLoader cl, String name) {
        URL url = cl instanceof JenkinsClassLoader ? ((JenkinsClassLoader)((Object)cl)).findResource(name) : (cl instanceof URLClassLoader ? ((URLClassLoader)cl).findResource(name) : (URL)ClassLoaderReflectionToolkit.invoke(FindResource.FIND_RESOURCE, RuntimeException.class, cl, name));
        return url;
    }

    @NonNull
    public static Enumeration<URL> _findResources(ClassLoader cl, String name) throws IOException {
        Enumeration urls = cl instanceof JenkinsClassLoader ? ((JenkinsClassLoader)((Object)cl)).findResources(name) : (Enumeration)ClassLoaderReflectionToolkit.invoke(FindResources.FIND_RESOURCES, IOException.class, cl, name);
        return urls;
    }

    private static class FindResources {
        private static final Method FIND_RESOURCES;

        private FindResources() {
        }

        static {
            try {
                FIND_RESOURCES = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            FIND_RESOURCES.setAccessible(true);
        }
    }

    private static class FindResource {
        private static final Method FIND_RESOURCE;

        private FindResource() {
        }

        static {
            try {
                FIND_RESOURCE = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            FIND_RESOURCE.setAccessible(true);
        }
    }

    private static class FindClass {
        private static final Method FIND_CLASS;

        private FindClass() {
        }

        static {
            try {
                FIND_CLASS = ClassLoader.class.getDeclaredMethod("findClass", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            FIND_CLASS.setAccessible(true);
        }
    }

    private static class FindLoadedClass {
        private static final Method FIND_LOADED_CLASS;

        private FindLoadedClass() {
        }

        static {
            try {
                FIND_LOADED_CLASS = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            FIND_LOADED_CLASS.setAccessible(true);
        }
    }

    private static class GetClassLoadingLock {
        private static final Method GET_CLASS_LOADING_LOCK;

        private GetClassLoadingLock() {
        }

        static {
            Method gCLL;
            try {
                gCLL = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
                gCLL.setAccessible(true);
            }
            catch (NoSuchMethodException x) {
                throw new AssertionError((Object)x);
            }
            GET_CLASS_LOADING_LOCK = gCLL;
        }
    }
}

