/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.IntConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.lazy.BuildReference;
import jenkins.model.lazy.BuildReferenceMapAdapter;
import jenkins.model.lazy.LazyLoadRunMapEntrySet;
import jenkins.model.lazy.SortedIntList;
import jenkins.util.MemoryReductionUtil;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AbstractLazyLoadRunMap<R>
extends AbstractMap<Integer, R>
implements SortedMap<Integer, R> {
    private volatile boolean fullyLoaded;
    private volatile Index index = new Index();
    private LazyLoadRunMapEntrySet<R> entrySet = new LazyLoadRunMapEntrySet(this);
    private volatile transient Set<Integer> keySet;
    private volatile transient Collection<R> values;
    private volatile SortedIntList numberOnDisk = new SortedIntList(0);
    protected File dir;
    private static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    static final Logger LOGGER = Logger.getLogger(AbstractLazyLoadRunMap.class.getName());

    @Override
    public Set<Integer> keySet() {
        AbstractSet<Integer> ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new AbstractSet<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return new Iterator(){
                        private final Iterator<Map.Entry<Integer, R>> it;
                        {
                            this.it = AbstractLazyLoadRunMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        public Integer next() {
                            return this.it.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }

                @Override
                public Spliterator<Integer> spliterator() {
                    return new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 21){
                        private final Iterator<Integer> it;
                        {
                            this.it = this.iterator();
                        }

                        @Override
                        public boolean tryAdvance(IntConsumer action) {
                            if (action == null) {
                                throw new NullPointerException();
                            }
                            if (this.it.hasNext()) {
                                action.accept(this.it.next());
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Comparator<Integer> getComparator() {
                            return Collections.reverseOrder();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractLazyLoadRunMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractLazyLoadRunMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractLazyLoadRunMap.this.clear();
                }

                @Override
                public boolean contains(Object k) {
                    return AbstractLazyLoadRunMap.this.containsKey(k);
                }
            };
        }
        return ks;
    }

    @Override
    public Collection<R> values() {
        AbstractCollection vals = this.values;
        if (vals == null) {
            this.values = vals = new AbstractCollection<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new Iterator<R>(){
                        private final Iterator<Map.Entry<Integer, R>> it;
                        {
                            this.it = AbstractLazyLoadRunMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public R next() {
                            return this.it.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }

                @Override
                public Spliterator<R> spliterator() {
                    return Spliterators.spliteratorUnknownSize(this.iterator(), 17);
                }

                @Override
                public int size() {
                    return AbstractLazyLoadRunMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractLazyLoadRunMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractLazyLoadRunMap.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractLazyLoadRunMap.this.containsValue(v);
                }
            };
        }
        return vals;
    }

    @Restricted(value={NoExternalUse.class})
    protected AbstractLazyLoadRunMap(File dir) {
        this.initBaseDir(dir);
    }

    @Restricted(value={NoExternalUse.class})
    protected void initBaseDir(File dir) {
        assert (this.dir == null);
        this.dir = dir;
        if (dir != null) {
            this.loadNumberOnDisk();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public final boolean baseDirInitialized() {
        return this.dir != null;
    }

    public final void updateBaseDir(File dir) {
        this.dir = dir;
    }

    public synchronized void purgeCache() {
        this.index = new Index();
        this.fullyLoaded = false;
        this.loadNumberOnDisk();
    }

    private void loadNumberOnDisk() {
        String[] kids = this.dir.list();
        if (kids == null) {
            kids = MemoryReductionUtil.EMPTY_STRING_ARRAY;
        }
        SortedIntList list = new SortedIntList(kids.length / 2);
        for (String s : kids) {
            try {
                list.add(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        list.sort();
        this.numberOnDisk = list;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return Collections.reverseOrder();
    }

    @Override
    public boolean isEmpty() {
        return this.search(Integer.MAX_VALUE, Direction.DESC) == null;
    }

    @Override
    public Set<Map.Entry<Integer, R>> entrySet() {
        assert (this.baseDirInitialized());
        return this.entrySet;
    }

    public SortedMap<Integer, R> getLoadedBuilds() {
        return Collections.unmodifiableSortedMap(new BuildReferenceMapAdapter(this, this.index.byNumber));
    }

    @Override
    public SortedMap<Integer, R> subMap(Integer fromKey, Integer toKey) {
        R start = this.search(fromKey, Direction.DESC);
        if (start == null) {
            return EMPTY_SORTED_MAP;
        }
        R end = this.search(toKey, Direction.ASC);
        if (end == null) {
            return EMPTY_SORTED_MAP;
        }
        R i = start;
        while (i != end) {
            i = this.search(this.getNumberOf(i) - 1, Direction.DESC);
            assert (i != null);
        }
        return Collections.unmodifiableSortedMap(new BuildReferenceMapAdapter(this, this.index.byNumber.subMap(fromKey, toKey)));
    }

    @Override
    public SortedMap<Integer, R> headMap(Integer toKey) {
        return this.subMap(Integer.MAX_VALUE, toKey);
    }

    @Override
    public SortedMap<Integer, R> tailMap(Integer fromKey) {
        return this.subMap(fromKey, Integer.MIN_VALUE);
    }

    @Override
    public Integer firstKey() {
        R r = this.newestBuild();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return this.getNumberOf(r);
    }

    @Override
    public Integer lastKey() {
        R r = this.oldestBuild();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return this.getNumberOf(r);
    }

    public R newestBuild() {
        return this.search(Integer.MAX_VALUE, Direction.DESC);
    }

    public R oldestBuild() {
        return this.search(Integer.MIN_VALUE, Direction.ASC);
    }

    @Override
    public R get(Object key) {
        if (key instanceof Integer) {
            int n = (Integer)key;
            return this.get(n);
        }
        return (R)super.get(key);
    }

    public R get(int n) {
        return this.getByNumber(n);
    }

    public boolean runExists(int number) {
        return this.numberOnDisk.contains(number);
    }

    @CheckForNull
    public R search(int n, Direction d) {
        switch (d) {
            case EXACT: {
                return this.getByNumber(n);
            }
            case ASC: {
                Iterator iterator = this.numberOnDisk.iterator();
                while (iterator.hasNext()) {
                    R r;
                    int m = (Integer)iterator.next();
                    if (m < n || (r = this.getByNumber(m)) == null) continue;
                    return r;
                }
                return null;
            }
            case DESC: {
                ListIterator iterator = this.numberOnDisk.listIterator(this.numberOnDisk.size());
                while (iterator.hasPrevious()) {
                    R r;
                    int m = (Integer)iterator.previous();
                    if (m > n || (r = this.getByNumber(m)) == null) continue;
                    return r;
                }
                return null;
            }
        }
        throw new AssertionError();
    }

    public R getById(String id) {
        return this.getByNumber(Integer.parseInt(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getByNumber(int n) {
        Index snapshot = this.index;
        if (snapshot.byNumber.containsKey(n)) {
            BuildReference ref = (BuildReference)snapshot.byNumber.get(n);
            if (ref == null) {
                return null;
            }
            R v = this.unwrap(ref);
            if (v != null) {
                return v;
            }
        }
        AbstractLazyLoadRunMap abstractLazyLoadRunMap = this;
        synchronized (abstractLazyLoadRunMap) {
            if (this.index.byNumber.containsKey(n)) {
                BuildReference ref = (BuildReference)this.index.byNumber.get(n);
                if (ref == null) {
                    return null;
                }
                R v = this.unwrap(ref);
                if (v != null) {
                    return v;
                }
            }
            return this.load(n, null);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized int maxNumberOnDisk() {
        return this.numberOnDisk.max();
    }

    protected final synchronized void proposeNewNumber(int number) throws IllegalStateException {
        if (number <= this.maxNumberOnDisk()) {
            throw new IllegalStateException("JENKINS-27530: cannot create a build with number " + number + " since that (or higher) is already in use among " + this.numberOnDisk);
        }
    }

    public R put(R value) {
        return this._put(value);
    }

    protected R _put(R value) {
        return this.put(this.getNumberOf(value), value);
    }

    @Override
    public synchronized R put(Integer key, R r) {
        int n = this.getNumberOf(r);
        Index copy = this.copy();
        BuildReference<R> ref = this.createReference(r);
        BuildReference<R> old = copy.byNumber.put(n, ref);
        this.index = copy;
        if (!this.numberOnDisk.contains(n)) {
            SortedIntList a = new SortedIntList(this.numberOnDisk);
            a.add(n);
            a.sort();
            this.numberOnDisk = a;
        }
        this.entrySet.clearCache();
        return this.unwrap(old);
    }

    private R unwrap(BuildReference<R> ref) {
        return ref != null ? (R)ref.get() : null;
    }

    @Override
    public synchronized void putAll(Map<? extends Integer, ? extends R> rhs) {
        Index copy = this.copy();
        for (R r : rhs.values()) {
            BuildReference<R> ref = this.createReference(r);
            copy.byNumber.put(this.getNumberOf(r), ref);
        }
        this.index = copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeMap<Integer, BuildReference<R>> all() {
        if (!this.fullyLoaded) {
            AbstractLazyLoadRunMap abstractLazyLoadRunMap = this;
            synchronized (abstractLazyLoadRunMap) {
                if (!this.fullyLoaded) {
                    Index copy = this.copy();
                    for (Integer number : this.numberOnDisk) {
                        if (copy.byNumber.containsKey(number)) continue;
                        this.load(number, copy);
                    }
                    this.index = copy;
                    this.fullyLoaded = true;
                }
            }
        }
        return this.index.byNumber;
    }

    private Index copy() {
        return new Index(this.index);
    }

    private R load(int n, Index editInPlace) {
        assert (Thread.holdsLock(this));
        assert (this.dir != null);
        R v = this.load(new File(this.dir, String.valueOf(n)), editInPlace);
        if (v == null && editInPlace != null) {
            editInPlace.byNumber.put(n, null);
        }
        return v;
    }

    private R load(File dataDir, Index editInPlace) {
        assert (Thread.holdsLock(this));
        try {
            R r = this.retrieve(dataDir);
            if (r == null) {
                return null;
            }
            Index copy = editInPlace != null ? editInPlace : new Index(this.index);
            BuildReference<R> ref = this.createReference(r);
            BuildReference<R> old = copy.byNumber.put(this.getNumberOf(r), ref);
            assert (old == null || old.get() == null) : "tried to overwrite " + old + " with " + ref;
            if (editInPlace == null) {
                this.index = copy;
            }
            return r;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + dataDir, e);
            return null;
        }
    }

    protected abstract int getNumberOf(R var1);

    protected String getIdOf(R r) {
        return String.valueOf(this.getNumberOf(r));
    }

    protected BuildReference<R> createReference(R r) {
        return new BuildReference<R>(this.getIdOf(r), r);
    }

    protected abstract R retrieve(File var1) throws IOException;

    public synchronized boolean removeValue(R run) {
        Index copy = this.copy();
        int n = this.getNumberOf(run);
        BuildReference old = (BuildReference)copy.byNumber.remove(n);
        SortedIntList a = new SortedIntList(this.numberOnDisk);
        a.removeValue(n);
        this.numberOnDisk = a;
        this.index = copy;
        this.entrySet.clearCache();
        return old != null;
    }

    public synchronized void reset(TreeMap<Integer, R> builds) {
        Index index = new Index();
        for (R r : builds.values()) {
            BuildReference<R> ref = this.createReference(r);
            index.byNumber.put(this.getNumberOf(r), ref);
        }
        this.index = index;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    public static enum Direction {
        ASC,
        DESC,
        EXACT;

    }

    private class Index {
        private final TreeMap<Integer, BuildReference<R>> byNumber;

        private Index() {
            this.byNumber = new TreeMap(Collections.reverseOrder());
        }

        private Index(Index rhs) {
            this.byNumber = new TreeMap(rhs.byNumber);
        }
    }
}

