/*
 * Decompiled with CFR 0.152.
 */
package jenkins.mvn;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.GlobalSettingsProviderDescriptor;
import jenkins.mvn.Messages;
import jenkins.mvn.SettingsPathHelper;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilePathGlobalSettingsProvider
extends GlobalSettingsProvider {
    private final String path;

    @DataBoundConstructor
    public FilePathGlobalSettingsProvider(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        if (StringUtils.isEmpty((String)this.path)) {
            return null;
        }
        try {
            return SettingsPathHelper.getSettings(build, listener, this.getPath());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to prepare global settings.xml", e);
        }
    }

    @Extension(ordinal=10.0)
    public static class DescriptorImpl
    extends GlobalSettingsProviderDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.FilePathGlobalSettingsProvider_DisplayName();
        }
    }
}

