/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.apitoken;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.apitoken.ApiTokenPropertyConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ApiTokenStats
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(ApiTokenStats.class.getName());
    private List<SingleTokenStats> tokenStats;
    private transient User user;
    @VisibleForTesting
    transient File parent;

    @VisibleForTesting
    ApiTokenStats() {
        this.init();
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    private void init() {
        if (this.tokenStats == null) {
            this.tokenStats = new ArrayList<SingleTokenStats>();
        } else {
            this.keepLastUpdatedUnique();
        }
    }

    private void keepLastUpdatedUnique() {
        HashMap temp = new HashMap();
        this.tokenStats.forEach(candidate -> {
            SingleTokenStats current = (SingleTokenStats)temp.get(((SingleTokenStats)candidate).tokenUuid);
            if (current == null) {
                temp.put(((SingleTokenStats)candidate).tokenUuid, candidate);
            } else {
                int comparison = SingleTokenStats.COMP_BY_LAST_USE_THEN_COUNTER.compare(current, candidate);
                if (comparison < 0) {
                    temp.put(((SingleTokenStats)candidate).tokenUuid, candidate);
                }
            }
        });
        this.tokenStats = new ArrayList(temp.values());
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    void setParent(@NonNull File parent) {
        this.parent = parent;
    }

    private boolean areStatsDisabled() {
        return !ApiTokenPropertyConfiguration.get().isUsageStatisticsEnabled();
    }

    public synchronized void removeId(@NonNull String tokenUuid) {
        if (this.areStatsDisabled()) {
            return;
        }
        boolean tokenRemoved = this.tokenStats.removeIf(s -> ((SingleTokenStats)s).tokenUuid.equals(tokenUuid));
        if (tokenRemoved) {
            this.save();
        }
    }

    public synchronized void removeAll() {
        int size = this.tokenStats.size();
        this.tokenStats.clear();
        if (size > 0) {
            this.save();
        }
    }

    public synchronized void removeAllExcept(@NonNull String tokenUuid) {
        int sizeBefore = this.tokenStats.size();
        this.tokenStats.removeIf(s -> !((SingleTokenStats)s).tokenUuid.equals(tokenUuid));
        int sizeAfter = this.tokenStats.size();
        if (sizeBefore != sizeAfter) {
            this.save();
        }
    }

    @NonNull
    public SingleTokenStats updateUsageForId(@NonNull String tokenUuid) {
        if (this.areStatsDisabled()) {
            return new SingleTokenStats(tokenUuid);
        }
        return this.updateUsageForIdIfNeeded(tokenUuid);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="access is in fact synchronized")
    private synchronized SingleTokenStats updateUsageForIdIfNeeded(@NonNull String tokenUuid) {
        SingleTokenStats stats = this.findById(tokenUuid).orElseGet(() -> {
            SingleTokenStats result = new SingleTokenStats(tokenUuid);
            this.tokenStats.add(result);
            return result;
        });
        stats.notifyUse();
        this.save();
        return stats;
    }

    @NonNull
    public synchronized SingleTokenStats findTokenStatsById(@NonNull String tokenUuid) {
        if (this.areStatsDisabled()) {
            return new SingleTokenStats(tokenUuid);
        }
        return this.findById(tokenUuid).orElse(new SingleTokenStats(tokenUuid));
    }

    @NonNull
    private Optional<SingleTokenStats> findById(@NonNull String tokenUuid) {
        return this.tokenStats.stream().filter(s -> ((SingleTokenStats)s).tokenUuid.equals(tokenUuid)).findFirst();
    }

    @Override
    public synchronized void save() {
        if (this.areStatsDisabled()) {
            return;
        }
        if (BulkChange.contains(this)) {
            return;
        }
        File userFolder = this.getUserFolder();
        if (userFolder == null) {
            return;
        }
        XmlFile configFile = ApiTokenStats.getConfigFile(userFolder);
        try {
            configFile.write(this);
            SaveableListener.fireOnChange(this, configFile);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + configFile, e);
        }
    }

    @CheckForNull
    private File getUserFolder() {
        File userFolder = this.parent;
        if (userFolder == null && this.user != null) {
            userFolder = this.user.getUserFolder();
            if (userFolder == null) {
                LOGGER.log(Level.INFO, "No user folder yet for user {0}", this.user.getId());
                return null;
            }
            this.parent = userFolder;
        }
        return userFolder;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static ApiTokenStats load(@CheckForNull File parent) {
        if (parent == null) {
            return new ApiTokenStats();
        }
        ApiTokenStats apiTokenStats = ApiTokenStats.internalLoad(parent);
        if (apiTokenStats == null) {
            apiTokenStats = new ApiTokenStats();
        }
        apiTokenStats.setParent(parent);
        return apiTokenStats;
    }

    @NonNull
    public static ApiTokenStats load(@NonNull User user) {
        ApiTokenStats apiTokenStats = null;
        File userFolder = user.getUserFolder();
        if (userFolder != null) {
            apiTokenStats = ApiTokenStats.internalLoad(userFolder);
        }
        if (apiTokenStats == null) {
            apiTokenStats = new ApiTokenStats();
        }
        apiTokenStats.user = user;
        return apiTokenStats;
    }

    @VisibleForTesting
    @CheckForNull
    static ApiTokenStats internalLoad(@NonNull File userFolder) {
        ApiTokenStats apiTokenStats = null;
        XmlFile statsFile = ApiTokenStats.getConfigFile(userFolder);
        if (statsFile.exists()) {
            try {
                apiTokenStats = (ApiTokenStats)statsFile.unmarshal(ApiTokenStats.class);
                apiTokenStats.parent = userFolder;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + statsFile, e);
            }
        }
        return apiTokenStats;
    }

    @NonNull
    protected static XmlFile getConfigFile(@NonNull File parent) {
        return new XmlFile(new File(parent, "apiTokenStats.xml"));
    }

    public static class SingleTokenStats {
        private static Comparator<SingleTokenStats> COMP_BY_LAST_USE_THEN_COUNTER = Comparator.comparing(SingleTokenStats::getLastUseDate, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(SingleTokenStats::getUseCounter);
        private final String tokenUuid;
        private Date lastUseDate;
        private Integer useCounter;

        private SingleTokenStats(String tokenUuid) {
            this.tokenUuid = tokenUuid;
        }

        private Object readResolve() {
            if (this.useCounter != null) {
                this.useCounter = Math.max(0, this.useCounter);
            }
            return this;
        }

        private void notifyUse() {
            this.useCounter = this.useCounter == null ? 1 : this.useCounter + 1;
            this.lastUseDate = new Date();
        }

        public String getTokenUuid() {
            return this.tokenUuid;
        }

        public int getUseCounter() {
            return this.useCounter == null ? 0 : this.useCounter;
        }

        public Date getLastUseDate() {
            return this.lastUseDate;
        }

        public long getNumDaysUse() {
            return this.lastUseDate == null ? 0L : Util.daysElapsedSince(this.lastUseDate);
        }
    }
}

