/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves.restarter;

import com.sun.jna.Native;
import com.sun.jna.StringArray;
import hudson.Extension;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.slaves.restarter.SlaveRestarter;
import jenkins.util.JavaVMArguments;

@Extension
public class UnixSlaveRestarter
extends SlaveRestarter {
    private transient List<String> args;
    private static final Logger LOGGER = Logger.getLogger(UnixSlaveRestarter.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    public boolean canWork() {
        try {
            if (File.pathSeparatorChar != ':') {
                return false;
            }
            this.args = JavaVMArguments.current();
            GNUCLibrary.LIBC.getdtablesize();
            int v = GNUCLibrary.LIBC.fcntl(99999, 1);
            GNUCLibrary.LIBC.fcntl(99999, 2, v);
            UnixSlaveRestarter.getCurrentExecutable();
            GNUCLibrary.LIBC.execv("positively/no/such/executable", new StringArray(new String[]{"a", "b", "c"}));
            return true;
        }
        catch (LinkageError | UnsupportedOperationException e) {
            LOGGER.log(Level.FINE, this.getClass() + " unsuitable", e);
            return false;
        }
    }

    @Override
    public void restart() throws Exception {
        int sz = GNUCLibrary.LIBC.getdtablesize();
        for (int i = 3; i < sz; ++i) {
            int flags = GNUCLibrary.LIBC.fcntl(i, 1);
            if (flags < 0) continue;
            GNUCLibrary.LIBC.fcntl(i, 2, flags | 1);
        }
        String exe = UnixSlaveRestarter.getCurrentExecutable();
        GNUCLibrary.LIBC.execv(exe, new StringArray(this.args.toArray(new String[0])));
        throw new IOException("Failed to exec '" + exe + "' " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
    }

    private static String getCurrentExecutable() {
        int pid = GNUCLibrary.LIBC.getpid();
        String name = "/proc/" + pid + "/exe";
        File exe = new File(name);
        if (exe.exists()) {
            try {
                return Files.readSymbolicLink(exe.toPath()).toString();
            }
            catch (IOException | UnsupportedOperationException | InvalidPathException e) {
                LOGGER.log(Level.FINE, "Failed to resolve symlink " + exe, e);
                return name;
            }
        }
        return System.getProperty("java.home") + "/bin/java";
    }
}

