/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util.java;

import io.jenkins.lib.versionnumber.JavaSpecificationVersion;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class JavaUtils {
    private JavaUtils() {
    }

    public static boolean isRunningWithJava8OrBelow() {
        String javaVersion = JavaUtils.getCurrentRuntimeJavaVersion();
        return javaVersion.startsWith("1.");
    }

    public static boolean isRunningWithPostJava8() {
        String javaVersion = JavaUtils.getCurrentRuntimeJavaVersion();
        return !javaVersion.startsWith("1.");
    }

    public static JavaSpecificationVersion getCurrentJavaRuntimeVersionNumber() {
        return JavaSpecificationVersion.forCurrentJVM();
    }

    public static String getCurrentRuntimeJavaVersion() {
        return System.getProperty("java.specification.version");
    }
}

