/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CGit
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public CGit(String repoUrl) {
        super(repoUrl);
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commit/" + this.param(url).add("id=" + changeSet.getId()));
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "diff/" + path.getPath() + this.param(url).add("id=" + changeSet.getId()));
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return CGit.encodeURL(new URL(url, url.getPath() + "tree/" + path.getPath() + this.param(url).add("id=" + changeSet.getParentCommit())));
        }
        return CGit.encodeURL(new URL(url, url.getPath() + "tree/" + path.getPath() + this.param(url).add("id=" + changeSet.getId())));
    }

    @Extension
    @Symbol(value={"cgit"})
    public static class CGITDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "cgit";
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Inherited javadoc commits that req is non-null")
        public CGit newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (CGit)((Object)req.bindJSON(CGit.class, jsonObject));
        }
    }
}

