/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import hudson.Functions;
import hudson.remoting.ProxyException;
import java.io.OutputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.NullOutputStream;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;

public class ErrorAction
implements PersistentAction {
    @NonNull
    private final Throwable error;

    public ErrorAction(@NonNull Throwable error) {
        if (this.isUnserializableException(error)) {
            error = new ProxyException(error);
        } else if (error != null) {
            try {
                Jenkins.XSTREAM2.toXMLUTF8((Object)error, (OutputStream)new NullOutputStream());
            }
            catch (Exception x) {
                error = new ProxyException(error);
            }
        }
        this.error = error;
    }

    private boolean isUnserializableException(@CheckForNull Throwable error) {
        if (error == null) {
            return false;
        }
        if (error.getClass().getClassLoader() instanceof GroovyClassLoader) {
            return true;
        }
        if (error instanceof MissingPropertyException && ((MissingPropertyException)error).getType() != null && ((MissingPropertyException)error).getType().getClassLoader() instanceof GroovyClassLoader) {
            return true;
        }
        if (error instanceof MultipleCompilationErrorsException || error instanceof MissingMethodException) {
            return true;
        }
        if (this.isUnserializableException(error.getCause())) {
            return true;
        }
        for (Throwable t : error.getSuppressed()) {
            if (!this.isUnserializableException(t)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public Throwable getError() {
        return this.error;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return this.error.getMessage();
    }

    public String getUrlName() {
        return null;
    }

    @CheckForNull
    public static FlowNode findOrigin(@NonNull Throwable error, @NonNull FlowExecution execution) {
        FlowNode candidate = null;
        for (FlowNode n : new ForkScanner().allNodes(execution)) {
            ErrorAction errorAction = n.getPersistentAction(ErrorAction.class);
            if (errorAction == null || !ErrorAction.equals(error, errorAction.getError())) continue;
            candidate = n;
        }
        return candidate;
    }

    private static boolean equals(Throwable t1, Throwable t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1.getClass() != t2.getClass()) {
            return false;
        }
        return Functions.printThrowable((Throwable)t1).equals(Functions.printThrowable((Throwable)t2));
    }
}

